unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type
  TFormMain = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    tbNbr: TTrackBar;
    eNbr: TEdit;
    btStart: TButton;
    btExit: TButton;
    StatusBar: TStatusBar;
    GroupBox2: TGroupBox;
    mResult: TMemo;
    cbExp: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    procedure tbNbrChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btStartClick(Sender: TObject);
    procedure btExitClick(Sender: TObject);
    procedure cbExpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    // Die Anzahl der Elemente
    nbr             : integer;
    // aktualisiert die Kontrollelemente
    procedure updateControls();
  public
    { Public-Deklarationen }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

procedure TFormMain.tbNbrChange(Sender: TObject);
begin
    // Kontrollelemente aktualisieren
    updateControls();
end;

// aktualisiert die Kontrollelemente
procedure TFormMain.updateControls();
begin
    if not cbExp.checked then
        self.nbr := tbNbr.position * 10000
    else
        self.nbr := 1 shl (tbNbr.position div 5);

    eNbr.Text := IntToStr( self.nbr );
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
    // Kontrollelemente aktualisieren
    updateControls();
end;

procedure TFormMain.btStartClick(Sender: TObject);
    procedure DivideAndConquerMinMax( const Field : array of byte; const first, last: Integer; var min, max : integer; var cmp : integer );
    var
       _min            : integer;
       _max            : integer;
    begin
        if (last = first) then
        begin
            min := field[ last ];
            max := field[ last ];
            exit;
        end;

        if last = first + 1 then
        begin
            min := Field[ first ];
            max := Field[ last ];
            inc( cmp );
            if min > max then
            begin
                min := Field[ last ];
                max := Field[ first ];
            end;
            exit;
        end;

        // rekursiv aufrufen
        DivideAndConquerMinMax(Field, first, first - 1 + ((last - first + 1) div 2), min, max, cmp );
        DivideAndConquerMinMax(Field, first + ((last - first + 1) div 2), last, _min, _max, cmp );
        // mergen
        if _min < min then
            min := _min;
        if _max > max then
            max := _max;
        inc( cmp, 2 );
    end;
var
    Field           : array of byte;
    i               : integer;
    cmp             : integer;
    min             : integer;
    max             : integer;
    maxI            : integer;

    StartTime       : TDateTime;
    EndTime         : TDateTime;

    deltaTime       : extended;
begin
    StatusBar.SimpleText := 'Erstelle Zufallszahlen ...';
    application.ProcessMessages();

    try

        setLength( Field, nbr );

        randomize();

        // Das Feld initialisieren
        for i := 0 to nbr-1 do
            Field[ i ] := random(256);
    finally
        StatusBar.SimpleText := '';
        application.ProcessMessages();
    end;

    StartTime := Time();

    StatusBar.SimpleText := 'Suche Minimum und Maximum (naive Methode)';
    application.ProcessMessages();

    max := Field[ 0 ];
    min := Field[ 0 ];
    maxI := 0;
    cmp := 0;
    for i := 1 to nbr-1 do
    begin
        inc( cmp );
        if Field[ i ] > max then
        begin
           maxI := i;
           max := Field[ i ];
        end;
    end;
    // vertauschen ...
    i := Field[ nbr-1 ];
    Field[ nbr-1 ] := max;
    Field[ maxI ] := i;
    for i := 1 to nbr-2 do
    begin
        inc( cmp );
        if Field[ i ] < min then
        begin
           min := Field[ i ];
        end;
    end;

    EndTime := Time();
    deltaTime := EndTime - StartTime;
    deltaTime := deltaTime * 3600 * 24 * 1000;

    StatusBar.SimpleText := '';
    application.ProcessMessages();

    mResult.Lines.Clear();
    mResult.Lines.Add( 'Anzahl der Elemente: ' + intToStr( nbr ) );
    mResult.Lines.Add( '' );
    mResult.Lines.Add( 'Naive Methode: ' + IntToStr( cmp ) + ' Vergleiche (2n-3 = ' + IntToStr( 2 * nbr - 3 ) + ')' );
    mResult.Lines.Add( '  bentigte Zeit: ' + IntToStr( Round( DeltaTime ) ) + ' ms' );
    mResult.Lines.Add( '  Minimum: ' + intToStr( Min ) + ' Maximum: ' + IntToStr( Max ) );

    // Divide and Conquer
    StatusBar.SimpleText := 'Suche Minimum und Maximum (Divide and Conquer)';
    application.ProcessMessages();

    StartTime := Time();
    cmp := 0;
    DivideAndConquerMinMax( field, 0, nbr-1, min, max, cmp );
    EndTime := Time();
    deltaTime := EndTime - StartTime;
    deltaTime := deltaTime * 3600 * 24 * 1000;
    mResult.Lines.Add( '' );
    mResult.Lines.Add( 'Divide and Conquer: ' + IntToStr( cmp ) + ' Vergleiche (1,5n-2 = ' + IntToStr( round( 1.5 * nbr - 2 ) ) + ')' );
    mResult.Lines.Add( '  bentigte Zeit: ' + IntToStr( Round( DeltaTime ) ) + ' ms' );
    mResult.Lines.Add( '  Minimum: ' + intToStr( Min ) + ' Maximum: ' + IntToStr( Max ) );

    StatusBar.SimpleText := '';
    application.ProcessMessages();
end;

procedure TFormMain.btExitClick(Sender: TObject);
begin
    if MessageDlg( 'Wollen Sie wirklich beenden?', mtConfirmation, [mbYes, mbNo], 0 ) = mrYes then
       application.terminate();
end;

procedure TFormMain.cbExpClick(Sender: TObject);
begin
    // Kontrollelemente aktualisieren
    updateControls();
end;

end.
