unit frm_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    GroupBox2: TGroupBox;
    Label5: TLabel;
    Edit4: TEdit;
    Button1: TButton;
    Edit3: TEdit;
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure doGlobalAlignment();
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Edit1Change(Sender: TObject);
begin
	doGlobalAlignment();
end;

// will re-calculate the best alignment of the two given strings
procedure TForm1.doGlobalAlignment();
var
	D	: array of array of real;

	function max( i, j, k: real ) : real;
	begin
		if (k > j) then
		     if (k > i) then
			result := k
		     else
			result := i
		else
			if (j > i) then
				result := j
			else
				result := i;
	end;

	function distance( a,b: char ) : real;
	begin
		if (a=b) then
			result := 1
		else if ((a=#0) or (b=#0)) then
			result := 0
		else
			result := -1;
	end;

	procedure doGlobalAlignment( u,v: string; i,j : integer );
	var
		n,m	: integer;
	begin
		D[0,0] := 0;
		n := length(u);
		m := length(v);

		for i:=1 to n do
			D[i,0] := D[i-1,0]+distance(u[i],#0);
		for j:=1 to m do
			D[0,j] := D[0,j-1]+distance(#0,v[j]);
		for i:=1 to n do
			for j:=1 to m do
				D[i,j] := max(
					D[i,j-1]+distance(#0,v[j]),
					D[i-1,j]+distance(u[i],#0),
					D[i-1,j-1]+distance(u[i],v[j])
				);
	end;
var
	u, v: string;
	n, m: integer;
begin
	u := Edit1.Text;
	v := Edit2.Text;

	n := length( u );
	m := length( v );

	SetLength( D, n+1, m+1 );

	doGlobalAlignment( u, v, n, m );

	self.Edit4.Text := FloatToStr( D[n, m] );
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
	doGlobalAlignment();
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	doGlobalAlignment();
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
	Application.Terminate;
end;

end.
