package pacman3d.util;

import org.w3c.dom.*;

/**
 * <b>Title:</b>      	Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * Eine mehr oder weniger groe Sammlung von Methoden zum einfacheren Handling
 * von XML-Daten mit dem Document Object Model<br>
 *
 * <b>Copyright:</b>	Copyright (c) 2001-2002<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             06.01.2002<br>
 */

public class XmlUtils {

	/**
	 * zur Zeit wird noch nicht viel konstruiert hier, aber mglicherweise
	 * werden spter einige Klassenvariablen gesetzt.
	 */
        public XmlUtils() {

        }

	/**
	 * Holt das erste Element mit dem angegebenen Namen aus dem angegebenen Node
	 * oder liefert null zurck, wenn keines gefunden wurde
	 *
	 * @param elParent das (Eltern)element, das durchsucht werden soll
	 * @param sTagName der Name des gesuchten Elements
	 * @return wenn gefunden das Element mit dem Namen sTagName, sonst null
	 */
	public static Element getChildElement (Element elParent, String sTagName) {

		NodeList oList = elParent.getElementsByTagName(sTagName);
		if (oList.getLength() < 1) {
			// Debug.out ("XmlUtils", "kein <" + sTagName + ">-Element gefunden!", Debug.LEVEL_WARNING);
			return null;
		} else {
		        if (oList.getLength() > 1) {
			        Debug.out ("XmlUtils", "mehr als ein <" + sTagName + ">-Element gefunden, verwende erstes im Dokument.", Debug.LEVEL_WARNING);
			}

			// das <sTagName>-Element ist da
			Element elFound = (Element)oList.item(0);
			return elFound;
		}

	}

	/**
	 * Holt den konkatenierten Text der direkten Kinderknoten vom Typ Text.
	 * Damit wird ein Auslesen von Elementen, die nur einen Textnode enthalten,
	 * also eine Textinformation, erheblich vereinfacht.
	 *
	 * @param elParent das (Eltern)element, das durchsucht werden soll
	 * @return die konkatenierten Strings der direkten Textnode-Kinder oder
	 * ein leer-String (""), falls keine direkten Textkinder
	 */
	public static String getTextFromChildren (Element elThis) {

		NodeList oList = elThis.getChildNodes();
		if (oList.getLength() < 1) {
			return "";
		} else {
			String sOut = "";
			for (int i=0; i<oList.getLength(); i++) {
				Node ndCurrent = oList.item(i);
				if (ndCurrent.getNodeType() == Node.TEXT_NODE) {
				        sOut += ndCurrent.getNodeValue();
				}
			}
			return sOut;
		}

	}

	/**
	 * holt den konkatenierten Text der Kinderknoten eines Kinderelements des
	 * angegebenen Element elParent mit Namen sTagName (Kombination aus den
	 * Methoden getTextFromChildren() und getChildElement())
	 *
	 * @param elParent das (Eltern)element, das durchsucht werden soll
	 * @param sTagName der Name des gesuchten Elements
	 * @return die konkatenierten Strings der direkten Textnode-Kinder des
	 * gefundenen Elements oder ein leer-String (""), falls keine direkten Textkinder
	 */
	public static String getTextFromChildElement (Element elParent, String sTagName) {

		// das erste Element mit dem angegebenen Tagnamen von elParent holen
		Element elCurrent;
		elCurrent = XmlUtils.getChildElement(elParent, sTagName);

		// existiert ein Element dieses Namens, dann auch seine Textkinder als
		// String holen und zurckgeben
		String sOut = "";
		if (elCurrent != null) {
			sOut = XmlUtils.getTextFromChildren(elCurrent);
		}

	        return sOut;
	}

	/**
	 * erzeugt ein Element mit dem Namen sTagName. In dieses Element wird ein
	 * Kind vom Typ Text mit dem String aus sText als Wert eingehngt. Mit der
	 * Methode wird das Erzeugen von XML-Strukturen fr Elemente mit reinem
	 * Textinhalt vereinfacht.
	 *
	 * @param sTagName der Name des anzulegenden Elements
	 * @param sText der Text, der in den Textkinderknoten gesetzt werden woll
	 * @return das erzeugte Element, dass den Textnode beinhaltet
	 */
	public static Element createElementWithTextNode (Document oDoc, String sTagName, String sText) {

		// Element mit Name sTagName erzeugen, Textnode mit sText als Inhalt
		// erzeugen und einhngen, danach alles zurckgeben
		Element elCurrent = oDoc.createElement (sTagName);
		Text txCurrent = oDoc.createTextNode(sText);
		elCurrent.appendChild(txCurrent);

		return elCurrent;
	}

}