package pacman3d.util;

import java.io.*;
import org.w3c.dom.*;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import pacman3d.util.*;
import pacman3d.labyrinth.*;
import pacman3d.labyrinth.cells.*;
import pacman3d.labyrinth.items.*;

/**
 * <b>Title:</b>      	Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * Eine Testklasse fr den Import der Leveldaten im XML-Format<br>
 *
 * <b>Copyright:</b>	Copyright (c) 2001-2002<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             06.01.2002<br>
 */

public class XmlTest {

        public XmlTest() {

	        writeTest();

	}

	/**
	 * some tests of creating and writing xml
	 */
	public void writeTest() {

		// build some xml structures
		Document doc;
		try {
		        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
		        doc = docBuilder.newDocument ();

			// das Dokumentelement erzeugen (<gamelevel>)
			Element elGameLevel = doc.createElement (LevelXmlSyntax.TAG_GAMELEVEL);
			doc.appendChild (elGameLevel);

			// schreiben der level meta infos
			LevelMetaInfo m_oLevelMetaInfo = new LevelMetaInfo();
			Element elLevelMetaInfo = m_oLevelMetaInfo.saveToDOM(doc);
			elGameLevel.appendChild(elLevelMetaInfo);

			// schreiben der aktuellen Cell-Instanzen
			Element elLevelStructure = doc.createElement (LevelXmlSyntax.TAG_LEVELSTRUCTURE);
			doc.appendChild (elLevelStructure);

			// die Flure Zelle fr Zelle dumpen
			Element elFloors = doc.createElement (LevelXmlSyntax.TAG_FLOORS);
			doc.appendChild (elFloors);

			// hole die Labyrinth-Constraints und setze Attribute
			int iMaxX=10, iMaxY=10, iMaxZ=10;
			/*iMaxY = m_p3iConstraints.x;
			iMaxX = m_p3iConstraints.y;
			iMaxZ = m_p3iConstraints.z;*/
			elFloors.setAttribute(LevelXmlSyntax.ATTR_COLS, ""+iMaxX);
			elFloors.setAttribute(LevelXmlSyntax.ATTR_ROWS, ""+iMaxZ);

			// m_p3iConstraints = new Point3i(labyrinth[1].length, labyrinth.length, labyrinth[1][1].length);
			Cell oCell = null;  Element elCell = null;
			for (int iY = 0; iY < iMaxY; iY++) {

			        // neues Floor-Element erzeugen
				Element elCurrentFloor = doc.createElement(LevelXmlSyntax.TAG_FLOOR);

				for (int iX = 0; iX < iMaxX; iX++) {
					for (int iZ = 0; iZ < iMaxZ; iZ++) {
						/*oCell = labyrinth[iY][iX][iZ];
						elCell = oCell.saveToDOM(doc);
						elCurrentFloor.appendChild(elCell);*/
					}
				}

				// den aktuellen Flur in die Flurliste packen
				elFloors.appendChild(elCurrentFloor);

			}

		        // aktuellen CellHandler dumpen
		        CellHandler oCellHandler = CellHandler.getInstance();
			Element elCellTypes = oCellHandler.saveToDOM(doc);
			if (elCellTypes != null) { elGameLevel.appendChild(elCellTypes); }

		        // aktuellen ItemHandler dumpen
		        ItemHandler oItemHandler = ItemHandler.getInstance();
			Element elItemTypes = oItemHandler.saveToDOM(doc);
			if (elItemTypes != null) { elGameLevel.appendChild(elItemTypes); }

		        // aktuellen ResourceHandler dumpen
			ResourceHandler oResourceHandler = pacman3d.util.ResourceHandler.getInstance();
	        	Element elResources = oResourceHandler.saveToDOM(doc);
			if (elResources != null) { elGameLevel.appendChild(elResources); }

			// anschlieend schreiben wir das alles in die angegebene Datei
			PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("created_level_1.xml")));
		        out.print(elGameLevel.toString());
			//DEBUG:
			System.out.print(elGameLevel.toString());
			out.close();

		} catch (Throwable t) {
		        t.printStackTrace ();
		}

	}

	/**
	 * some xml parsing experiences
	 */
	public void readTest() {

		/* first read in some xml data via DOM */
		Document doc;
		try {
		        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();

			/* java.io.StringBufferInputStream oInputXML =
		          new java.io.StringBufferInputStream("<?xml version=\"1.0\"?><game><muhu>testtext</muhu></game>");
  			  doc = docBuilder.parse (oInputXML); */
			doc = docBuilder.parse (new File ("C:\\Dokumente und Einstellungen\\wleklinski\\Eigene Dateien\\WS 2001 2002\\WS 2001 2002 Praktikum Computergrafik\\doc\\levelfiles\\levelexample1.xml"));

		        // normalize text representation
		        doc.getDocumentElement ().normalize ();

		        System.out.println ("Root element of the xml doc is " +
		          doc.getDocumentElement().getNodeName());

			Element elDoc = doc.getDocumentElement();

			/* Element elServus = doc.createElement("servus");
			elDoc.appendChild(elServus);

			System.out.println (elDoc);

			if (elDoc.hasChildNodes()) {
			        NodeList oDocChilds = elDoc.getChildNodes();
				for (int i = 0; i < oDocChilds.getLength(); i++) {
				        Node ndCurrent = oDocChilds.item(i);
					if (ndCurrent instanceof Element) {
						Element elCurrent = (Element)ndCurrent;
					        System.out.println ("ich bin ein Element: " + elCurrent.getTagName());
					}
				}
			} */

			// hier mu ein Dispatcher die ntigen den xml-tags entsprechenden
			// Elemente instanzieren (auch rekursiv teilweise, so dass hier nur
			// die obersten Tags verarbeitet werden!) und dann die entsprechenden
			// loadFromDOM-Methoden mit den Elementknoten aufrufen

			// suche das <common>-Element, instanziere ein LevelMetaInfo-Objekt
			// und lade es mit den Daten
			Element elCommon = XmlUtils.getChildElement (elDoc, LevelXmlSyntax.TAG_COMMON);
			LevelMetaInfo oLevelMetaInfo = new LevelMetaInfo ();
			oLevelMetaInfo.loadFromDOM(elCommon);

			// suche das <resources>-Element und gebe es an den Resourcenhandler
			Element elResources = XmlUtils.getChildElement (elDoc, LevelXmlSyntax.TAG_RESOURCES);
			ResourceHandler oResourceHandler = pacman3d.util.ResourceHandler.getInstance();
			oResourceHandler.loadFromDOM(elResources);

			// suche das <types>-Element und gebe es an den CellTypeHandler
			/* NOT YET! */
                        Element elTypes = XmlUtils.getChildElement (elDoc, "celltypes" );
			CellHandler oCellTypeHandler = pacman3d.util.CellHandler.getInstance();
			oCellTypeHandler.loadFromDOM(elTypes);

			// suche das <levelstructure>-Element und beginne den Aufbau des Levels
			Element elLevelStructure = XmlUtils.getChildElement (elDoc, LevelXmlSyntax.TAG_LEVELSTRUCTURE);

			// ! wenn das fehlt, mu es Exceptions hageln! sonst ist das alles andere als robust

			// das <levelstructure>-Element hat eine Reihe von Kinderelementen. Dazu zhlen
			// <pacmen>, <monsters> und <floors>. Zunchst wenden wir uns hier den floors
			// - also den eigentlichen Labyrinth-Konstruktionsdaten - zu. Das <floors>-Element
			// enthlt seinerseits fr jede Ebene ein <floor>-Element, in dem eine Reihe von
			// Zellen stehen knnen (<cell>). Die Zellen werden linear aneinandergereiht,
			// die Hhe und Breite ergibt sich durch die festgesetzten Grenangaben des Levels.
		        Element elFloors = XmlUtils.getChildElement (elLevelStructure, LevelXmlSyntax.TAG_FLOORS);
			NodeList oFloors = elFloors.getElementsByTagName(LevelXmlSyntax.TAG_FLOOR);

			// durchlaufe die Flure und schaue, was da fr Zellen drin sind
			if (oFloors.getLength() > 0) {
			        for (int iFloorCounter = 0; iFloorCounter < oFloors.getLength(); iFloorCounter++) {
				        Element elCurrentFloor = (Element)oFloors.item(iFloorCounter);

					// durchlaufe den Flur und erzeuge Zelleninstanzen
					NodeList oCells = elCurrentFloor.getElementsByTagName(LevelXmlSyntax.TAG_CELL);
					if (oCells.getLength() > 0) {
						for (int iCellCounter = 0; iCellCounter < oCells.getLength(); iCellCounter++) {

						}
					}
				}
			} else {
			        // execption!  -> keine Flure definiert!
			}


		} catch (SAXParseException err) {
		        System.out.println ("** Parsing error"
		          + ", line " + err.getLineNumber ()
		          + ", uri " + err.getSystemId ());
		        System.out.println("   " + err.getMessage ());
		        // print stack trace as below

		} catch (SAXException e) {
		        Exception x = e.getException ();
		        ((x == null) ? e : x).printStackTrace ();

		} catch (Throwable t) {
		        t.printStackTrace ();
		}

        }


        public static void main(String[] args) {
                XmlTest xmlTest1 = new XmlTest();
        }
}