package pacman3d.util;

/**
 * <b>Title:</b>      	Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * Interface fuer die XML Serialisierung und Deserialisierung von Objekten,
 * wie sie z.B. fuer die Erzeugung bzw. das Einlesen von Spielleveldateien
 * noetig ist.
 * Klassen, die das Interface implementieren, muessen Methoden/Funktionalitaet
 * zur XML (De-)Serialisierung bereitstellen.
 *
 * <b>Copyright:</b>	Copyright (c) 2001<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             4.12.2001<br>
 */
public interface XMLSerializeable {

        /**
         * Nimmt ein XML-Element entgegen, und deserialisiert den Zustand der
	 * darin gespeicherten Instanz.
         *
         * @param oElement      Das XML-Element, unterhalb dessen ein Objekt
         *                      seinen Zustand speichern darf.
         */
        public void loadFromDOM( org.w3c.dom.Element oElement ) throws
                java.lang.ClassNotFoundException, XMLMissingAttributeException;

        /**
         * Serialisiert den Zustand der Instanz in ein XML-Element.
         *
	 * @param oDoc das Document, in das die Daten eingefgt werden sollen
	 * (wird fr das Erzeugen von Elementen nach dem Factory-Konzept bentigt)
         * @return Valide XML-Daten in String-Form.
         */
        public org.w3c.dom.Element saveToDOM(org.w3c.dom.Document oDoc);

}