package pacman3d.util;

/**
 * <b>Title:</b>      	Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * <p>Eine Container-Klasse fuer Objekte, die vom <code>TypeHandler</code>
 * verwaltet werden. Der <code>TypeHandler</code>, bzw. davon abgeleitete
 * Klassen, uebernimmt die Verwaltung von Objekten in einem Objektpool.
 * Der <code>TypeHandler</code> bietet Merkmale wie z.B. Instanzen-Caching
 * und XML-Serialisierung/Deserialisierung. Jedes Objekt, welches vom
 * <code>TypeHandler</code> verwaltet wird, verfuegt ueber eine eindeutige
 * Bezeichnung, seinen &quot;Namen&quot;, ueber den es angesprochen werden
 * kann.</p>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             10.2.2002<br>
 * @see                 pacman3d.util.TypeHandler
 */
public class TypeHandlerItem {

        /**
         * Der Name des Typs.
         */
        private String m_sName;

        /**
         * Das Objekt.
         */
        private Object m_oInstance;

        /**
         * Eine Variable die jedes Mal dann hochgezaehlt wird, wenn ein neuer
         * Name fuer einen Typ erzeugt worden ist. Sie garantiert, dass die
         * erzeugten Namen eindeutig sind.
         */
        private static int m_iNameCreationCounter = 1;

        /**
         * Erzeugt einen neuen Typ mit dem gegebenen Objekt, und erzeugt
         * einen eindeutigen Namen fuer diesen Typ.
         */
        protected TypeHandlerItem( Object oInstance ) {
                this( oInstance, createTypeName( oInstance ) );
        }

        /**
         * Erzeugt eine neue Instanz mit dem gegebenen Namen und dem
         * gegebenen Objekt.
         */
        protected TypeHandlerItem( Object oInstance, String sName ) {
                this.m_oInstance = oInstance;
                this.m_sName = sName;
        }

        /**
         * Erzeugt einen eindeutigen Namen fuer das gegebene Objekt.
         * @param oObject       Das Objekt, fuer welches ein eindeutiger
         *                      Name erzeugt werden soll.
         * @return              Ein eindeutiger Name fuer <code>oObject</code>.
         */
        protected static String createTypeName( Object oObject ) {
                String sResult = oObject.getClass().getName() + "_" +
                        m_iNameCreationCounter++;

                return sResult;
        }

        /**
         * Dupliziert die Instanz, bzw. gibt die Instanz zurueck - je nachdem,
         * ob die Klasse mehrmals verwendet werden darf, oder nicht. Abgeleitete
         * Klassen sollten diese Methode ueberschreiben, sofern sie geklont
         * werden muessen - die Voreinstellung ist die Rueckgabe der Instanz.
         */
        public Object clone() {
                return this;
        }

        /**
         * Liefert den Namen des Typs zurueck.
         */
        public String getName() {
                return m_sName;
        }

        /**
         * Liefert das Objekt zurueck.
         */
        public Object getInstance() {
                return m_oInstance;
        }
}