package pacman3d.util;

/**
 * <b>Title:</b>      	Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * <p>Eine Container-Klasse fuer &quot;Resourcen&quot;.</p>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             10.2.2002<br>
 * @see                 pacman3d.util.TypeHandler
 */
public class ResourceHandlerItem extends TypeHandlerItem {

        /**
         * Der Mimetyp der Ressource, z.B. "image/gif".
         */
        private String m_sMimeType;

        /**
         * Die urspruengliche Dateigroesse der Ressource (in Byte).
         */
        private int m_iSize;

        /**
         * Die Binaerdaten der Ressourcendatei, sofern vorhanden.
         */
        private byte[] m_abData;

        /**
         * Die URL der Ressourcendatei, sofern vorhanden.
         */
        private java.net.URL m_oURL;

        /**
         * Der Dateiname einer eingebetteten Ressourcendatei, sofern vorhanden.
         */
        private String m_sFileName;

        /**
         * Erzeugt eine neue Instanz mit dem gegebenen Namen und dem
         * gegebenen Objekt, und erzeugt einen eindeutigen Bezeichner
         * fuer diesen Resourcentyp.
         *
         * @param oObject       Die Ressource.
         * @param abData        Die binaeren Daten der als Datei gespeicherten
         *                      Ressource - wichtig fuer die Deserialisierung des
         *                      <code>RessourceHandler</code>.
         * @param sMimeType     Der Mimetyp der hinzuzufuegenden Ressource.
         * @param sFileName     Der Dateiname der Ressource, sofern vorhanden.
         */
        protected ResourceHandlerItem( Object oObject, byte[] abData, String
                sMimeType, String sFileName ) {
                super( oObject );
                m_iSize = abData.length;
                m_abData = abData;
                m_sMimeType = sMimeType;
                m_sFileName = sFileName;
        }

        /**
         * Erzeugt eine neue Instanz mit dem gegebenen Namen und dem
         * gegebenen Objekt, und erzeugt einen eindeutigen Bezeichner
         * fuer diesen Resourcentyp.
         *
         * @param oObject       Die Ressource.
         * @param sName         Der eindeutige Bezeichner fr den
         *                      abzulegende Instanztyp.
         * @param abData        Die binaeren Daten der als Datei gespeicherten
         *                      Ressource - wichtig fuer die Deserialisierung des
         *                      <code>RessourceHandler</code>.
         * @param sMimeType     Der Mimetyp der hinzuzufuegenden Ressource.
         * @param sFileName     Der Dateiname der Ressource, sofern vorhanden.
         */
        protected ResourceHandlerItem( Object oObject, String sName,
                byte[] abData, String sMimeType, String sFileName ) {

                super( oObject, sName );
                m_iSize = abData.length;
                m_abData = abData;
                m_sMimeType = sMimeType;
                m_sFileName = sFileName;
        }

        /**
         * Erzeugt eine neue Instanz mit dem gegebenen Namen und dem
         * gegebenen Objekt, und erzeugt einen eindeutigen Bezeichner
         * fuer diesen Resourcentyp.
         *
         * @param oObject       Die Ressource.
         * @param oURL          Eine URL auf die binaeren Daten der als Datei
         *                      gespeicherten
         *                      Ressource - wichtig fuer die Deserialisierung des
         *                      <code>RessourceHandler</code>.
         * @param iSize         Die Groesse der Ressource in Bytes.
         * @param sMimeType     Der Mimetyp der hinzuzufuegenden Ressource.
         */
        protected ResourceHandlerItem( Object oObject, java.net.URL oURL,
                int iSize, String sMimeType ) {

                super( oObject );
                m_sMimeType = sMimeType;
                m_iSize = iSize;
                m_oURL = oURL;
        }

        /**
         * Erzeugt eine neue Instanz mit dem gegebenen Namen und dem
         * gegebenen Objekt, und erzeugt einen eindeutigen Bezeichner
         * fuer diesen Resourcentyp.
         *
         * @param oObject       Die Ressource.
         * @param sName         Der eindeutige Bezeichner fr den
         *                      abzulegende Instanztyp.
         * @param oURL          Eine URL auf die binaeren Daten der als Datei
         *                      gespeicherten
         *                      Ressource - wichtig fuer die Deserialisierung des
         *                      <code>RessourceHandler</code>.
         * @param iSize         Die Groesse der Ressource in Bytes.
         * @param sMimeType     Der Mimetyp der hinzuzufuegenden Ressource.
         */
        protected ResourceHandlerItem( Object oObject, String sName,
                java.net.URL oURL, int iSize, String sMimeType ) {

                super( oObject, sName );
                m_sMimeType = sMimeType;
                m_iSize = iSize;
                m_oURL = oURL;
        }

        /**
         * Erzeugt eine neue Instanz mit dem gegebenen Namen und dem
         * gegebenen Objekt.
         */
        protected ResourceHandlerItem( Object oObject, String sName ) {
                super( oObject, sName );
        }

        /**
         * Liefert die URL der Resource zurueck.
         */
        public java.net.URL getURL() {
                return m_oURL;
        }

        /**
         * Liefert die Groesse der Resource zurueck.
         */
        public int getSize() {
                return m_iSize;
        }

        /**
         * Liefert den Mimetyp der Resource zurueck.
         */
        public String getMimeType() {
                return m_sMimeType;
        }

        /**
         * Liefert die Binaerdaten der Resource zurueck.
         */
        public byte[] getData() {
                return m_abData;
        }

        /**
         * Liefert den Dateinamen einer eingebetteten Resource zurueck, sofern
         * vorhanden.
         */
        public String getFileName() {
                return m_sFileName;
        }

        /**
         * Dupliziert die Zelle.
         */
        public Object clone() {
                return this;
        }

}