package pacman3d.util;

import java.net.URL;
import java.io.*;

import org.w3c.dom.*;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import pacman3d.util.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b><p>Die Klasse nimmt die Metainformationen eines Levels
 * auf und kann diese selbststndig im Levelfile (XML-Format) lesen und speichern.</p>
 * <b>Copyright:</b>Copyright (c) 2001<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version 2001-12-06<br/>
 */

public class LevelMetaInfo implements pacman3d.util.XMLSerializeable {

	/* der Eingabestrom des Levelfiles */
	private InputStream m_oLevelStream;

	private URL m_urlLevel = null;


	/* im Folgenden die mit den XML-Elementen korrespondierenden
	Attribute der Instanz */

	/* der Titel des Levels (aus Element <title>) */
	private String m_sTitle = "";

	/* die Missionsbeschreibung des Levels (aus Element <level>) */
	private String m_sMission = "";

	/* die Versionsnummer des Levels (aus Element <version>) */
	private String m_sVersion = "";

	/* das dem Level zugeordnete Datum (aus Element <date>) */
	private String m_sDate = "";

	/* der Autor des Levels (aus Element <author>) */
	private String m_sAuthor = "";

	/* die Kontaktemailadresse zum Level (aus Element <contactemail>) */
	private String m_sContactEmail = "";

	/* eine URI zum Level (aus Element <uri>) */
	private String m_sUri = "";

	/* die Dateiformatversion der Leveldatei  (aus Element <formatversion>) */
	private String m_sGameVersion = "";


	/* testcomment */


	/**
	 * der Konstruktor erzeugt ein leeres Objekt
	 */
	public LevelMetaInfo() {
	}

	/**
	 * in diesem Konstruktor wird der Inputstrom des korrespondierenden
	 * Levelfiles bergeben und dessen Metadaten selbststndig eingelesen
	 *
	 * @param urlLevel der Dateiname des Levels, von dem die
	 * Metainformationen zu holen sind
	 */
	public LevelMetaInfo(InputStream oLevelStream) {
		this.setLevelStream(oLevelStream);
	}

	/**
	 * in diesem Konstruktor wird der Inputstrom des korrespondierenden
	 * Levelfiles bergeben und dessen Metadaten selbststndig eingelesen
	 *
	 * @param urlLevel der Dateiname des Levels, von dem die
	 * Metainformationen zu holen sind
	 */
	public LevelMetaInfo(URL urlLevel) {
		this.setLevelURL(urlLevel);
	}

	/**
	 * ldt das entweder als URL oder als File spezifizierte Level ein, um
	 * die Metadaten auszulesen
	 */
	public void load() throws InvalidLevelFileException {

		// ffnen des Files und Anstoen des DOM-Erzeugens. Anschlieend
		// Suchen des <common> - Knotens und Aufruf der loadFromDOM-Methode,
		// um die Metadaten zu gewinnen
		Document doc;
		try {
			// Erzeugen des DOM-Parsers und Einlesen des XML-Stroms
			DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
			doc = docBuilder.parse (m_urlLevel.openStream());

			// normalize text representation
			doc.getDocumentElement ().normalize ();
			Element elDoc = doc.getDocumentElement();

			// prfen, ob richtiger Typ gegeben, nmlich DocumentElement = "gamelevel"
			if (!elDoc.getNodeName().equalsIgnoreCase(LevelXmlSyntax.TAG_GAMELEVEL)) {
				// exception aufrufen, da datei nicht gelesen werden kann (das kann vom
				// aufrufenden Programm entweder stillschweigend ignoriert werden
				// oder es erfolgt eine Meldung, dass ungltige Leveldaten vorliegen)
				throw new InvalidLevelFileException
				  ("Die Datei ist kein gltiges Level (\"Dokumentelement ist nicht <"
				  + LevelXmlSyntax.TAG_GAMELEVEL + "> \")");
			}

			// suche nach dem <common>-Element
			Element elCommon = XmlUtils.getChildElement(elDoc, LevelXmlSyntax.TAG_COMMON);
			if (elCommon == null) {
				throw new InvalidLevelFileException
				  ("Die Leveldatei hat ein ungltiges Format (\"Dokument enthlt kein Metainfo-Tag <"
				  + LevelXmlSyntax.TAG_COMMON + "> \")");
			}

			// lade die Daten ein
			loadFromDOM (elCommon);
			Debug.out (this.getClass().getName(), ""+toString(), Debug.LEVEL_NOTICE);

		} catch (SAXParseException err) {

			Debug.out (this.getClass().getName(), "** Parsing error"
			  + ", line " + err.getLineNumber ()
			  + ", uri " + err.getSystemId (), Debug.LEVEL_CRITICAL);
			Debug.out (this.getClass().getName(), "" + err.getMessage ()
			  , Debug.LEVEL_CRITICAL);

			throw new InvalidLevelFileException
			  ("Die Datei ist kein gltiges Level (\" Parsingfehler "
			  + ", line " + err.getLineNumber ()
			  + ", uri " + err.getSystemId ()
			  + "> \")");

		} catch (SAXException e) {
			Exception x = e.getException ();
			((x == null) ? e : x).printStackTrace ();
		} catch (InvalidLevelFileException ilfex) {
			throw ilfex;

		} catch (Throwable t) {
			t.printStackTrace ();
		}

	}

	/**
	 * setzt den Eingabestrom des Levelfiles
	 *
	 * @param oLevelStream der Eingabestrom mit den Leveldaten
	 */
	public void setLevelStream (InputStream oLevelStream) {
		m_oLevelStream = oLevelStream;
	}

	/**
	 * liefert den Eingabestrom object des Levelfiles zurck
	 *
	 * @return der Eingabestrom des Levels
	 */
	public InputStream getLevelStream () {
		return m_oLevelStream;
	}

	/**
	 * setzt die URL des Levelfiles
	 *
	 * @param urlLevel die URL mit den Leveldaten
	 */
	public void setLevelURL (URL urlLevel) {
		m_urlLevel = urlLevel;
	}

	/**
	 * liefert die URL des in dieser Instanz beschriebenen Levels
	 *
	 * @return die URL des Levels
	 */
	public URL getLevelURL () {
		return m_urlLevel;
	}

	/**
	 * setzt das Title-Attribut fr das Level
	 * @param der neue Titel des Levels
	 */
	public void setTitle (String sTitle) {
		m_sTitle = sTitle;
	}

	/**
	 * liefert den Titel des Level
	 * @param der Titel des Levels
	 */
	public String getTitle () {
		return m_sTitle;
	}

	/**
	 * setzt die Missionbeschreibung des Levels
	 * @param die neue Missionbeschreibung des Levels
	 */
	public void setMission (String sMission) {
		m_sMission = sMission;
	}

	/**
	 * liefert die Missionbeschreibung des Levels zurck
	 * @param die Missionsbeschreibung des Levels
	 */
	public String getMission () {
		return m_sMission;
	}

	/**
	 * setzt die Versionsnummer (also das Version-Attribut) fr das Level
	 * @param die neue Versionsnummer des Levels
	 */
	public void setVersion (String sVersion) {
		m_sVersion = sVersion;
	}

	/**
	 * liefert die Versionsnummer des Levels (also das Version-Attribut)
	 * @return die Versionsnummer des Levels
	 */
	public String getVersion () {
		return m_sVersion;
	}

	/**
	 * setzt das dem Level zugeordnete Datum
	 * @param das neue Datum des Levels
	 */
	public void setDate (String sDate) {
		m_sDate = sDate;
	}

	/**
	 * liefert das Datum des Levels
	 * @return das Datum des Levels
	 */
	public String getDate () {
		return m_sDate;
	}

	/**
	 * setzt den Autor des Levels (also das Author-Attribut)
	 * @param der neue Autor des Levels
	 */
	public void setAuthor (String sAuthor) {
		m_sAuthor = sAuthor;
	}

	/**
	 * liefert den Autorennamen des Levels
	 * @return der Name des Autors
	 */
	public String getAuthor () {
		return m_sAuthor;
	}

	/**
	 * setzt die Kontaktemailadresse des Levels
	 * @param die neue Kontaktemailadresse des Levels
	 */
	public void setContactEmail (String sContactEmail) {
		m_sContactEmail = sContactEmail;
	}

	/**
	 * liefert die Kontaktemailadresse des Levels
	 * @return die Kontaktemailadresse des Levels
	 */
	public String getContactEmail () {
		return m_sContactEmail;
	}

	/**
	 * setzt eine beliebige URI fr das Level. Dahinter knnte sich beispielsweise
	 * eine Informationswebsite fr das Level befinden, die Homepage des
	 * Level-Produzenten oder auch der Ort, an dem die Datei abrufbar ist.
	 *
	 * @param die neue URI des Levels
	 */
	public void setUri (String sUri) {
		m_sUri = sUri;
	}

	/**
	 * liefert die dem Level zugeordnete URI. Dahinter knnte sich beispielsweise
	 * eine Informationswebsite fr das Level befinden, die Homepage des
	 * Level-Produzenten oder auch der Ort, an dem die Datei abrufbar ist.
	 * @return die URI des Levels
	 */
	public String getUri () {
		return m_sUri;
	}

	/**
	 * setzt die Version des Leveldateiformats (das formatversion-Attribut),
	 * was im Prinzip auch einer Programmversion des Pacman3D-Spiels entspricht
	 * @param die neue Version des Leveldateiformats
	 */
	public void setGameVersion (String sGameVersion) {
		m_sGameVersion = sGameVersion;
	}

	/**
	 * gibt die Version des Leveldateiformats zurck (das formatversion-Attribut),
	 * was im Prinzip auch einer Programmversion des Pacman3D-Spiels entspricht
	 * @return die Version des Leveldateiformats
	 */
	public String getGameVersion () {
		return m_sGameVersion;
	}

	/**
	 * Nimmt ein XML-Element entgegen, und deserialisiert mit diesem XML-
	 * Element den Zustand von uns selbst.
	 *
	 * @param oElement Das XML-Element, unterhalb dessen unser Objekt
	 * seinen Zustand speichert.
	 */
	public void loadFromDOM (org.w3c.dom.Element oElement) {

		/* In den folgenden Anweisungen wird der Inhalt des <common>-Elements eingelesen
		  <common>
		   <title>The Wild Pacman Adventure</title>
		   <mission>Find all monsters, kill 'em now!</mission>
		   <version>1.00.000</version>
		   <date>2001-12-03</date>
		   <author>Labyrinth-Gruppe (Martin Klossek)</author>
		   <contactemail>martin@klossek3000.de</contactemail>
		   <uri>http://www.stormzone.de/uni/Hauptstudium/CGPR/Labyrinth</uri>
		   <gameversion>0.10.000alpha</gameversion>
		  </common> */

		// Einlesen <title>-Element
		this.m_sTitle = XmlUtils.getTextFromChildElement(oElement, "title");

		// Einlesen <mission>-Element
		this.m_sMission = XmlUtils.getTextFromChildElement(oElement, "mission");

		// Einlesen <version>-Element
		this.m_sVersion = XmlUtils.getTextFromChildElement(oElement, "version");

		// Einlesen <date>-Element
		this.m_sDate = XmlUtils.getTextFromChildElement(oElement, "date");

		// Einlesen <author>-Element
		this.m_sAuthor = XmlUtils.getTextFromChildElement(oElement, "author");

		// Einlesen <contactemail>-Element
		this.m_sContactEmail = XmlUtils.getTextFromChildElement(oElement, "contactemail");

		// Einlesen <uri>-Element
		this.m_sUri = XmlUtils.getTextFromChildElement(oElement, "uri");

		// Einlesen <gameversion>-Element
		this.m_sGameVersion = XmlUtils.getTextFromChildElement(oElement, "gameversion");

	}

	/**
	 * Serialisiert den Zustand des Objektes in einen XML-Stream.
	 *
	 * @return Valide XML-Daten in String-Form.
	 */
	public org.w3c.dom.Element saveToStream() {

		// hmm, not needed anymore!

		return null;
	}

	/**
	 * Serialisiert den Zustand des Objektes in ein XML-Element
	 *
	 * @param oDoc das Document, in das die Daten eingefgt werden sollen
	 * (wird fr das Erzeugen von Elementen nach dem Factory-Konzept bentigt)
	 * @return Valide XML-Daten in String-Form.
	 */
	public org.w3c.dom.Element saveToDOM(Document oDoc) {

		// Erzeuge das <common>-Element, dass die einzelnen Infotags und
		// deren Text aufnimmt
		Element elCommon = oDoc.createElement("common");

		// Erzeuge das <title>-Element mit Inhalt
		elCommon.appendChild (XmlUtils.createElementWithTextNode (oDoc, "title", this.m_sTitle));

		// Erzeuge das <mission>-Element mit Inhalt
		elCommon.appendChild (XmlUtils.createElementWithTextNode (oDoc, "mission", this.m_sMission));

		// Erzeuge das <version>-Element mit Inhalt
		elCommon.appendChild (XmlUtils.createElementWithTextNode (oDoc, "version", this.m_sVersion));

		// Erzeuge das <date>-Element mit Inhalt
		elCommon.appendChild (XmlUtils.createElementWithTextNode (oDoc, "date", this.m_sDate));

		// Erzeuge das <author>-Element mit Inhalt
		elCommon.appendChild (XmlUtils.createElementWithTextNode (oDoc, "author", this.m_sAuthor));

		// Erzeuge das <contactemail>-Element mit Inhalt
		elCommon.appendChild (XmlUtils.createElementWithTextNode (oDoc, "contactemail", this.m_sContactEmail));

		// Erzeuge das <uri>-Element mit Inhalt
		elCommon.appendChild (XmlUtils.createElementWithTextNode (oDoc, "uri", this.m_sUri));

		// Erzeuge das <gameversion>-Element mit Inhalt
		elCommon.appendChild (XmlUtils.createElementWithTextNode (oDoc, "gameversion", this.m_sGameVersion));

		return elCommon;
	}

	/**
	 * gibt eine String-Reprsentation der Instanz zurck
	 * @return die menschenlesbare Reprsentation der Instanz als String
	 */
	public String toString() {
		String sOut = "Level - '" + m_sTitle + "'";
		return sOut;
	}

}