package pacman3d.util;

import java.net.URL;
import java.util.Vector;
import java.io.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b><p>Die Klasse sucht im lokalen oder im spezifizierten
 * Verzeichnispfad nach Leveldateien (Endung .p3d) und stellt deren
 * Metainformationen mit jeweils einer Instanz von LevelMetaInfo in einem
 * Vector bereit.</p>
 * <b>Copyright:</b>Copyright (c) 2001<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version 2001-12-06<br/>
 */

public class LevelHandler {

	/**
	 * initialisiert die Instanz. Mit diesem Konstruktor werden das aktuelle
	 * Arbeitsverzeichnis und Unterverzeichnise als potentielle Speicherorte
	 * fr Leveldaten (Endung .p3d) gesetzt.
	 */
        public LevelHandler() {

        }

	/**
	 * initialisiert die Instanz. Mit diesem Konstruktor wird das bergebene
	 * Arbeitsverzeichnis als potentieller Speicherort fr Leveldaten
	 * (Endung .p3d) gesetzt.
	 *
	 * @param uriWorkingDirectory das Arbeitsverzeichnis, in dem nach
	 * Leveldateien gesucht werden soll.
	 */
        public LevelHandler(URL urlWorkingDirectory) {

        }

	/**
	 * gibt die im gesetzten Arbeitsverzeichnis gefundenen Leveldaten in einem
	 * Vector zurck. Jedes gefundene Level wird dabei geprft. Seine
	 * Metainformationen werden eingelesen und in einem LevelMetaInfo-Objekt
	 * abgelegt.
	 *
	 * @return die LevelMetaInfo-Instanzen der gefundenen Leveldateien
	 */
	public Vector getLevels() {

	        /* einen neuen Vector erzeugen, der mit den Level Meta Info
		Objekten gefllt und zurckgegeben wird */
	        Vector vecLevels = new Vector();

                // einen Filter erzeugen
                pacman3d.util.LevelFileFilter oLevelFileFilter =
                        new pacman3d.util.LevelFileFilter();

		// alle .xml-Dateien im levels suchen und dann in LevelMetaInfos einlesen
		File filePath = new File ("levels");
		File[] oFiles = filePath.listFiles( oLevelFileFilter );
		if (oFiles == null) {
			Debug.out (this.getClass().getName(), "no levels found", Debug.LEVEL_NOTICE);
		} else {

			// Durchlaufen der gefundenen Dateien
		        for (int i = 0; i < oFiles.length; i++) {

				String sFileName = oFiles[i].toString(); // "levels/levelexample1.xml";
				// Debug.out ("", ""+sFileName);

				LevelMetaInfo oLevelInfo = new LevelMetaInfo();
				try {
					oLevelInfo.setLevelURL(new URL("file:" + sFileName));
					oLevelInfo.load();

					// wenn uns keine Exception erschttert hat,
					// dann wird die MetaInfo der Liste hinzugefgt
					vecLevels.add(oLevelInfo);

				} catch (java.net.MalformedURLException muex) {
					// exception werfen oder einfach schweigen ;)
				} catch (InvalidLevelFileException ilfex) {
				        // Debugausgabe, dass ein ungltiges File im
					// levels-Verzeichnis gefunden wurde
					Debug.out(this.getClass().getName(), "Datei " + sFileName
					  + " kann nicht gelesen werden ("
					  + ilfex.getMessage()
					  + ")" );
				}



			}
		}

		return vecLevels;
	}

}