package pacman3d.util;

/**
 * <b>Title:</b>      	Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * <p>Interface fuer das Abfragen von Informationen ueber Parameterzahl,
 * -namen und -typen von Pacmans, Monstern, Items, etc.</p>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             21.2.2002<br>
 */
public interface Introspectable {

	/**
         * Weist einem Parameter einen Wert zu.
         * @param sName         Der Name des Parameters.
         * @param oValue        Der Wert des Parameters.
         * @see #getParameter
         */
	public void setParameter( String sName, Object oValue );

        /**
         * Gibt den Wert eines Parameters zurueck.
         * @param sName         Der Name des Parameters.
         * @return              Der aktuelle Wert des Parameters.
         * @see #setParameter
         */
	public Object getParameter( String sName );

        /**
         * Gibt die Anzahl der Parameter zurueck, ueber die eine Instanz
         * verfuegt.
         * @return              Anzahl der Parameter.
         */
	public int getParameterCount ();

        /**
         * Gibt den Namen des n-ten Parameters zurueck.
         * @param               Index des Parameters, dessen Name zurueckgegeben
         *                      werden soll. (<code>0&lt;=iPos&lt;getParameterCount()</code>.)
         * @return              Name des n-ten Parameters.
         */
	public String getParameterName( int iPos );

        /**
         * Gibt einen Beschreibungstext fuer den n-ten Parameters zurueck.
         * @param               Index des Parameters, dessen Beschreibung zurueckgegeben
         *                      werden soll. (<code>0&lt;=iPos&lt;getParameterCount()</code>.)
         * @return              Name des n-ten Parameters.
         */
	public String getParameterDescription( int iPos );

        /**
         * Gibt den Typ des n-ten Parameters zurueck.
         * @param               Index des Parameters, dessen Name zurueckgegeben
         *                      werden soll. (<code>0&lt;=iPos&lt;getParameterCount()</code>.)
         * @return              Typ des n-ten Parameters in Form einer Instanz der
         *                      entsprechenden Klasse.
         */
	public Object getParameterType( int iPos );
}