package pacman3d.util;

import java.util.Enumeration;
import javax.media.j3d.*;

import javax.media.j3d.*;
import javax.vecmath.*;

import pacman3d.Game;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b>Behavior wird verwendet, um von Java3D mittels eines
 * Ereignisses zu erfahren, wann der erste Frame gerendert wurde (hierzu wird
 * der Stimulus WakeupOnElapsedFrames(1, false) verwendet)
 * <b>Copyright:</b>	Copyright (c) 2001-2002<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             $Date: 2002/03/18 09:27:21 $<br>
 */


public class GameStartBehavior extends Behavior {

	/* das Stimulus-Event fr die Anzahl gerenderter Frames */
	private WakeupOnElapsedFrames oWakeUpEvent = null;

	/* das Spiel, in dem diese Instanz verankert ist */
	private Game m_oGame = null;


	/**
	 * Konstruiert ein neues GameStartBehavior-Objekt, dass dem
	 * Szenegraphen hinzugefgt werden mu
	 *
	 * @param oGame das Spiel, in dem das Behavior eingefgt wird
	 */
	public GameStartBehavior(Game oGame) {

		m_oGame = oGame;
		setSchedulingBounds (new BoundingSphere(new Point3d(0.0f, 0.0f, 0.0f), 10.0f));
		setEnable (true);

	}

	/**
	 * Methode initialisiert den Stimulus (wird automatisch von Java3D
	 * aufgerufen)
	 */
	public void initialize() {

		// Erzeugen des Stimulus fr die Meldung nach einem gerenderten
		// Frame und "hei"-Schalten
		oWakeUpEvent = new WakeupOnElapsedFrames(1, false);
		wakeupOn(oWakeUpEvent);
	}

	/**
	 * Methode wird von Java3D aufgerufen, wenn der in Initialize definierte
	 * "Wach-auf-nach-1-Frame"-Stimulus eingetreten ist
	 */
	public void processStimulus(Enumeration enumCriteria) {

		// Debug-Meldung zum Testen
		// Debug.out (this.getClass().getName(), "ein Frame wurde gerendert!", Debug.LEVEL_NOTICE);

		// Deaktivieren des Behaviors (wird ja nicht mehr bentigt!)
		setEnable (false);

		// jetzt kann der GameLoop-Thread gestartet werden!
		m_oGame.startGameLoop();

	}

}