package pacman3d.util;

import java.awt.*;

import pacman3d.message.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b><p>Ein Panel, dass einen Rahmen fr die Punkte und
 * sonstige Info-Anzeige am rechten Rand des Spiels bereitstellt.</p>
 * <b>Copyright:</b>Copyright (c) 2001-2002<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version $Date: 2002/03/04 06:39:11 $<br/>
 */

public class GamePanelScore extends GameCockpitPanel {

	// Stringwerte fr die Anzeige
	private String m_sCurrentScore = "0";
	private String m_sCurrentLives = "0";
	private String m_sCurrentItemsLeft = "0";

	// Stringwerte fr Labels
	private String m_sLivesLabel = "LIVES:";



	/**
	 * konstruiert eine neue Instanz des punktestandanzeigenden Panels
	 */
	public GamePanelScore(boolean bMultiplayerGame, boolean bWeAreServer) {
		super(bMultiplayerGame, bWeAreServer);
	}

	/**
	 * wird nach dem Initialisieren des Labyrinths aufgerufen und nimmt den Status
	 * Multiplayer/Singleplayer und die Anzahl der Spieler entgegen (soweit verfgbar!)
	 *
	 * @param bMultiplayerGame true, wenn Multiplayer-Spiel, false wenn Singleplayer
	 * @param bWeAreServer true, wenn diese Applikation der Server ist, false andernfalls
	 */
	public void setGameMode (boolean bMultiplayerGame, boolean bWeAreServer) {
		m_bMultiplayerGame = bMultiplayerGame;
		m_bWeAreServer = bWeAreServer;

		if (m_bMultiplayerGame) {
			m_sLivesLabel = "DEATHS:";
		} else {
			m_sLivesLabel = "LIVES:";
		}
	}

	/**
	 * die paint-Methode zum Malen des Canvas des Panels
	 * @param oGr das Graphics-Objekt zum Bemalen des Canvas
	 */
	public void paint(Graphics oGr) {

		super.paint(oGr);
		Graphics2D g = (Graphics2D) oGr;

		// Ausgabe der konstanten Strings
		g.setColor(new Color(51,76,1));
		Font oFont = new Font("SansSerif", Font.BOLD, 20);
		g.setFont(oFont);
		g.drawString("SCORE:", 30, 100);
		g.drawString(m_sLivesLabel, 30, 125);

		// und dahinter die aktuellen Werte, die von der Nachricht
		// geliefert wurden
		g.setColor(new Color(255,0,0));
		oFont = new Font("SansSerif", Font.BOLD | Font.ITALIC, 20);
		g.setFont(oFont);
		g.drawString(m_sCurrentScore, 130, 100);
		g.drawString(m_sCurrentLives, 130, 125);

		// Anzahl der brigen Score-Items ausgeben
		oFont = new Font("SansSerif", Font.BOLD, 14);
		g.setFont(oFont);
		g.setColor(new Color(51,76,1));
		g.drawString("ITEMS LEFT:", 30, 150);
		g.setColor(new Color(255,0,0));
		g.drawString(m_sCurrentItemsLeft, 130, 150);

	}

	/**
	 * Nimmt eine Nachricht entgegen, die anschliessend ausgewertet wird.
	 * @param oMessage die bergebene Nachricht
	 */
	public void getMessage( Message oMessage ) {

		// Nachricht holen und checken, ob Inhalt dabei
		Object oContent = oMessage.getContent();
		if (oContent == null) { return; }

		// wenn noch da (=Inhalt da!), dann nach Inhaltstyp dispatchen
		if (oContent instanceof ScoreUpdateContent) {
			ScoreUpdateContent oScoreUpdateContent = (ScoreUpdateContent)oContent;

			// neue Werte fr Score und Leben holen und dann ab damit
			// in den String, der in paint() ausgegeben wird.
			int iScore = oScoreUpdateContent.getScore();
			int iLives = 0;
			if (m_bMultiplayerGame) {
				iLives = oScoreUpdateContent.getKillCount();
			} else {
				iLives = oScoreUpdateContent.getLives();
			}
			m_sCurrentScore = new Integer(iScore).toString();
			m_sCurrentLives = new Integer(iLives).toString();

			// lassen wir das Fenster neu zeichnen und den
			// Punktestand updaten
			this.repaint();

		} else if (oContent instanceof LabyrinthInfoContent) {
			LabyrinthInfoContent oLabyrinthInfoContent = (LabyrinthInfoContent)oContent;

			// die Anzahl der noch brigen Score-Items holen und ab
			// in den String, der in paint() ausgegeben wird.
			long iItemsLeft = oLabyrinthInfoContent.getItemsLeftCount();
			m_sCurrentItemsLeft = new Long(iItemsLeft).toString();

			// lassen wir das Fenster neu zeichnen und den
			// Punktestand updaten
			this.repaint();
		}

	}

}