package pacman3d.util;

import java.awt.*;

import pacman3d.labyrinth.*;
import pacman3d.message.*;
import pacman3d.labyrinth.items.*;


/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b><p>Ein Panel, dass einen Rahmen fr die Anzeige des
 * Inventars am rechten Rand des Spiels bereitstellt.</p>
 * <b>Copyright:</b>Copyright (c) 2001-2002<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version $Date: 2002/03/04 06:39:26 $<br/>
 */

public class GamePanelInventory extends GameCockpitPanel {

	/* das aktuell angezeigte und selektierte Item */
	private Item m_itemCurrent = null;

	/* der Name des aktuellen Items, der im Panel angezeigt wird */
	private String m_sCurrentItemTitle = "";

	/* Nummer des aktuellen Items und Maximalanzahl ( getrennt durch "/" ) */
	private String m_sCurrentItemPos = "";



	/**
	 * konstruiert eine neue Instanz des Inventory-Panels
	 *
	 * @param bMultiplayerGame true, wenn Multiplayer-Spiel, false wenn Singleplayer
	 * @param bWeAreServer true, wenn diese Applikation der Server ist, false andernfalls
	 */
	public GamePanelInventory(boolean bMultiplayerGame, boolean bWeAreServer) {

		super(bMultiplayerGame, bWeAreServer);

		// einige Einstellungen schon mal setzen (wie Hintergrundfarbe)
		this.setBackground(new Color(80,80,80));

	}

	/**
	 * ldt die Bilder fr die Darstellung ein. Die Methode sollte von
	 * den Nachkommen der Klasse berschrieben werden, wenn sie ein
	 * eigenes Design wnschen.
	 */
	protected void loadImages () {

		// Einladen von Bildern. Knnte man das nicht auch ber den
		// Resourcenhandler abwickeln. Vielleicht so ein
		// Resourcenbeschreibungsfile (in xml), dass immer eingeladen
		// wird, da es fr GameFrame / AboutBox / Hilfe ntig ist.
		imgBorderWithLogo = getToolkit().createImage("media/gameframe/images/cockpit_inventory_1.png");
		imgBorderBottom = getToolkit().createImage("media/gameframe/images/cockpit_border_bottom_2.png");
		imgBorderLeft = getToolkit().createImage("media/gameframe/images/cockpit_border_left_2.png");
		imgBorderRight = getToolkit().createImage("media/gameframe/images/cockpit_border_right_2.png");

		// setzen des Flags "bild geladen" (als Indikator in der Paint-Methode)
		bImagesLoaded = true;
	}

	/**
	 * die paint-Methode zum Malen des Canvas des Panels
	 * @param oGr das Graphics-Objekt zum Bemalen des Canvas
	 */
	public void paint(Graphics oGr) {

		super.paint(oGr);
		Graphics2D g = (Graphics2D) oGr;

		// Ausgabe der konstanten Strings
		g.setColor(Color.black);
		Font oFont = new Font("SansSerif", Font.BOLD, 20);
		g.setFont(oFont);
		g.drawString("ITEM:", 30, 100);

		// und dahinter die aktuellen Werte, die von der Nachricht
		// geliefert wurden
		g.setColor(new Color(196,0,0));
		oFont = new Font("SansSerif", Font.BOLD, 15);
		g.setFont(oFont);
		g.drawString("" + m_sCurrentItemTitle, 35, 125);
		g.drawString("" + m_sCurrentItemPos, 100, 98);

	}

	/**
	 * Nimmt eine Nachricht entgegen, die anschliessend ausgewertet wird.
	 * @param oMessage die bergebene Nachricht
	 */
	public void getMessage( Message oMessage ) {

		// Nachricht holen und checken, ob Inhalt dabei
		Object oContent = oMessage.getContent();
		if (oContent == null) { return; }

		// wenn noch da (=Inhalt da!), dann nach Inhaltstyp dispatchen
		if (oContent instanceof InventoryUpdatedContent) {
			InventoryUpdatedContent oInventoryUpdatedContent = (InventoryUpdatedContent)oContent;

			/* Aktuell selektiertes Item aus Nachricht holen */
			m_itemCurrent = oInventoryUpdatedContent.getSelectedItem();
			if (m_itemCurrent != null) {
				String sTemp = m_itemCurrent.getClass().getName();
				int iDotPos = sTemp.lastIndexOf(".");
				if ((iDotPos > 0) && (iDotPos+1 < sTemp.length())) {
					sTemp = sTemp.substring(iDotPos+1);
				}
				int iPos = (sTemp.length() > 15) ? sTemp.length()-15 : 0;
				m_sCurrentItemTitle = sTemp.substring(iPos);

				// now get the item position
				m_sCurrentItemPos = "" + oInventoryUpdatedContent.getPosition();
				m_sCurrentItemPos += "/" + oInventoryUpdatedContent.getMaximum();

			} else {
				m_sCurrentItemTitle = "no item";
				m_sCurrentItemPos = "";
			}

			// lassen wir das Fenster neu zeichnen und den
			// Punktestand updaten
			this.repaint();
		}

	}

}