package pacman3d.util;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b><p>Ein eigene JFrame-Ableitung, in die die diversen
 * UI-Bestandteile des Spiels integriert werden.</p>
 * <b>Copyright:</b>Copyright (c) 2001<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version 2001-12-08<br/>
 */

public class GameFrame extends JFrame {

	/* das oberste Panel */
	public JPanel panelMain = null;

	/* das JPanel fr das 3d-Canvas-Objekt */
	public JPanel panelView3D = null;

	/* das JPanel fr die bersichtskarte */
	public JPanel panelOverview = null;

	/* das JPanel fr die Konsole */
	public JPanel panelConsole = null;

	/* das GameCockpitPanel fr die Scores */
	public GameCockpitPanel panelScore = null;

	/* das GameCockpitPanel fr die Scores */
	public GameCockpitPanel panelInventory = null;

	/* Flag, ob Multiplayermodus (true) oder Singleplayermodus (false) */
	private boolean m_bMultiplayerGame = false;

	/* Flag, ob wir Server sind oder nicht */
	private boolean m_bWeAreServer = false;



	/**
	 * erstellt ein neues Gamefenster mit einigen Vorgabewerten wir Gre,
	 * Fensterposition, Titel, etc.
	 */
	public GameFrame() {

		/* Gre, Position und Titel des Fensters setzen */
		this.setSize(800,600);
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		this.setLocation((d.width - this.getSize().width) / 2,
		  (d.height - this.getSize().height) / 2);
		this.setTitle("Pacman3D");

	}

	/**
	 * wird nach dem Initialisieren des Labyrinths aufgerufen und nimmt den Status
	 * Multiplayer/Singleplayer und die Anzahl der Spieler entgegen (soweit verfgbar!)
	 *
	 * @param bMultiplayerGame true, wenn Multiplayer-Spiel, false wenn Singleplayer
	 * @param bWeAreServer true, wenn diese Applikation der Server ist, false andernfalls
	 */
	public void setGameMode (boolean bMultiplayerGame, boolean bWeAreServer) {
		m_bMultiplayerGame = bMultiplayerGame;
		m_bWeAreServer = bWeAreServer;

		if (panelScore != null) { panelScore.setGameMode (bMultiplayerGame, bWeAreServer); }
		if (panelInventory != null) { panelInventory.setGameMode (bMultiplayerGame, bWeAreServer); }
	}

	/**
	 * erzeugt Panel-Elemente fr das Spiel und fgt diese in das GameFrame
	 * ein. Etwaige vorhandene Elemente werden entfernt.
	 */
	public void prepareGamePanels() {

		/* eine Panelstruktur aufbauen, in der die 3d-Ansicht, die Karte
		und weitere Elemente platziert werden knnen */
		panelMain = new JPanel(new BorderLayout());
		panelMain.setBackground(Color.black);
		JPanel panelUserArea = new JPanel(new BorderLayout());
		panelUserArea.setBackground(Color.black);
		panelView3D = new JPanel();
		panelView3D.setBackground(Color.black);
		panelView3D.setLayout(new BorderLayout());
		panelConsole = new JPanel();
		panelConsole.setBackground(Color.black);
		panelConsole.setLayout(new BorderLayout());
		GridLayout layoutCockpit = new GridLayout(3,1,0,0);
		JPanel panelCockpit = new JPanel(layoutCockpit);
		panelCockpit.setBackground(new Color(80,80,80));
		panelUserArea.add(panelView3D, BorderLayout.CENTER);
		// panelUserArea.add(panelConsole, BorderLayout.SOUTH);

		panelMain.add(panelUserArea, BorderLayout.CENTER);
		panelMain.add(panelCockpit, BorderLayout.EAST);

		panelOverview = new JPanel();
		panelOverview.setBackground(Color.black);
		panelOverview.setLayout(new BorderLayout());
		panelScore = new GamePanelScore(m_bMultiplayerGame, m_bWeAreServer);
		panelInventory = new GamePanelInventory(m_bMultiplayerGame, m_bWeAreServer);
		panelCockpit.add(panelScore);
		panelCockpit.add(panelInventory);
		panelCockpit.add(panelOverview);

		JLabel labelConsole = new JLabel("\nInfo/Debug/Chat\n");
		labelConsole.setHorizontalAlignment(JLabel.CENTER);
		labelConsole.setForeground(Color.blue);
		panelConsole.add(labelConsole);

		/* Hauptpanel in die Contentpane des Frames reinlegen und packen */
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(panelMain,BorderLayout.CENTER);
		this.pack();
		this.setSize(800,600);

	}

	/**
	 * rumt die Panel-Elemente, die fr das Spiel bentigt wurden ab und macht
	 * Platz fr das Intro
	 */
	public void cleanGamePanels() {

		// Nachrichtenverbindungen kappen (KeyListener + MessageListener)
		panelScore.cleanUp();
		panelInventory.cleanUp();

		// Komponenten entfernen (und hoffentlich vom GC killen lassen)
		remove(panelMain);
		panelMain = null;
		panelView3D = null;
		panelOverview = null;
		panelConsole = null;
		panelScore = null;
		panelInventory = null;

	}

	protected void processWindowEvent(WindowEvent e) {

		super.processWindowEvent(e);
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			System.exit(0);
		}

		if (e.getID() == WindowEvent.COMPONENT_RESIZED) {
			System.out.println (""+e.getSource());
		}

	}

	public synchronized void setTitle(String title) {

		super.setTitle(title);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);

	}

}