package pacman3d.util;

import java.awt.*;

import pacman3d.message.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b><p>Ein Panel, dass einen Rahmen fr die Info-Boxen
 * am rechten Rand des Spiels bereitstellt (fr Score, Inventory, ...)</p>
 * <b>Copyright:</b>Copyright (c) 2001-2002<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version $Date: 2002/02/25 11:52:07 $<br/>
 */


public class GameCockpitPanel extends Canvas implements MessageListener {

	// die id des Panel
	private ID m_idSelf = null;

	// einige Bilder
	protected Image imgBorderWithLogo = null;
	protected Image imgBorderBottom = null;
	protected Image imgBorderLeft = null;
	protected Image imgBorderRight = null;

	// Flag, ob die die Bilder geladen wurden (oder nicht)
	protected boolean bImagesLoaded = false;

	// eine Maloberflche und ein daran geheftetes Graphics-Objekt,
	// um Flackerei zu vermeiden (Doublebuffering!)
	private Image imgDrawSurface = null;
	private Graphics gDrawSurface = null;

	/* Flag, ob Multiplayermodus (true) oder Singleplayermodus (false) */
	protected boolean m_bMultiplayerGame = false;

	/* Flag, ob wir Server sind oder nicht */
	protected boolean m_bWeAreServer = false;



	/**
	 * konstruiert das Panel
	 *
	 * @param bMultiplayerGame true, wenn Multiplayer-Spiel, false wenn Singleplayer
	 * @param bWeAreServer true, wenn diese Applikation der Server ist, false andernfalls
	 */
	public GameCockpitPanel(boolean bMultiplayerGame, boolean bWeAreServer) {

		super();
		m_idSelf = new ID();
		MessageService.getInstance().addMessageListener (this);

		// einige Einstellungen schon mal setzen
		this.setBackground(new Color(85,128,0));

		// einladen von Bildern
		loadImages();

	}

	/**
	 * ldt die Bilder fr die Darstellung ein. Die Methode sollte von
	 * den Nachkommen der Klasse berschrieben werden, wenn sie ein
	 * eigenes Design wnschen.
	 */
	protected void loadImages () {

		// Einladen von Bildern. Knnte man das nicht auch ber den
		// Resourcenhandler abwickeln. Vielleicht so ein
		// Resourcenbeschreibungsfile (in xml), dass immer eingeladen
		// wird, da es fr GameFrame / AboutBox / Hilfe ntig ist.
		imgBorderWithLogo = getToolkit().createImage("media/gameframe/images/cockpit_logo_1.png");
		imgBorderBottom = getToolkit().createImage("media/gameframe/images/cockpit_border_bottom_1.png");
		imgBorderLeft = getToolkit().createImage("media/gameframe/images/cockpit_border_left_1.png");
		imgBorderRight = getToolkit().createImage("media/gameframe/images/cockpit_border_right_1.png");

		// setzen des Flags "bild geladen" (als Indikator in der Paint-Methode)
		bImagesLoaded = true;
	}

	/**
	 * wird nach dem Initialisieren des Labyrinths aufgerufen und nimmt den Status
	 * Multiplayer/Singleplayer und die Anzahl der Spieler entgegen (soweit verfgbar!)
	 *
	 * @param bMultiplayerGame true, wenn Multiplayer-Spiel, false wenn Singleplayer
	 * @param bWeAreServer true, wenn diese Applikation der Server ist, false andernfalls
	 */
	public void setGameMode (boolean bMultiplayerGame, boolean bWeAreServer) {
		m_bMultiplayerGame = bMultiplayerGame;
		m_bWeAreServer = bWeAreServer;
	}

	/**
	 * rumt das Panel auf und kappt Verbindungen, bevor es gekillt werden kann
	 */
	public void cleanUp () {

		// MessageService.getInstance().removeMessageListener (this);

	}

	/**
	 * die paint-Methode zum Malen des Canvas
	 * @param oGr das Graphics-Objekt zum Bemalen des Canvas
	 */
	public void paint(Graphics oGr) {

		// ein Java2D-Malobjekt holen und Hintergrundfarbe setzen
		Graphics2D g = (Graphics2D) oGr;
		g.setBackground(new Color(85,128,0));

		// Malen des skalierenden "Bilderrahmens" (falls die Bilder geladen wurden)
		if (bImagesLoaded) {
			int iHeight = this.getHeight();
			int iWidth = this.getWidth();
			g.drawImage (imgBorderWithLogo, 0, 0, this);
			g.drawImage (imgBorderBottom, 0, iHeight-imgBorderBottom.getHeight(this), this);
			if (iHeight > imgBorderWithLogo.getHeight(this) + imgBorderBottom.getHeight(this)) {
				int iNumberOfIterations = (iHeight - imgBorderWithLogo.getHeight(this)
				  -imgBorderBottom.getHeight(this))/ imgBorderLeft.getHeight(this);
				int iLastPixels = (iHeight - imgBorderWithLogo.getHeight(this)
				  -imgBorderBottom.getHeight(this)) % imgBorderLeft.getHeight(this);

				if (iNumberOfIterations > 0) {
					for (int i = 0; i < iNumberOfIterations; i++) {
						g.drawImage (imgBorderLeft, 0, imgBorderWithLogo.getHeight(this)
						  + i*imgBorderLeft.getHeight(this), this);
						g.drawImage (imgBorderRight, iWidth-imgBorderRight.getWidth(this),
						  imgBorderWithLogo.getHeight(this) + i*imgBorderLeft.getHeight(this), this);
					}
				}

				if (iLastPixels > 0) {
					g.drawImage (imgBorderLeft, 0, imgBorderWithLogo.getHeight(this)
					  + iNumberOfIterations*imgBorderLeft.getHeight(this),
					  imgBorderLeft.getWidth(this), iLastPixels, this);
					g.drawImage (imgBorderRight, iWidth-imgBorderRight.getWidth(this),
					  imgBorderWithLogo.getHeight(this) + iNumberOfIterations*imgBorderLeft.getHeight(this),
					  imgBorderRight.getWidth(this), iLastPixels, this);
				}
			}
		}
	}

	/**
	 * Die Update-Methode der Klasse (ruft paint auf...)
	 * @param Graphics Das Java-Grafik-Ausgabe-Objekt
	 */
	public void update (Graphics g) {

		// BufferImage anlegen, falls noch nicht vorhanden
		if (imgDrawSurface == null) {
			imgDrawSurface = createImage (this.getSize().width, this.getSize().height);
			gDrawSurface = imgDrawSurface.getGraphics();
		}

		// BufferImage resizen, wenn Frame geresizet wurde
		if ((imgDrawSurface.getWidth(this) != getSize().width) || (imgDrawSurface.getHeight(this) != getSize().height)) {
			imgDrawSurface = createImage (this.getSize().width, this.getSize().height);
			gDrawSurface = imgDrawSurface.getGraphics();
		}

		// Buffer subern und kopieren
		gDrawSurface.setColor (this.getBackground());
		gDrawSurface.fillRect (0, 0, this.getWidth(), this.getHeight());

		// Aufruf der eigentlichen Paint-Methode mit dem Hintergrundpuffer,
		// der anschlieend auf den Bildschirm kopiert wird.
		paint (gDrawSurface);
		g.drawImage (imgDrawSurface, 0, 0, this);
	}

	/**
	 * Nimmt eine Nachricht entgegen, die anschliessend ausgewertet wird.
	 * @param oMessage die bergebene Nachricht
	 */
	public void getMessage( Message oMessage ) {

		// this.repaint();

	}

	/**
	 * liefert die Nachrichten-ID des Panels zurck
	 * @return die ID des Panels
	 */
	public ID getID()
	{
		return m_idSelf;
	}


}