package pacman3d.util;

import java.io.File;
import org.w3c.dom.*;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pacman3d.util.*;

/**
 * <b>Title:</b>      	Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * Eine Testklasse fr die Klasse <code>pacman3d.util.CellHandler</code><br/>
 *
 * <b>Copyright:</b>	Copyright (c) 2001-2002<br>
 *
 * @author              Labyrinth-Gruppe<br/>
 * @version             07.01.2002<br/>
 * @see                 pacman3d.util.CellHandler<br/>
 */

public class CellHandlerTest {

        public CellHandlerTest() {

                /* get an instance of CellHandler */
                CellHandler oCellHandler = CellHandler.getInstance();

		/* first read in some xml data via DOM */
		Document doc = null;
                Element elDoc = null;
		try {
		        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();

			doc = docBuilder.parse( new File (
                                "C:\\Dokumente und Einstellungen\\wleklinski\\Eigene Dateien\\WS 2001 2002\\WS 2001 2002 Praktikum Computergrafik\\doc\\levelfiles\\levelexample1.xml"
                        ) );

		        // normalize text representation
		        doc.getDocumentElement().normalize();

			elDoc = doc.getDocumentElement();

		} catch (SAXParseException err) {
		        System.out.println ("** Parsing error"
		          + ", line " + err.getLineNumber ()
		          + ", uri " + err.getSystemId ());
		        System.out.println("   " + err.getMessage ());
		        // print stack trace as below

		} catch (SAXException e) {
		        Exception x = e.getException ();
		        ((x == null) ? e : x).printStackTrace ();

		} catch (Throwable t) {
		        t.printStackTrace ();
		}

                if (elDoc != null) {

                        /* get the CellHandler's DOM element */
                        NodeList oCellHandlerElements = elDoc.getElementsByTagName( "celltypes" );
                        Element oCellHandlerElement = null;
                        if (oCellHandlerElements.getLength() == 1) {
                                oCellHandlerElement = (Element) oCellHandlerElements.item( 0 );
                        }

                        /* let CellHandler read it's data from DOM */
                        if (oCellHandlerElement != null) {
                                try {
                                        oCellHandler.loadFromDOM( oCellHandlerElement );
                                } catch (Exception oException) {
                                        Debug.out( getClass().getName(),
                                                oException, Debug.LEVEL_CRITICAL );
                                        System.exit(-1);
                                }
                        }
                }

        }


        public static void main(String[] args) {
                CellHandlerTest oCellHandlerTest1 = new CellHandlerTest();
        }
}