package pacman3d.pacman.sound;

import java.net.*;
import java.util.*;

import javax.media.j3d.*;
import javax.vecmath.*;
/**
 * Title:        Praktikum Java3D und VRML
 * Description:  <p>this class creates sound</p>
 * Copyright:    Copyright (c) 2002<br>
 *
 * @author Xu Jihua
 * @version 1.0
 *
 */

public class PacmanSound extends TransformGroup{
	/** one BoundingSphere can be applied by sound */
	BoundingSphere soundbounds = new BoundingSphere(new Point3d(0.0, 0.0,0.0),4.0);
	
	/** sound is part of this TransformGroup, it will be added to scene graph */
	TransformGroup pacsoundTG;
	
	/** Vector to contain arbitrary many URL of sounds */
	private Vector m_oSoundURLS;
	
	/** Vector to contain arbitrary many sounds */
	private Vector m_oSounds;
	
	/** background sound for the whole game */
	private BackgroundSound m_oBgSound;


	/** Constructor, we can pass values to add sound resource to Vector by entering corresponding String, the background sound is not set
	 * @param sSoundURL String, that points connected resource
	 */
	public PacmanSound(String sSoundURL){
		Vector oTemp = new Vector();
		URL oTempURL;
		try {
			oTempURL=new URL(sSoundURL);
			oTemp.add(oTempURL);
		}
		catch (Exception ex) {
			System.out.println("Error creating Sound");
		}
		createSound(null,oTemp);
	}
	
	
	/** Constructor, we can pass values to add sound resource to Vector by entering corresponding url, the background sound is not set
	 * @param oSoundURL Url, that points connected resource
	 */
	public PacmanSound(URL oSoundURL){
		Vector oTemp = new Vector();
		oTemp.add(oSoundURL);
		createSound(null,oTemp);
	}
	
	/** Constructor, we get the wished resource by vector, the background sound is not set
	 * @ param oSoundURLs Vector, that saves sound resource
	 */
	public PacmanSound(Vector oSoundURLs){
		createSound(null,oSoundURLs);
	}
	
	/** Constructor, we get the wished resource by vector, the background sound comes from vector oBgSURL
	 * @ param oBgSURL url, that is connected to background sounds
	 * @ Vector oSoundURLs url, that saves pointsounds
	 */
	public PacmanSound(URL oBgSURL, Vector oSoundURLs){
		createSound(oBgSURL,oSoundURLs);
	}
	
	/** builds sound vector, with it sounds can be played 
	 * @ param oBgSURL url, that is connected to background sounds
	 * @ Vector oSoundURLs Vector, that saves pointsounds
	 */
	private void createSound(URL oBgSURL, Vector oSoundURLs){

		m_oSoundURLS=new Vector();
		m_oSounds = new Vector ();

		pacsoundTG =  Givingcapability();

		if (oBgSURL != null) {
			m_oBgSound = BgSoundMaker(oBgSURL);
			pacsoundTG.addChild(m_oBgSound);

		}

		m_oSoundURLS=oSoundURLs;
		for (int i = 0; i < m_oSoundURLS.size(); i++) {
			m_oSounds.add(PSoundMaker((URL)m_oSoundURLS.get(i)));
			pacsoundTG.addChild((PointSound)m_oSounds.get(i));
		}


		this.addChild(pacsoundTG);
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		this.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
	}

	
	/** This method gives the TG rights for reading, writting etc...)
	 *  @param no
	 *  @return one TransformGroup with three rights.
     	 */
	private TransformGroup Givingcapability() {
		TransformGroup temTG = new TransformGroup ();

		temTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		temTG.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		temTG.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

		return temTG;
	}

	/** This method give rights and equipment for playing pointsound
	 * @parm o_pURL url, that is connedted to pointsounds
	 */
	private PointSound PSoundMaker(URL o_pURL){
		MediaContainer o_PtemMC = new MediaContainer(o_pURL);
		o_PtemMC.setCapability(MediaContainer.ALLOW_URL_WRITE);
		o_PtemMC.setCapability(MediaContainer.ALLOW_URL_READ);
		PointSound o_Pointsound = new PointSound();

		o_Pointsound.setCapability(PointSound.ALLOW_ENABLE_WRITE);
		o_Pointsound.setCapability(PointSound.ALLOW_INITIAL_GAIN_WRITE);
		o_Pointsound.setCapability(PointSound.ALLOW_SOUND_DATA_WRITE);
		o_Pointsound.setCapability(PointSound.ALLOW_SCHEDULING_BOUNDS_WRITE);
		o_Pointsound.setCapability(PointSound.ALLOW_CONT_PLAY_WRITE);
		o_Pointsound.setCapability(PointSound.ALLOW_RELEASE_WRITE);
		o_Pointsound.setCapability(PointSound.ALLOW_DURATION_READ);
		o_Pointsound.setCapability(PointSound.ALLOW_IS_PLAYING_READ);
		o_Pointsound.setCapability(PointSound.ALLOW_POSITION_WRITE);
		o_Pointsound.setCapability(PointSound.ALLOW_LOOP_WRITE);

		o_Pointsound.setSoundData(o_PtemMC);
		o_Pointsound.setInitialGain(1.5f);
		o_Pointsound.setSchedulingBounds(soundbounds);
	 /*
	  * at the beginning the point sound isn't played
	  */
		o_Pointsound.setEnable(false);
	 /*
	  * even played, only one time, but als time elapsed, can be repeatedly played
	  */
		o_Pointsound.setLoop(1);

		return o_Pointsound;
	}

	/** This method give rights and equipment for playing pointsound
	 * @parm o_pURL url, that is connedted to backgroundsound
	 */
	private BackgroundSound BgSoundMaker(URL o_helpURL){
		MediaContainer temMC = new MediaContainer(o_helpURL);
		temMC.setCapability(MediaContainer.ALLOW_URL_WRITE);
		temMC.setCapability(MediaContainer.ALLOW_URL_READ);
		BackgroundSound o_temBgSound = new BackgroundSound(temMC, 1.0f);
		o_temBgSound.setSchedulingBounds(soundbounds);
	/*
	 * background sound is alway here
	 */
		o_temBgSound.setEnable(true);
	/*
	 * indefinitely played
	 */
		o_temBgSound.setLoop(BackgroundSound.INFINITE_LOOPS);
		return o_temBgSound;
	}

	/** This method returns the desired pointsound, whose location in Vecotor is nHelp
	 * @parm nHelp position of sound in Vector
	 * @return the desired pointsound
	 */
	public PointSound getSound(int nHelp){
		if (nHelp < m_oSounds.size()) {
			return (PointSound)m_oSounds.get(nHelp);
		}
		return null;

	}

	/** This method plays the desired pointsound
	 * @parm nPlay position of to be played sound in Vector
	 */
	public void playSound(int nPlay){
		PointSound oTemp =getSound(nPlay);
		if (oTemp != null) {
			oTemp.setEnable(true);
		}
	}
}