package pacman3d.pacman.maintenance;

/**
 * <p>Title: Praktikum Java3D und VRML</p>
 * <p>Description: Das Ziel dieses Projektes ist es, das Spiel PacMan in einer
 *                 3D Variante mittels Java3D umzusetzen. Dazu wird unsere
 *                 Gruppe den PacMan beisteuern.</p>
 *
 *
 * <h1> ItemValue </h1>
 * <p> this class allows the items to change parameters of the pacman. So it'll
 * be possible to add points, add lives, change game modes with this simple
 * class.</p>
 *
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: </p>
 * @author <a href="mailto:bergmann@cs.uni-frankfurt.de">Frank Bergmann </a>
 * @version 1.0
 */

public class ItemValue {

    /** the name, that indicates what is to be set. Possible values would be:
     *  <ul>
     *  <li><b>score</b> - to change the current score </li>
     *  <li><b>lives</b> - to add a number of lives </li>
     *  <li><b>invincible</b> - to enter invincibility / fight mode </li>
     *  </ul>
     *
     * other values are thinkable *smile smile*
     */
    private String m_sName;
    /**
     *  the value will be almost an integer ... indicating either number
     *  of points to add to score / lives ... ore number of seconds that
     *  invincibility will last
     */
    private Object m_oValue;

    /**
     * set name and value to this object
     *
     * @param sName name to be set
     * @param oValue value to be set
     */
    public ItemValue(String sName, Object oValue) {
        m_sName = sName;
        m_oValue=oValue;
    }
    /**
     * set name and value to this object
     *
     * @param sName name to be set
     * @param nValue value to be set
     */
    public ItemValue(String sName, int nValue) {
        m_sName = sName;
        m_oValue=new java.lang.Integer (nValue);
    }
    /**
     *
     * @return the name of the item
     */
    public String getName() {
        return m_sName;
    }
    /**
     *
     * @return the value of the item
     */
    public Object getValue() {
        return m_oValue;
    }

}