package pacman3d.pacman.maintenance;
import java.util.*;

import pacman3d.labyrinth.*;
import pacman3d.pacman.*;
import pacman3d.message.*;
import pacman3d.util.*;
import pacman3d.labyrinth.items.*;


/**
 * Title:        Praktikum Java3D und VRML
 * Description:  <p>maintenance of pacman</p>
 *               <p>you'll probably wonder why the major version was changed.
 *               Well up to now this class was doing virtually nothing. This
 *               has been changed with this version. Now this class holds some
 *               true power over the pacman - it can decide whether he is
 *               invincible or not. Furthermore Item handling does work ...
 *               which is great enough ... don't you think?</p>
 * Copyright:    Copyright (c) 2001<br>
 *
 * @author <a href="mailto:bergmann@cs.uni-frankfurt.de">Frank Bergmann </a>, Christoph Karwoth
 * @version 2.0
 *
 */

public class Admin{
    /** name of PacMan */
    private String m_sName;
    /** current score */
    private Integer m_nScore;
    /** vector containing all Items */
    private Vector m_oItems;
    /** current position in item list */
    private int m_nPosition;
    /** number of lives this pacman has left before he dies permanently */
    private Integer m_nNumberOfLives;

    /** the pacman this storage is for */
    private Pacman m_oPacman;

    /** if true this boolean will indicate that pacman is invincible. That means
     *  no other pacman nor another monster can do any harm to pacman. Even
     *  worse if this pacman catches a monster it will utterly destroy that
     *  fellow so ... don't cross pacman once this is true
     */
    private boolean m_bIsInvincible = false;
    /** well i was kinda at a loss here. I thought i would be little fun always
     *  running invincible through the labyrinth. On the other side, who would
     *  turn off invincibility, if he wasn't forced too? So I came up with this
     *  one: when invincibility is set, also a number of seconds is given, how
     *  long it'll last. This variable now holds the time, when the
     *  invincibility will wear off.
     *
     */
    private long m_nTimeInvincibleWearsOff;
    /** this variable indictes, whether or not pacman plays friendly or not.
     *  if he is not friendly he will kill pacmans while being invincible ...
     */
    private boolean m_bIsFriendly = true;

	/**
	 * this variable holds the number of times the pacman was killed. This is
	 * needed for multiplayer games there it ain't necessary to restrain
	 * pacman with a limited number of lives.
	 */
	private int m_nTimesKilled = 0;


    /** constructor initializing all parameters
     *
     * @param oPacman the pacman, that this class will hold values for
     */
    public Admin(Pacman oPacman){
        m_oItems = new Vector();
        m_nPosition=0;
        m_nNumberOfLives=new Integer(5);
        m_sName=new String("noname");
        m_nScore= new Integer(0);
        m_oPacman = oPacman;
    }

    /**
     *  this function will check whether
     */
    public void checkModes() {
        if (m_bIsInvincible) {
            long nTemp = System.currentTimeMillis();
            if (nTemp >= m_nTimeInvincibleWearsOff) {
                m_bIsInvincible = false;

				m_oPacman.enableFightAnimation(false);

            }
        }
    }
    /**
     * get the Status, whether pacman is a threat to you or not
     * @return true when invincible, false otherwise
     */
    public boolean isInvincible () {
		//Debug.out(this.getClass().getName(),"invincible: " + m_bIsInvincible);
        return m_bIsInvincible;
    }
    /**
     *  sets pacman invincible ... so beeehold *smile*
     *
     * @param nTime time invincibility will last
     */
    public void setInvincible (int nTime) {
        m_bIsInvincible=true;
		if (nTime < 100) nTime*=1000;  // convert to seconds
        m_nTimeInvincibleWearsOff = System.currentTimeMillis() + nTime;
		m_oPacman.enableFightAnimation(true);
    }
    /**
     * get the friendly status ...
     * @return true when friendly, false otherwise
     */
    public boolean isFriendly() {
        return m_bIsFriendly;
    }

    /**
     * sets the friendly status
     * @param bIsFriendly status to be set
     */
    public void setFriendly (boolean bIsFriendly) {
        m_bIsFriendly=bIsFriendly;
    }
    /** adds Points to the current score
     *
     * @param nPoints the number of points to add
     */
    public void setPoints(Integer nPoints){
        m_nScore = new Integer (m_nScore.intValue() + nPoints.intValue());
    }
    /** returns current score
     *
     * @return the score achieved by pacman
     */
    public Integer getPoints () {
        return m_nScore;
    }

    /** return number of lives left
     *
     * @return the number of lives this pacman has left
     */
    public Integer getLives () {
        return m_nNumberOfLives;
    }

    /** set NumberOfLives
     *
     * @param nLives initial number of lives vor a pacman
     */
    public void  setLives (Integer nLives) {
        m_nNumberOfLives=nLives;
    }

    /** set NumberOfLives
     *
     * @param nLives number of lives to add to current pacman
     */
    public void  addLives (Integer nLives) {
        m_nNumberOfLives=new Integer (m_nNumberOfLives.intValue() + nLives.intValue());
    }
    /** remove a live
     */
    public void  removeLive () {
        m_nNumberOfLives=new Integer (m_nNumberOfLives.intValue() -1);
    }
    /** returns name of pacman
     *
     * @return the name
     */
    public String getName() {
        return m_sName;
    }
    /** sets name of pacman
     *
     * @param sName the new name
     */
    public void setName (String sName) {
        m_sName=sName;
    }

    /** adds an Item to the storage
     *
     * @param oItem the Item to add
     */
    public void addItem(Item oItem){
        m_oItems.add(oItem);
    }

    /** use selected Item ...*/
    public void ItemUse(){
        try {
            if (!m_oItems.isEmpty() && (m_nPosition < m_oItems.size())){
                ((Item)m_oItems.get(m_nPosition)).execute(m_oPacman);
                m_oItems.remove(m_nPosition);
                InventoryLast();
                m_oPacman.sendScoreMessage();
            }

        }
        catch (Exception ex) {
              Debug.out(this.getClass().getName(),
				".ItemUse: error ... size "
				+ m_oItems.size() + " pos: " + m_nPosition );
        }

    }

    /**
     * return the selected item ...
     * @return the currently selected item or <b>null</b> if none is selected
     */
    public Item getSelectedItem () {
        try {
            return (Item)m_oItems.get(m_nPosition);
        }
        catch (Exception ex) {
            return null;
        }

    }
    /** select next item*/
    public void InventoryNext(){
        if (!m_oItems.isEmpty()){
            m_nPosition++;
            if (m_nPosition > m_oItems.size()-1 ) m_nPosition=0;
        }
    }

    /** select previous item*/
    public void InventoryLast(){
        if (!m_oItems.isEmpty()){
            m_nPosition--;
            if (m_nPosition < 0 ) m_nPosition=m_oItems.size()-1;
            if (m_nPosition < 0 ) m_nPosition=0;
        }
    }

    /** dump all values
     *
     * @return string containing all current attributes
     */
    public String toString(){
        return "name: " + m_sName + " score: " + m_nScore.intValue() +
            " NumberOfLives: " + m_nNumberOfLives +
            " Items: " + m_oItems +
            " NumberOfItems: " + m_oItems.size() +
            " selected: " + m_nPosition +
            " selectedItem: " + getSelectedItem();
    }
    /**
     * thios method will create a message containing inventory information
     * @return inventory message
     */
    public InventoryUpdatedContent getMessage() {
        return new InventoryUpdatedContent(this.getSelectedItem(),
            m_nPosition+1,m_oItems.size());
    }

	/**
	 * this function updates the status of the pacman and so is able to decide,
	 * whether or not the game can continue for this pacman, or not.
	 *
	 */
    public void die() {
		removeLive();
		m_nTimesKilled++;
    }

	/** this function returns, wether or not the pacman has another life left
	 *
	 * @return <b>true</b> got another life left, <b>false</b> otherwise
	 */
	public boolean gotAnotherLife() {
		if (m_nNumberOfLives.intValue()<=1) {
			//Debug.out(this.getClass().getName(),"game over");
			return false;
		} else {
			//Debug.out(this.getClass().getName(),"respawn");
			return true;
		}
	}
	/**
	 * return the number of times this pacman was killed
	 * @return number of times this pacman was killed
	 */
	public int getKillCount() {
		return m_nTimesKilled;
	}


}