package pacman3d.pacman.animation;
import javax.media.j3d.*;
import javax.vecmath.*;

import com.sun.j3d.utils.geometry.*;
/**
 * Title:        Praktikum Java3D und VRML
 * Description:  <p>this class creates a pacman model and you change its color</p>
 * Copyright:    Copyright (c) 2002<br>
 *
 * @author Xu Jihua
 * @version 1.0
 *
 */
public class pacimage2version extends TransformGroup{
	/** one BoundingSphere can be applied by Interpolator and Morphing */
	BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0,0.0),100.0);

	/** the radius of Pacman's face */
	float n_r1 = 0.35f;

	/** the radius of Pacman's eye */
	float n_r2 = 0.053f;

	/** face is made of 26 Triangles */
	int n_KONSTANT = 26;

	/** serve as symbol for the death trigger */
	boolean o_showdeath = false;

	/** defines the color of eyes */
	Color3f black = new Color3f(0.0f, 0.0f, 0.0f);

	/** three array for outside of left face, with it to make morphing animation */
	TriangleFanArray ao_Pacgeometryleft[] = new TriangleFanArray[3];

	/** three array for inner side of left face, with it to make morphing animation */
	TriangleFanArray ao_Pacgeometryleftback[] = new TriangleFanArray[3];

	/** three array for outside of right face, with it to make morphing animation */
	TriangleFanArray ao_Pacgeometryright[] = new TriangleFanArray[3];

	/** three array for inner side of right face, with it to make morphing animation */
	TriangleFanArray ao_Pacgeometryrightback[] = new TriangleFanArray[3];

	/** 32 Triangle build eye circle  */
	int n_anglecount2 = 32;

	/** Interpolator for Pacman's model */
	private RotPosScalePathInterpolator o_RPSInterpolator;

	/** Interpolator for spiritbottle */
	private RotPosScalePathInterpolator o_deathInterpolator;

	/** the corresponding alpha for Pacman's model, executed only one time within 12 seconds */
	private Alpha RPSAlpha = new Alpha(1, Alpha.INCREASING_ENABLE, 0, 0, 12000, 0, 0, 0, 0, 0);

	/** the corresponding alpha for spiritbottle, executed only one time within 6 seconds */
	private Alpha o_deathAlpha = new Alpha(1, Alpha.INCREASING_ENABLE, 0, 0000, 6000, 0, 0, 0, 0, 0);

	/** TG for containing Pacman's model */
	TransformGroup pacmanTG;

	/** to specify mouth's size of Pacman's model by angle defining */
	double n_anglecount1[] = {Math.PI/4.0, Math.PI/8.0, Math.PI/16.0};

	/** constant ist used for computation of black marker's four points*/
        float n_a = (float) (Math.cos(Math.PI/8.0 + 9*(2*Math.PI-Math.PI/4.0)/24.0));

        /** constant ist used for computation of black marker's four points*/
        float n_b = (float) (Math.sin(Math.PI/8.0 + 9*(2*Math.PI-Math.PI/4.0)/24.0));

        /** constant ist used for computation of black marker's four points*/
        float n_c = (float) (Math.cos(Math.PI/8.0 + 10*(2*Math.PI-Math.PI/4.0)/24.0));

        /** constant ist used for computation of black marker's four points*/
        float n_d = (float) (Math.sin(Math.PI/8.0 + 10*(2*Math.PI-Math.PI/4.0)/24.0));

        /** array containing four points of black marker*/
        Point3f[] a_haar = new Point3f[4];


	/** this method is responsible for creating face and eyes.
	 *  @param n_angle the angle, that defines size of mouth
	 *  @param n_radius the radius, that initials radius of mouth and eye
	 *  @param o_color the color, that are joined with mouth or eye
	 *  @param back the flag, be used for inner side or outside rendering
	 *  @return TriangleFanArray
     	*/
	private TriangleFanArray pacmaker(double n_angle, float n_radius, Color3f o_color, boolean back)
	{
		TriangleFanArray ao_pactfa;
		double n_degree = n_angle/2.0;
		Point3f coords[] = new Point3f[26];
		int stripCounts[] ={26};
		float n_x, n_y;
		Color3f colors[] = new Color3f[26];
		coords[0] = new Point3f(0.0f, 0.0f, 0.0f);
		colors[0] = o_color;

		/*
		 * if back is true, to calculate the coordinates of the face or eyeat the left side
		 */

		if (back){
			for (int n_loop = 1; n_loop < coords.length; n_loop++){
				n_x = (float) (n_radius*Math.cos(-n_degree - (n_loop-1)*(2*Math.PI-n_angle)/24.0));
				n_y = (float) (n_radius*Math.sin(-n_degree - (n_loop-1)*(2*Math.PI-n_angle)/24.0));
				colors[n_loop] = o_color;
				coords[n_loop] = new Point3f(n_x, n_y, 0.0f);
			}
		/*
		 * otherwise the face or the eye at the right side
		 */

		}else{
			for (int n_loop = 1; n_loop < coords.length; n_loop++){
				n_x = (float) (n_radius*Math.cos(n_degree + (n_loop-1)*(2*Math.PI-n_angle)/24.0));
				n_y = (float) (n_radius*Math.sin(n_degree + (n_loop-1)*(2*Math.PI-n_angle)/24.0));
				colors[n_loop] = o_color;
				coords[n_loop] = new Point3f(n_x, n_y, 0.0f);
			}
		}
		ao_pactfa = new TriangleFanArray(26, TriangleFanArray.COORDINATES | TriangleFanArray.COLOR_3, stripCounts);
		ao_pactfa.setCoordinates(0, coords);
		ao_pactfa.setColors(0, colors);

		return ao_pactfa;
	}


	/** the body of pacman is created by using 26 quadrats
	 *  @param o_Farbe the Color, that gives the Pacman's body color.
	 +  @return body of one unclosed cylinder
     */
	private Node edgemake(Color3f o_Farbe){
		IndexedQuadArray oa_paciqa = new IndexedQuadArray(52, IndexedQuadArray.COORDINATES | IndexedQuadArray.NORMALS,104);
		float n_ex, n_ey;
		Point3f[] edgeCoordinates = new Point3f[52];
		edgeCoordinates[0] = new Point3f(0.0f, 0.0f, -0.3f);
		edgeCoordinates[n_KONSTANT] = new Point3f(0.0f, 0.0f, 0.3f);

		/*
		 * computation of the quadrat's coordinates
		 */
		for (int m = 1; m < n_KONSTANT; m++){
			n_ex = (float) (Math.cos(Math.PI/8.0 + (m-1)*(2*Math.PI-Math.PI/4.0)/24.0));
			n_ey = (float) (Math.sin(Math.PI/8.0 + (m-1)*(2*Math.PI-Math.PI/4.0)/24.0));
			edgeCoordinates[m] = new Point3f(n_r1*n_ex, n_r1*n_ey, -0.3f);
			edgeCoordinates[m + n_KONSTANT] = new Point3f(n_r1*n_ex, n_r1*n_ey, 0.3f);
		}
		int coordindices[] = {	0,1,27,26, 	1,2,28,27, 	2,3,29,28,	3,4,30,29,
								4,5,31,30,	5,6,32,31,	6,7,33,32,	7,8,34,33,
								8,9,35,34,	9,10,36,35,	10,11,37,36,	11,12,38,37,
								12,13,39,38,	13,14,40,39,	14,15,41,40,	15,16,42,41,
								16,17,43,42,	17,18,44,43,	18,19,45,44,	19,20,46,45,
								20,21,47,46,	21,22,48,47,	22,23,49,48,	23,24,50,49,
								24,25,51,50,	25,0,26,51};

		oa_paciqa.setCoordinates(0,edgeCoordinates);
		oa_paciqa.setCoordinateIndices(0, coordindices);
		Appearance edgeAppearance = new Appearance();
		Material edgeMaterial = new Material(o_Farbe,new Color3f(0.1f, 0.1f,0.1f),o_Farbe,o_Farbe,100f);
		edgeAppearance.setMaterial(edgeMaterial);
		Shape3D edge = new Shape3D(oa_paciqa,edgeAppearance);
		return edge;
	}

	/** This methode gives the TG rights for reading, writting etc...)
	 *  @param no
	 *  @return one TransformGroup with three rights.
     */
    private TransformGroup Givingcapability() {
		TransformGroup temTG = new TransformGroup ();

		temTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		temTG.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		temTG.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

		return temTG;
	}

	/** simplify works for skateboard with 4 rolling reels
	 *  @param o_helpT3D the value of Transform, that locates the position for reels
	 *  @param o_reelcolor the color, which reels have.
	 *  @return one TransformGroup with cylinder and one rotation interpolator, it operates on cylinder
     */
	private TransformGroup getReel(Transform3D o_helpT3D, Color3f o_reelcolor){
		TransformGroup o_ReelcreatTG = Givingcapability();
		o_ReelcreatTG.setTransform(o_helpT3D);

		/*
		 * this is our rolling reels, but first wir must rotate it
		 */
		TransformGroup o_ReelBigTG =  Givingcapability();
		Transform3D o_ReelBigtrans = new Transform3D();
		o_ReelBigtrans.rotX(Math.PI/2.0d);
		o_ReelBigTG.setTransform(o_ReelBigtrans);
		TransformGroup o_rotationTG = Givingcapability();
		Appearance o_o_reelBigAppearance = new Appearance();
		Material o_o_reelBigMaterial = new Material(o_reelcolor,black,o_reelcolor,o_reelcolor,100f);
		o_o_reelBigAppearance.setMaterial(o_o_reelBigMaterial);
		Cylinder o_reelBig = new Cylinder(0.11f, 0.2f, o_o_reelBigAppearance);

		Alpha o_rotationAlpha = new Alpha(-1, 4000);
		Transform3D axis = new Transform3D();
		RotationInterpolator o_rotator = new RotationInterpolator(o_rotationAlpha, o_rotationTG, axis,0.0f,(float)Math.PI*2.0f);
		o_rotator.setSchedulingBounds(bounds);
		o_rotationTG.addChild(o_rotator);
		o_rotationTG.addChild(o_reelBig);

		o_ReelBigTG.addChild(o_rotationTG);
		o_ReelcreatTG.addChild(o_ReelBigTG);

		/*
		 * this is aixses of four reels
		 */
		TransformGroup o_reelSmallTG =  Givingcapability();
		Transform3D o_reelSmalltrans = new Transform3D();
		o_reelSmalltrans.rotX(Math.PI/2.0d);
		o_reelSmallTG.setTransform(o_reelSmalltrans);
		Appearance o_reelSmallApp = new Appearance();
		Material o_reelSmallMat = new Material(black,black,black,black,100f);
		o_reelSmallApp.setMaterial(o_reelSmallMat);
		Cylinder reelSmall = new Cylinder(0.03f, 0.23f, o_reelSmallApp);
		o_reelSmallTG.addChild(reelSmall);
		o_ReelcreatTG.addChild(o_reelSmallTG);

		return o_ReelcreatTG;
	}

	/** constructor, that initials everything of Pacman, such as eye, body,...
	 *  @param o_Paccolor the color that is painted on faces and body of Pacman
     */

	public pacimage2version(Color3f o_Paccolor){

	   /*
	   	* one array with 3 face, therewith we can make animation by using morphing
	   	*/
	   for (int m = 0; m<3; m++){
				ao_Pacgeometryleft[m] = pacmaker(n_anglecount1[m], n_r1, o_Paccolor, true);
				ao_Pacgeometryleftback[m] = pacmaker(n_anglecount1[m], n_r1, o_Paccolor, false);
				ao_Pacgeometryright[m] = pacmaker(n_anglecount1[m], n_r1, o_Paccolor, false);
				ao_Pacgeometryrightback[m] = pacmaker(n_anglecount1[m], n_r1, o_Paccolor, true);
		}
		Morph morphleft = new Morph(ao_Pacgeometryleft);
		morphleft.setCapability(Morph.ALLOW_WEIGHTS_READ);
		morphleft.setCapability(Morph.ALLOW_WEIGHTS_WRITE);

		Morph morphleftback = new Morph(ao_Pacgeometryleftback);
		morphleftback.setCapability(Morph.ALLOW_WEIGHTS_READ);
		morphleftback.setCapability(Morph.ALLOW_WEIGHTS_WRITE);

		Morph morphright = new Morph(ao_Pacgeometryright);
		morphright.setCapability(Morph.ALLOW_WEIGHTS_READ);
		morphright.setCapability(Morph.ALLOW_WEIGHTS_WRITE);

		Morph morphrightback = new Morph(ao_Pacgeometryrightback);
		morphrightback.setCapability(Morph.ALLOW_WEIGHTS_READ);
		morphrightback.setCapability(Morph.ALLOW_WEIGHTS_WRITE);

		/*
		 * two eyes of pacman
		 */
		Node lefteye = new Shape3D(pacmaker(0.0d, n_r2, black,true));
		Node righteye = new Shape3D(pacmaker(0.0d, n_r2, black,false));

		TransformGroup pacTG = Givingcapability();

		pacmanTG =  Givingcapability();
		Transform3D pacT3D = new Transform3D();
		pacT3D.rotY(Math.PI/2.0d);
		pacmanTG.setTransform(pacT3D);

		/*
		 * the required informations for interpolator, which is used for death animation.
		 */
		float[] o_knots = {0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f};
		float[] o_scales = {1.0f, 0.15f, 0.15f, 0.15f, 0.15f, 0.15f};
		Quat4f[] o_rotations ={
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f),
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f),
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f),
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f),
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f),
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f)
		};
		Point3f[] o_positions = {
			new Point3f(0.0f, 0.f, 0.0f),
			new Point3f(0.0f, -0.55f, 0.0f),
			new Point3f(0.44f, -0.55f, 0.0f),
			new Point3f(0.44f, 0.29f, 0.0f),
			new Point3f(0.0f, 0.29f, 0.0f),
			new Point3f(0.0f, -0.2f, 0.0f)

		};
		Transform3D o_yAxis = new Transform3D();
		o_RPSInterpolator = new RotPosScalePathInterpolator(
			RPSAlpha, pacTG, o_yAxis, o_knots, o_rotations, o_positions, o_scales);
		o_RPSInterpolator.setSchedulingBounds(bounds);

		o_RPSInterpolator.setEnable(false);
		RPSAlpha.setStartTime(0);
		pacTG.addChild(o_RPSInterpolator);

		/*
		 * position of left face
		 */
		TransformGroup leftheadTG = Givingcapability();
		Transform3D leftheadtranslate = new Transform3D();
		leftheadtranslate.setTranslation(new Vector3f(0.0f, 0.0f, -0.3002f));
		leftheadTG.setTransform(leftheadtranslate);
		leftheadTG.addChild(morphleft);

		TransformGroup leftheadbackTG = Givingcapability();
		Transform3D leftheadbacktranslate = new Transform3D();
		leftheadbacktranslate.setTranslation(new Vector3f(0.0f, 0.0f, -0.3001f));
		leftheadbackTG.setTransform(leftheadbacktranslate);
		leftheadbackTG.addChild(morphleftback);

		/*
		 * position of right face
		 */
		TransformGroup rightheadTG = Givingcapability();
		Transform3D rightheadtranslate = new Transform3D();
		rightheadtranslate.setTranslation(new Vector3f(0.0f, 0.0f, 0.3002f));
		rightheadTG.setTransform(rightheadtranslate);
		rightheadTG.addChild(morphright);

		TransformGroup rightheadbackTG = Givingcapability();
		Transform3D rightheadbacktranslate = new Transform3D();
		rightheadbacktranslate.setTranslation(new Vector3f(0.0f, 0.0f, 0.3001f));
		rightheadbackTG.setTransform(rightheadbacktranslate);
		rightheadbackTG.addChild(morphrightback);

		/*
		 * corresponding settings for face's animation
		 */
		Alpha morphAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE |
									 Alpha.DECREASING_ENABLE,
									 0, 0,
									 500, 0, 0,
									 500, 0, 0);

		MorphingBehavior mleftBeh = new MorphingBehavior(morphAlpha, morphleft);
		mleftBeh.setSchedulingBounds(bounds);
		leftheadTG.addChild(mleftBeh);

		MorphingBehavior mleftBehback = new MorphingBehavior(morphAlpha, morphleftback);
		mleftBehback.setSchedulingBounds(bounds);
		leftheadbackTG.addChild(mleftBehback);

		MorphingBehavior mrightBeh = new MorphingBehavior(morphAlpha, morphright);
		mrightBeh.setSchedulingBounds(bounds);
		rightheadTG.addChild(mrightBeh);

		MorphingBehavior mrightBehback = new MorphingBehavior(morphAlpha, morphrightback);
		mrightBehback.setSchedulingBounds(bounds);
		rightheadbackTG.addChild(mrightBehback);

		pacmanTG.addChild(leftheadTG);
		pacmanTG.addChild(leftheadbackTG);
		pacmanTG.addChild(rightheadTG);
		pacmanTG.addChild(rightheadbackTG);

		/*
		 * position of left eye
		 */
		TransformGroup lefteyeTG = Givingcapability();
		Transform3D lefteyetranslate = new Transform3D();
		lefteyetranslate.setTranslation(new Vector3f(0.105f, 0.193f, -0.31f));
		lefteyeTG.setTransform(lefteyetranslate);
		lefteyeTG.addChild(lefteye);
		pacmanTG.addChild(lefteyeTG);

		/*
		 * position of right eye
		 */
		TransformGroup righteyeTG = Givingcapability();
		Transform3D righteyetranslate = new Transform3D();
		righteyetranslate.setTranslation(new Vector3f(0.105f, 0.193f, 0.31f));
		righteyeTG.setTransform(righteyetranslate);
		righteyeTG.addChild(righteye);
		pacmanTG.addChild(righteyeTG);

		/*
		 * position of body
		 */
		Node body = edgemake(o_Paccolor);
		TransformGroup edgeTG = Givingcapability();
		Transform3D edgetranslate = new Transform3D();
		edgetranslate.setTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
		edgeTG.setTransform(edgetranslate);
		edgeTG.addChild(body);
		pacmanTG.addChild(edgeTG);

                /*
                 * defines the location of four points of marker
                 */
                IndexedQuadArray oa_haarIQA = new IndexedQuadArray(4, IndexedQuadArray.COORDINATES | IndexedQuadArray.NORMALS,4);
                int haarindices[] = {0, 3, 2, 1};
                a_haar[0] =  new Point3f(-0.30f, -0.34f,0.3f);
                a_haar[1] =  new Point3f(-0.45f, -0.34f,0.3f);
                a_haar[2] =  new Point3f(-0.45f, -0.34f,-0.3f);
                a_haar[3] =  new Point3f(-0.30f, -0.34f,-0.3f);
                //a_haar[0] =  new Point3f(0.36f*n_a, 0.36f*n_b,0.3f);
                //a_haar[1] =  new Point3f(0.36f*n_c, 0.36f*n_d,0.3f);
                //a_haar[2] =  new Point3f(0.36f*n_c, 0.36f*n_d,-0.3f);
                //a_haar[3] =  new Point3f(0.36f*n_a, 0.36f*n_b,-0.3f);
                oa_haarIQA.setCoordinates(0,a_haar);
		oa_haarIQA.setCoordinateIndices(0, haarindices);
                Appearance haarAppearance = new Appearance();
		Material haarMaterial = new Material(black,new Color3f(0.1f, 0.1f,0.1f),black,black,100f);
		haarAppearance.setMaterial(haarMaterial);
		Shape3D haar = new Shape3D(oa_haarIQA,haarAppearance);
                pacmanTG.addChild(haar.cloneNode(true));
		/*
		 * tongue as parting line defined by cylinder
		 */
		TransformGroup o_tongueTG =  Givingcapability();
		Transform3D o_tonguetransform = new Transform3D();
		o_tonguetransform.rotX(Math.PI/2.0d);
		Transform3D tTF = new Transform3D();
		tTF.setTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
		tTF.mul(o_tonguetransform);
		o_tongueTG.setTransform(tTF);
		Appearance o_tongueAppearance = new Appearance();
		Material o_tongueMaterial = new Material(black,black,black,black,100f);
		o_tongueAppearance.setMaterial(o_tongueMaterial);
		Cylinder o_tongue = new Cylinder(0.02f, 0.58f, o_tongueAppearance);
		o_tongueTG.addChild(o_tongue);
		pacmanTG.addChild(o_tongueTG);

		/*
		 * board of skateboard
		 */
		TransformGroup o_skateboardTG =  Givingcapability();
		Transform3D o_sbtranslate = new Transform3D();
		o_sbtranslate.setTranslation(new Vector3f(0.0f, -0.39f, 0.0f));
		o_skateboardTG.setTransform(o_sbtranslate);
		Appearance o_skateboardAppearance = new Appearance();
		Material o_skateboardMaterial = new Material(new Color3f(1.0f, 0.0f, 0.0f),
											new Color3f(0.0f, 0.0f, 0.0f),
											new Color3f(1.0f, 0.0f, 0.0f),
											new Color3f(1.0f, 0.0f, 0.0f),
															100f);
		o_skateboardAppearance.setMaterial(o_skateboardMaterial);
		Box o_skateboard = new Box(0.45f, 0.04f, 0.3f, o_skateboardAppearance);
		o_skateboardTG.addChild(o_skateboard);
		pacmanTG.addChild(o_skateboardTG);

		/*
		 * calling the method getReel to create four reels
		 */
		Transform3D o_reelA = new Transform3D();
		o_reelA.setTranslation(new Vector3f(0.28f, -0.54f, -0.2f));
		TransformGroup o_reelATG =  getReel(o_reelA, o_Paccolor);
		pacmanTG.addChild(o_reelATG);

		Transform3D o_reelB = new Transform3D();
		o_reelB.setTranslation(new Vector3f(0.28f, -0.54f, 0.2f));
		TransformGroup o_reelBTG =  getReel(o_reelB, o_Paccolor);
		pacmanTG.addChild(o_reelBTG);

		Transform3D o_reelC = new Transform3D();
		o_reelC.setTranslation(new Vector3f(-0.28f, -0.54f, -0.2f));
		TransformGroup o_reelCTG =  getReel(o_reelC, o_Paccolor);
		pacmanTG.addChild(o_reelCTG);

		Transform3D o_reelD = new Transform3D();
		o_reelD.setTranslation(new Vector3f(-0.28f, -0.54f, 0.2f));
		TransformGroup o_reelDTG =  getReel(o_reelD,o_Paccolor);
		pacmanTG.addChild(o_reelDTG);

		pacTG.addChild(pacmanTG);

		/*
		 * calling one instance of class spiritbottel, with it animation can be performed
		 */
		TransformGroup sbTG = Givingcapability();
		Transform3D o_sbT3D = new Transform3D();
		o_sbT3D.setTranslation(new Vector3f(-0.44f, 0.20f, 0.0f));
		sbTG.setTransform(o_sbT3D);
		spiritbottle sb = new spiritbottle();
		sbTG.addChild(sb);

		/*
		 * the required informations for spiritbottel's interpolator
		 */
		float[] knots = {0.0f, 0.33f, 0.66f, 1.0f};
		float[] scales = {1.0f, 1.0f, 1.0f, 10.0f};
		Quat4f[] rotations ={
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f),
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f),
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f),
			new Quat4f(0.0f, 0.0f, 0.0f, 0.0f)
		};
		Point3f[] positions = {
			new Point3f(0.0f, 0.0f, 0.0f),
			new Point3f(0.0f, -0.82f, 0.0f),
			new Point3f(0.44f, -0.82f, 0.0f),
			new Point3f(0.44f, -0.60f, 0.0f)
		};
		Transform3D yAxis = new Transform3D();
		o_deathInterpolator = new RotPosScalePathInterpolator(
			o_deathAlpha, sb, yAxis, knots, rotations, positions, scales);
		o_deathInterpolator.setSchedulingBounds(bounds);
		o_deathInterpolator.setEnable(false);
		o_deathAlpha.setStartTime(0);
		sb.addChild(o_deathInterpolator);

		Transform3D o_thisT3D = new Transform3D();
		//o_thisT3D.setTranslation(new Vector3f(0.0f, 0.12f, 0.0f));
                o_thisT3D.setScale(0.75d);
		this.setTransform(o_thisT3D);
		this.addChild(sbTG);
		this.addChild(pacTG);
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		this.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
	  }

	  /** this method implements death information, on new calling resetting occurs.
	   *  @param (idea from chris)
       */
	  public void showDeathAnimation() {
			if (o_showdeath==true) {
				o_showdeath=false;
			    }
			else {
			    o_showdeath=true;
            }
            if (o_showdeath==true) {

                            RPSAlpha.setMode(Alpha.INCREASING_ENABLE);
                            o_deathAlpha.setMode(Alpha.INCREASING_ENABLE);
			    RPSAlpha.setIncreasingAlphaDuration(12000);
			    o_deathAlpha.setIncreasingAlphaDuration(1500);
			    RPSAlpha.setStartTime(System.currentTimeMillis()+5);
			    o_deathAlpha.setStartTime(System.currentTimeMillis()+5);
			    o_RPSInterpolator.setEnable(true);
			    o_deathInterpolator.setEnable(true);
			}else {

                            RPSAlpha.setMode(Alpha.DECREASING_ENABLE);
                            o_deathAlpha.setMode(Alpha.DECREASING_ENABLE);
			    RPSAlpha.setIncreasingAlphaDuration(10);
			    o_deathAlpha.setIncreasingAlphaDuration(10);
			    RPSAlpha.setStartTime(System.currentTimeMillis());
			    o_deathAlpha.setStartTime(System.currentTimeMillis());
			    o_RPSInterpolator.setEnable(true);
			    o_deathInterpolator.setEnable(true);
			}

	  }

}