package pacman3d.pacman.animation;

import java.awt.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.image.*;



/**
 * Beschreibung class <code>PacmanObjTrans</code>.
 * Diese Klasse ist eine TransformGroup die den Packman beinhaltet. Je nach bedarf kann man den Packman auch
 * durch eingabe der URL oder des Path als String laden. Es koennen 3DS files wie auch WRL files geladen werden.
 * Hier werden die einzelnen Komponenten vom Packman zusammen gestellt und animiert. Auch seinen Beleuchtung
 * wird hier eingefuegt. Kann je nach bedarf ein bzw. ausgeschaltet werden. Genauso wie alle Animationen
 * angehalten werden. Hier wird auch der Pacman angepast auf die groese der Zelle. Leider nicht dynamisch,
 * deshalb muessen die Models die gleiche grsse haben wie die schon existierenden Models. Die Fuesse, so
 * wie auch der rucksack, werden seperat geladen und aniemiert. Bein der eingabe von "light" im Konstrucktor
 * wird nur die Lichquelle zurckgegeben. Mit dem String "Moriya" Wird ein seperates Model Geladen, welches
 * hier etwas bevorzugt wird.
 *
 * @author <a href="mailto:karwoth@informatik.uni-frankfurt.de">Christoph Karwoth<</a>
 */
public class PacmanObjTrans extends TransformGroup{


	BoundingSphere bounds =		new BoundingSphere(new Point3d(0.0,0.0,0.0), 0.9); // globale BoundingSphere
	BoundingSphere boundsBh =	new BoundingSphere(new Point3d(0.0,0.0,0.0), 0.9); // globale BoundingSphere
	BoundingSphere boundsLightT =	new BoundingSphere(new Point3d(0.0,0.0,0.0), 80); // globale BoundingSphere

	private Alpha leftAlpha;	// Alpha fuer linken Fuss
	private Alpha rightAlpha;	// Alpha fuer rechten Fuss
	private Alpha bagAlpha;	        // Alpha fuer den Rucksack
        private Alpha hitAlpha;	        // Alpha fuer die sterbe Animation
        private Alpha rotationAlpha;    // Alpha fuer Moriyas schwert
        private Alpha ShieldDownAlpha;  // Alpha fuer ShildDown rotation
        private Alpha ShieldUpAlpha;  	// Alpha fuer Shildup rotation
	private PositionInterpolator leftRotator; 	// Interpolator fuer den linken Fuss
	private PositionInterpolator rightRotator;	// Interpolator fuer den rechten Fuss
	private PositionInterpolator bagRotator;	// Interpolator fuer den Rucksack
        private RotationInterpolator hitRotator; 	// Interpolator fuer die sterbe Animation
        private RotationInterpolator rotator; 		// Interpolator fuer Schwert von Moriya
        private RotationInterpolator ShieldDownRotator; // Interpolator fuer ShieldDown
        private RotationInterpolator ShieldUpRotator; 	// Interpolator fuer ShieldUp

        private Switch m_oSW; 		// fuer die anzeige von schildern

	private String m_sURL=null; 	// fuer die URL des neuen Models

	private boolean m_bCreateLight = true;	// Soll Packman beleuchtet werden?
	private boolean m_bCreateBag=true;	// Ob Packman einen rucksag tragen soll
        private boolean m_bLow=true; 		// Sandart ist Low-Res
        private boolean m_bDie=false; 		// fuer das wiederbeleben
        private boolean m_bMoriya=false; 	// Model Moriya ja /nein


	// Definiere Mir Farben
	private static final Color3f black	= new Color3f(0.0f, 0.0f, 0.0f);
	private static final Color3f white	= new Color3f(1.0f, 1.0f, 1.0f);
	private static final Color3f red	= new Color3f(1.0f, 0.0f, 0.0f);
	private static final Color3f blue	= new Color3f(0.0f, 0.0f, 1.0f);
	private static final Color3f yellow	= new Color3f(1.0f, 1.0f, 0.0f);
	private static final Color3f purple	= new Color3f(1.0f, 0.0f, 1.0f);
	private static final Color3f gray	= new Color3f(0.5f, 0.5f, 0.5f);


	/**
	 * <code>PacmanObjTrans</code> ist der
	 * Konstrucktor fr den Standart Packman
	 *
	 * Standartwerte:
	 *  Strin sURLparm = "./models/pacman/body_low.wrl" (Standart Model)
	 *  boolean m_bCreateLight = true 	(Packman wird beleuchtet)
	 *  boolean m_bCreateBag=true 		( Packman traegt Rucksag)
         *  boolean m_bLow=true			(Sandart ist Low-Res)
         *
	 */
	public PacmanObjTrans(){
		CreatePacman("./models/pacman/body_low.wrl");

	}

	/**
	 * <code>PacmanObjTrans</code> ist der
	 * Konstrucktor, der den mit dem man Paths  des Models in Form vom String
	 * einen Neues Model laden kann fr den Pacman. Wird bei CreateObject verwendet.
	 *
	 * @param sURLparam ein <code>String</code> mit URL fr den 3ds bzw WRL Model, oder den String "light" fuer nur Licht oder "Moriya" nur sonder Model
	 */
	public PacmanObjTrans(String sURLparam){

                m_sURL = sURLparam;
		CreatePacman(sURLparam);

	}

	/**
	 * <code>PacmanObjTrans</code> ist der
	 * Konstrucktor, der den mit dem Man per URL in Form vom String
	 * einen Neues Model Laden kann fr den Pacman. Wird bei CreateObject verwendet,
	 * sowei mehreren optionen.
	 *
	 * @param sURLparam ein <code>String</code> mit URL fr den 3ds bzw WRL Model, oder den String "light" fuer nur Licht oder "Moriya" nur sonder Model
	 * @param bCreateLight ein <code>boolean</code> fuer Licht ein oder aus.
	 * @param bCreateBag ein <code>boolean</code> ob der Rucksack dran soll oder nicht
	 */
	public PacmanObjTrans(String sURLparam, boolean bCreateLight, boolean bCreateBag){
		m_bCreateBag = bCreateBag;
		m_bCreateLight =bCreateLight;
		m_sURL = sURLparam;
		CreatePacman(sURLparam);

	}

	/**
	 * <code>PacmanObjTrans</code> ist der
	 * Konstrucktor, der den mit dem Man per URL in Form vom String
	 * einen Neues Model Laden kann fr den Pacman. Wird bei CreateObject verwendet,
	 * sowei mehreren optionen.
	 * Hier koenne auchdie Hi-Res Models optional geladen werden.
	 *
	 * @param sURLparam ein <code>String</code> mit URL fr den 3ds bzw WRL Model, oder den String "light" fuer nur Licht oder "Moriya" nur sonder Model
	 * @param bCreateLight ein <code>boolean</code> fuer Licht ein oder aus.
	 * @param bCreateBag ein <code>boolean</code> ob der Rucksack dran soll oder nicht
	 * @param bLow ein <code>boolean</code>, der ein bei enable die Hi-Res Models/Assesuars laed.
	 */
	public PacmanObjTrans(String sURLparam, boolean bCreateLight, boolean bCreateBag, boolean bLow){
		m_bCreateBag = bCreateBag;
		m_bCreateLight =bCreateLight;
		m_sURL = sURLparam;
                m_bLow=bLow;
		CreatePacman(sURLparam);

	}


	/**
	 * <code>CreatePacman()</code> ist die
	 * Funktion, mit der der Pacman hier erstellt wird
	 * und in die TransformGroup Gepackt wird. Diese Funktion wird vom Konstrutor aufgerufen.
	 */
	public void CreatePacman(String sURLparam){

		m_sURL = sURLparam;

		// Einstellung von Capability
		this.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

		//Packman einfgen
		Transform3D tP = new Transform3D();
		//Anpassung an Einheitswrfel
		tP.set(0.4f, new Vector3d(0.40f, 0.01f, 0));

		TransformGroup objPacmanTrans = new TransformGroup(tP);
		objPacmanTrans.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		objPacmanTrans.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		objPacmanTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objPacmanTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);


		//TransformGroup fuer Pacmans Body
                Transform3D HitPacman = new Transform3D();
                HitPacman.set(1f, new Vector3d(0f, 0.0f, 0f));
                TransformGroup hitPacmanTrans = new TransformGroup(HitPacman);
		hitPacmanTrans.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		hitPacmanTrans.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		hitPacmanTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		hitPacmanTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

		// Entscheide ob der Standartbody geladen werden soll
		if (m_sURL==null){
                       	m_sURL="./models/pacman/body_low.3ds";
                        hitPacmanTrans.addChild(createObject(5,0.1,-1.1,0,0));  //Der standart Body

		}else{
			// Soll unser spezial Model Moriya geladen werden?
                        if (m_sURL.equalsIgnoreCase("Moriya")){
                                m_bMoriya=true;

				// Low oder Hi Res??
				if (m_bLow){
                                        m_sURL="./models/pacman/Moriya/kobus2_low.wrl";
                                }else{
                                        m_sURL="./models/pacman/Moriya/kobus2.wrl";
                                }

                                hitPacmanTrans.addChild(createMoriya());
                        }else{
			         hitPacmanTrans.addChild(createObject(5,0.1,-1.1,0,0));  //Der standart Body
                        }
		}

		// Unsterblichkeits Visualiesierung fuer alle Models ausser Moriya
                if (!m_bMoriya) {

		   // Switch zum ein bzw ausschalten
                   m_oSW = new Switch();
                   m_oSW.setCapability(Switch.ALLOW_SWITCH_READ);
                   m_oSW.setCapability(Switch.ALLOW_SWITCH_WRITE);
                   m_oSW.setCapability(Switch.ALLOW_CHILDREN_READ);
                   m_oSW.setCapability(Switch.ALLOW_CHILDREN_WRITE);
                   m_oSW.addChild(new TransformGroup ());
                   m_oSW.addChild(createShield());

                   hitPacmanTrans.addChild(m_oSW); // Sield "generieren"
                }


		// Soll Rucksag dran?
                if (m_bCreateBag) {
			// Erstelle BranchGroup Fuer den Rucksack der sich bewegen soll
			BranchGroup bagBranch= new BranchGroup();

			// Erstelle einen Transform fr den Rucksag
			Transform3D tbag = new Transform3D();
			tbag.set(1.0f, new Vector3d(0, 0, 0f));
			TransformGroup bagTrans = new TransformGroup(tbag);

			// Transform an Root BranchGroup
			bagBranch.addChild(bagTrans);

			bagTrans.addChild(createObject(3,0.1,-1.1,0,0.5f));  //Rucksack


			// Bewegung des rucksacks
			TransformGroup bagGroup = new TransformGroup ();
			bagGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
			bagGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

			bagGroup.addChild(bagBranch);

			// now rotate it
			bagAlpha = new Alpha (
					-1,                         // infinite loops
					Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE,    // Hoch und Runer
					0,                          // trigger instantly
					0,                          // no delay
					700,                       // Hoch in 700ms
					0,                          // dont stay
					0,                          // no duration here
					700,                       // Runter in 700 ms
					0,                          // no decreasing
					0 );                        // no decreasing



			Transform3D bAxis = new Transform3D();
			// Drehe die Achsen um Hochrunter bewegeng zu bekommen
			AxisAngle4d bangle = new AxisAngle4d(new Vector3d(1,1,0),Math.PI);
			bAxis.setRotation(bangle); //xAxis an Transform3D
			// Interpolator fur die Bewegeng
			bagRotator = new PositionInterpolator(bagAlpha,bagGroup,bAxis,0.0f,0.05f);
			bagRotator.setSchedulingBounds(boundsBh);
			bagGroup.addChild(bagRotator);

                        hitPacmanTrans.addChild(bagGroup);
		} //Fertig Rucksack


                // Sterbe Animations Rotator
                Transform3D HitPacmanRota = new Transform3D();
                HitPacmanRota.set(2f, new Vector3d(0.0f,-0.9f ,-0.5f));
                // Achse veraendern
                AxisAngle4d angleRota = new AxisAngle4d(new Vector3d(1,1,0),Math.PI);
		HitPacmanRota.setRotation(angleRota); //xAxis an Transform3D

                hitAlpha = new Alpha(
                                        1,                         // one & never
					Alpha.INCREASING_ENABLE,    // Nach unten fallen
					0,                          // trigger instantly
					0,                          // no delay
					1500,                       // inerhalb von 1,5s => sehr tragisch
					0,                          // dont stay
					0,                          // no duration here
					0,                       // when to stay at 1
					0,                          // no decreasing
					0 );
 		//von 0 bis 50
 		hitRotator =new RotationInterpolator(hitAlpha, hitPacmanTrans, HitPacmanRota,
 				     0f, (float) Math.PI*0.3f);

 		hitRotator.setSchedulingBounds(bounds);
 		hitRotator.setEnable(false); // Interpolator erst starten, wenn er Gebraucht wird
                hitAlpha.setStartTime(0);    // Alpha erststarten wenn gebraucht wird
 		objPacmanTrans.setBounds(bounds);
	 	objPacmanTrans.addChild(hitRotator);
                objPacmanTrans.addChild(hitPacmanTrans);

		// Erstelle BranchGroup Fuer den linken Fuss der sich bewegen soll
		BranchGroup lLeg= new BranchGroup();

		Transform3D tlLeg = new Transform3D();
		tlLeg.set(1.0f, new Vector3d(0, 0, 0f));
		TransformGroup lLegTrans = new TransformGroup(tlLeg);
		// Transform an Root BranchGroup
		lLeg.addChild(lLegTrans);

		lLegTrans.addChild(createObject(1,0.1,-1.65,-0.2,0));  // Linker Fuss aler X=-1.65 Scale 0.1

		// Bewegung des linken Fusses
		TransformGroup leftGroup = new TransformGroup ();
		leftGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		leftGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

		leftGroup.addChild(lLeg);
		// now rotate it
		leftAlpha = new Alpha (
				-1,                         // infinite loops
				Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE,    // Hoch und Runter
				0,                          // trigger instantly
				0,                          // no delay
				700,                       // 0,7 secs duration from 0 to 1
				0,                          // dont stay
				0,                          // 0,7 secs duration from 1 to 0
				700,                       // when to stay at 1
				0,                          // no decreasing
				0 );                        // no decreasing


		Transform3D xAxis = new Transform3D();
		AxisAngle4d angle = new AxisAngle4d(new Vector3d(1,1,0),Math.PI);
		xAxis.setRotation(angle); //xAxis an Transform3D
		leftRotator = new PositionInterpolator(leftAlpha,leftGroup,xAxis,0.0f,0.2f);
		leftRotator.setSchedulingBounds(boundsBh);
		leftGroup.addChild(leftRotator);
		objPacmanTrans.addChild(leftGroup);


		// Branchgroup fuer den Rechten Fuss

		BranchGroup rLeg= new BranchGroup();
		// Erstelle einen Transform fr den Fuss
		Transform3D trLeg = new Transform3D();
		trLeg.set(1.0f, new Vector3d(0, 0, 0f));
		TransformGroup rLegTrans = new TransformGroup(trLeg);
		// Transform an Root BranchGroup
		rLeg.addChild(rLegTrans);

		rLegTrans.addChild(createObject(1,0.1,-1.15,-0.2,0));  //Rechter Fuss

		// Bewegung des rechten Fusses
		TransformGroup rightGroup = new TransformGroup ();
		rightGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		rightGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		rightGroup.addChild(rLeg);
		// now rotate it
		rightAlpha = new Alpha (
			-1,                         // infinite loops
			Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE,    // Hoch und Runter
			0,                          // trigger instantly
			0,                          // no delay
			700,                       // 0,7 secs duration from 0 to 1
			0,                          // dont stay
			0,                          // no duration here
			700,                       // 0,7 secs duration from 1 to 0
			0,                          // no decreasing
			0 );                        // no decreasing

		Transform3D yAxis = new Transform3D();
		AxisAngle4d angle2 = new AxisAngle4d(new Vector3d(1,1,0),Math.PI);
		yAxis.setRotation(angle2); //yAxis ist eine Transform3D

		rightRotator = new PositionInterpolator(rightAlpha,rightGroup,yAxis,0.2f,0.0f);
		rightRotator.setSchedulingBounds(boundsBh);
		rightGroup.addChild(rightRotator);

		objPacmanTrans.addChild(rightGroup);



		//Kompleten Packman zurckgeben
		this.addChild(objPacmanTrans);
	}//Pack fertig

        /**
         * <code>createLightTrans(String URL)</code> ist die Funktion,
	 * die die Belaeuchtung vom Pacman erstellt
	 *
	 * @return  eine <code>TransformGroup</code> mit belaeuchtung
	 */
        private TransformGroup createLightTrans(){

		Transform3D tLight = new Transform3D();
		//Anpassung von Licht
		tLight.set(7.f, new Vector3d(0f, 0.0f, 13.0f));


		//PointLight
		TransformGroup objLightTrans = new TransformGroup(tLight);
		objLightTrans.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		objLightTrans.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		objLightTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objLightTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

                Point3f		pLgtPos1 = new Point3f(-0.08f, 0.8f, 0f);
                Point3f		pLgtAtt1 = new Point3f(0, 1.2f, 0);
		PointLight	pLgt1	= new PointLight(new Color3f(1f,1f,1f),pLgtPos1,pLgtAtt1);
		pLgt1.setInfluencingBounds(boundsLightT);

		objLightTrans.addChild(pLgt1);
		//objLightTrans.addChild(createObject(4,0.2,-0.08f,0.8f,0f));  //Ball

		Point3f		pLgtPos2 = new Point3f(0.08f, -0.7f, 0);
		Point3f		pLgtAtt2 = new Point3f(0.0f, 1.2f, 0f);
		PointLight	pLgt2	= new PointLight(new Color3f(1f,1f,1f),pLgtPos2,pLgtAtt2);
		pLgt2.setInfluencingBounds(boundsLightT);

		objLightTrans.addChild(pLgt2);
                return objLightTrans;
	}// belaeuchtung fertig

	/**
	 * <code>createObject</code> erstellt das Model.
	 * Bei m_shape 0 laed er den Standart Body des Pacman.
	 * Bei m_shape 1 laed er den Standart  Fuss des Pacman(nur einzeln).
	 * Bei m_shape 2 Wird der beweglcihe Arm von Model "Moriya" geladen.
	 * Bei m_shape 3 Hi bzw Low-Res Rucksag
	 * Bei m_shape 4 Hilfskugel zu orientierung von Positionen
	 * Bei m_shape 5 laed er den Body des Pacman, der als URL mitgeliefert wurde.
	 * Bei m_shape 6 Moriyas Kopf mit Textur
	 * Bei m_shape 7 oberes Schild (Unsterblichkeit)
	 * Bei m_shape 8 unterses Schild (Unsterblichkeit)
	 *
	 * @param m_shape ein <code>int</code> s.o Beschreibung
	 * @param scale ein <code>double</code> skalierung des objektes
	 * @param xpos ein <code>double</code> Wert fuer die x-position
	 * @param ypos ein  <code>double</code>  Wert fuer die y-position
	 * @return eine <code>TransformGroup</code> value
	 */
	private Group createObject(int m_shape, double scale,
				   double xpos, double ypos, double zpos) {


		//Erstelle TransformGroup fuer Models
		Transform3D tModel = new Transform3D();
		tModel.set(scale, new Vector3d(xpos, ypos, zpos));
		AxisAngle4d angle = new AxisAngle4d(new Vector3d(0,1,1),Math.PI);
		tModel.setRotation(angle); //xAxis an Transform3D

		TransformGroup objTransModel = new TransformGroup(tModel);
		objTransModel.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		objTransModel.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		objTransModel.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objTransModel.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

		// Fr die objekte des Models
		com.sun.j3d.utils.geometry.Primitive shape = null; // Die kugeln mit Textur
		Shape3D shape2; // die Models

		//je nach Wunsch
		switch (m_shape) {
		default: case 0: // loader StandartBody

			try{
				Loader model = new Loader(); // Body
				objTransModel.addChild(model.getBranchGroup());
			}catch(Exception ex) {
			ex.toString();
			System.out.println("Eine Exeption im Loader");
			}
			break;

		case 1: // loader Fuesse

			try{	//Hi-Low-Res
                              if (!m_sURL.equalsIgnoreCase("light")){
                                if (m_bLow) {
                                  Loader model = new Loader("./models/pacman/feet_low.wrl");
                                  objTransModel.addChild(model.getBranchGroup());
                                }else{
                                  Loader model = new Loader("./models/pacman/feet.wrl");
                                  objTransModel.addChild(model.getBranchGroup());
                                }
                               }
			}catch(Exception ex) {
			ex.toString();
			System.out.println("Eine Exeption im Loader");
			}
			break;

		case 2: // loader Arm von Moriya

			try{	//Hi-Low-Res
				if (m_bLow){
                                Loader model = new Loader("./models/pacman/Moriya/Hand4_low.wrl");
                                objTransModel.addChild(model.getBranchGroup());
                                }else{
                                Loader model = new Loader("./models/pacman/Moriya/Hand4.wrl");
                                objTransModel.addChild(model.getBranchGroup());
                                }
			}catch(Exception ex) {
			ex.toString();
			System.out.println("Eine Exeption im Loader");
			}
			break;

            case 3: // loader uebergebene URL Mit Packbag

			try{	//Hi-Low-Res
                              if (!m_sURL.equalsIgnoreCase("light")){
				if (m_bLow) {
                                        Loader model = new Loader("./models/pacman/packbag_low.wrl");
                                	objTransModel.addChild(model.getBranchGroup());
                                }else{
                                        Loader model = new Loader("./models/pacman/packbag.wrl");
                                	objTransModel.addChild(model.getBranchGroup());
                                }
                              }
			}catch(Exception ex) {
			ex.toString();
			System.out.println("Eine Exeption im Loader");
			}
			break;


		case 4: // Hilfs Kugel

			shape = new com.sun.j3d.utils.geometry.Sphere(0.5f,Sphere.GENERATE_NORMALS,50,createAppearance(1));
			objTransModel.addChild(shape);
                        break;

                case 5: //Loder Packman

                        try{
                                BranchGroup br = new BranchGroup();
                                br.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
                                br.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
                                if (!m_sURL.equalsIgnoreCase("light")){
				  Loader model = new Loader(m_sURL);
                                  br = model.getBranchGroup();
                                  br.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
                                  br.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
                                }
                                //Erstellen von Licht (ja/nein)
		                if (m_bCreateLight) br.addChild(createLightTrans());

                                objTransModel.addChild(br);
			}catch(Exception ex) {
			ex.toString();
			System.out.println("Eine Exeption im Loader");
			}
			break;

                case 6: // Morias Kopf mit Textur

                        BranchGroup br = new BranchGroup();
                        br.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
                        br.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
                        Appearance appe=new Appearance();
                        appe.setCapability(Appearance.ALLOW_COLORING_ATTRIBUTES_READ);
                        appe.setCapability(Appearance.ALLOW_COLORING_ATTRIBUTES_WRITE);
                        appe.setCapability(Appearance.ALLOW_TEXTURE_ATTRIBUTES_READ);
                        appe.setCapability(Appearance.ALLOW_TEXTURE_ATTRIBUTES_WRITE);
                        TextureLoader tex = new TextureLoader("./models/pacman/Moriya/morya.jpg", new Frame());
                        appe.setTexture(tex.getTexture());
			TextureAttributes texAttr = new TextureAttributes();
	   		texAttr.setTextureMode(TextureAttributes.MODULATE);
                        appe.setTextureAttributes(texAttr);
                        Material ma = new Material(white,black,white,black,1.0f);
                        appe.setMaterial(ma);

                        shape = new com.sun.j3d.utils.geometry.Sphere(4.0f,Sphere.GENERATE_TEXTURE_COORDS,appe);
                        //Kopf richtig rudrehen
                        Transform3D tM = new Transform3D();
		        tM.set(1, new Vector3d(0, 0, 0));
                        AxisAngle4d atM = new AxisAngle4d(new Vector3d(1f,0f,0f), 0.5f *Math.PI);
	                tM.setRotation(atM); //xAxis ist eine Transform3D
                      	TransformGroup objTM = new TransformGroup(tM);
                        objTM.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
                        objTM.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
                        objTM.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
                        objTM.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
                        objTM.addChild(shape);
                        br.addChild(objTM);
                        objTransModel.addChild(br);
			break;

             	case 7: // Unteres Schield

			try{	// Hi-Loe-Res
				if (m_bLow) {
                                        Loader model = new Loader("./models/pacman/shield_down_low.wrl");
                                	objTransModel.addChild(model.getBranchGroup());
                                }else{
                                        Loader model = new Loader("./models/pacman/shield_down.wrl");
                                	objTransModel.addChild(model.getBranchGroup());
                                }
			}catch(Exception ex) {
			ex.toString();
			System.out.println("Eine Exeption im Loader");
			}
			break;

               	case 8: // Oberes Schild

			try{	// Hi-Loe-Res
				if (m_bLow) {
                                        Loader model = new Loader("./models/pacman/shield_up_low.wrl");
                                	objTransModel.addChild(model.getBranchGroup());
                                }else{
                                        Loader model = new Loader("./models/pacman/shield_up.wrl");
                                	objTransModel.addChild(model.getBranchGroup());
                                }
			}catch(Exception ex) {
			ex.toString();
			System.out.println("Eine Exeption im Loader");
			}
			break;
		}// end Case

		return objTransModel;

	}// End Create


	 /**
	 * <code>createAppearance</code> fuer die hielfskugel(i=0)
	 *
	 * @param i int
	 * @return apperearance
	 */
	private Appearance createAppearance(int i) {

		Appearance app = new Appearance();
		Material ma;

		switch (i) {

		default: case 0: // Kugen zum Testen
			ma = new Material(white,yellow,yellow,white,1.0f);
			break;
		}
			app.setMaterial(ma);
			return app;
	}// End createAppearance


	/**
	* <code>createMoriya</code> wird das sonder Model Moriya erstellt.
	*
	* @return <code>TransformGroup</code> mit dem Kompleten moriya Model
	*/
        private TransformGroup createMoriya(){

                Transform3D tMoriya = new Transform3D();
		tMoriya.set(1, new Vector3d(0f, 0.0f, 0f));

                TransformGroup objMoriyaTrans = new TransformGroup(tMoriya);
		objMoriyaTrans.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		objMoriyaTrans.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		objMoriyaTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objMoriyaTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

                objMoriyaTrans.addChild(createObject(5,0.1,-1.1,0,0));  //Der Aeussere Body
                objMoriyaTrans.addChild(createObject(6,0.1,-1.1,0,0));  //Die Textur Kugel

                //Arm vom Moriya
                Transform3D tMArm = new Transform3D();
		tMoriya.set(1, new Vector3d(0f, 0.0f, 0f));
                TransformGroup objMoriyaArmTrans = new TransformGroup(tMArm);
		objMoriyaArmTrans.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		objMoriyaArmTrans.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		objMoriyaArmTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objMoriyaArmTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

                objMoriyaArmTrans.addChild(createObject(2,0.1,0,0,0));  //Der Arm vom Moriya

                Transform3D MoriyaHit = new Transform3D();
                MoriyaHit.set(0.7f, new Vector3d(-1.1f, 0.0f, 0f));
                AxisAngle4d MHangle = new AxisAngle4d(new Vector3d(0,0,0),2*Math.PI);
                MoriyaHit.setRotation(MHangle);

                rotationAlpha = new Alpha(
                                        -1,                         // infinite loops
					Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE,    // increasing parameters active
					0,                          // trigger instantly
					0,                          // no delay
					2000,                       // 2 secs duration from 0 to 1
					0,                          // dont stay
					0,                          // no duration here
					2000,                       // 2 secs duration from 1 to 0
					0,                          // no decreasing
					0 );
 		rotator = new RotationInterpolator(rotationAlpha, objMoriyaArmTrans, MoriyaHit,
 				     0f, (float) Math.PI*1.0f);

 		rotator.setSchedulingBounds(bounds);
 		objMoriyaTrans.setBounds(bounds);
                rotator.setEnable(false);  // noch nicht bewegen erst im Angrifsmodus
                rotationAlpha.setStartTime(0);
 		objMoriyaTrans.addChild(rotator);
                objMoriyaTrans.addChild(objMoriyaArmTrans);

                return objMoriyaTrans;
        } // end createMoriya


        /**
        * <code>createShield</code> werden die schilder fr die Visualiesierung von
        * Angrifsmodus/unsterblichkeit erstellt.
	*
	* @return <code>TransformGroup</code> mit den Sildern.
        */
        private TransformGroup createShield(){

                Transform3D tShield = new Transform3D();
		tShield.set(1, new Vector3d(0f, 0.0f, 0f));

                TransformGroup objShieldTrans = new TransformGroup(tShield);
		objShieldTrans.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		objShieldTrans.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		objShieldTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objShieldTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

                // oberes Teil des Schileds

                Transform3D tShieldDown = new Transform3D();
		tShieldDown.set(1, new Vector3d(0f, 0.0f, 0f));

                TransformGroup objShieldDownTrans = new TransformGroup(tShieldDown);
		objShieldDownTrans.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		objShieldDownTrans.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		objShieldDownTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objShieldDownTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

                objShieldDownTrans.addChild(createObject(7,0.1,-1.1,0,0));  //Der untere Shield

                Transform3D ShieldDown = new Transform3D();
                ShieldDown.set(0.7f, new Vector3d(-1.1f, 0.0f, 0f));
                AxisAngle4d ShieldDownAngle = new AxisAngle4d(new Vector3d(0,0,0),2*Math.PI);
                ShieldDown.setRotation(ShieldDownAngle);

                // Recht rum  laufen
                ShieldDownAlpha = new Alpha(
                                        -1,                         // infinite loops
					Alpha.INCREASING_ENABLE ,    // increasing parameters active
					0,                          // trigger instantly
					0,                          // no delay
					2000,                       // 2 secs duration from 0 to 1
					0,                          // dont stay
					0,                          // no duration here
					0,                       // when to stay at 0
					0,                          // no decreasing
					0 );

 		ShieldDownRotator = new RotationInterpolator(ShieldDownAlpha, objShieldDownTrans, ShieldDown,
 				     0f, (float) Math.PI*2.0f);

 		ShieldDownRotator.setSchedulingBounds(bounds);
 		objShieldTrans.setBounds(bounds);
                ShieldDownRotator.setEnable(false); // Noch nicht laufen
                ShieldDownAlpha.setStartTime(0);
 		objShieldTrans.addChild(ShieldDownRotator);
                objShieldTrans.addChild(objShieldDownTrans);


                // unteres Teil des Schileds

                Transform3D tShieldUp = new Transform3D();
		tShieldUp.set(1, new Vector3d(0f, 0.0f, 0f));

                TransformGroup objShieldUpTrans = new TransformGroup(tShieldUp);
		objShieldUpTrans.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		objShieldUpTrans.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		objShieldUpTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objShieldUpTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

                objShieldUpTrans.addChild(createObject(8,0.1,-1.1,0,0));  //Der obere Shield

                Transform3D ShieldUp = new Transform3D();
                ShieldUp.set(0.7f, new Vector3d(-1.1f, 0.0f, 0f));
                AxisAngle4d ShieldUpAngle = new AxisAngle4d(new Vector3d(0,0,0),2*Math.PI);
                ShieldUp.setRotation(ShieldUpAngle);

                // Soll Links rum Laufen
                ShieldUpAlpha = new Alpha(
                                        -1,                         // infinite loops
					Alpha.DECREASING_ENABLE ,    // decreasing parameters active
					0,                          // trigger instantly
					0,                          // no delay
					0,                       // no increasing
					0,                          // dont stay
					0,                          // no duration here
					2000,                       // 2s From 0 to 1
					0,                          // no decreasing
					0 );
 		ShieldUpRotator = new RotationInterpolator(ShieldUpAlpha, objShieldUpTrans, ShieldUp,
 				     0f, (float) Math.PI*2.0f);

 		ShieldUpRotator.setSchedulingBounds(bounds);
 		objShieldTrans.setBounds(bounds);
                ShieldUpRotator.setEnable(false); // noch nicht laufen
                ShieldUpAlpha.setStartTime(0);
 		objShieldTrans.addChild(ShieldUpRotator);
                objShieldTrans.addChild(objShieldUpTrans);

                return objShieldTrans;
        }// End createShield


        /**
        * <code>enableInvincibility</code> ueber diese Funktion kann man den Pacman
	* in Angrifsmodus schalten/ausschalten
	*
	* @param enable ein <code>boolean</code> wird der angrifsmodus ein bzw ausgeschaltet
	*/
        public void enableInvincibility(boolean enable) {

                //pacman3d.util.Debug.out (this.getClass().getName(),"AKTIVITY called",pacman3d.util.Debug.LEVEL_NOTICE);
                // Sonderregelung fuer die visualiesierung von Moriya
                if (m_bMoriya) {
                  rotationAlpha.setStartTime(System.currentTimeMillis()+5);
                  rotator.setEnable(enable);
                }else{
                  // Normales Model
                  if (enable){
                    m_oSW.setWhichChild((1)% m_oSW.numChildren());
                  }else{
                     m_oSW.setWhichChild((0)% m_oSW.numChildren());
                   }

                  ShieldDownAlpha.setStartTime(System.currentTimeMillis()+5); // in 5ms geht es los (unterse links rum)
                  ShieldDownRotator.setEnable(enable);

                  ShieldUpAlpha.setStartTime(System.currentTimeMillis()+5);// in 5ms geht es los (oberes rechts rum)
                  ShieldUpRotator.setEnable(enable);
                }
        }// End enableInvincibility


	/**<code>SetStartStopInterpolator</code> ueber diese Funktion kann man dern Interpolator
	* anhalten oder Stopen, je nach dem wie der <code>boolesn</code> ist.
	*/
	public void SetStartStopInterpolator(boolean enable){

		leftRotator.setEnable(enable); // linker fuss stop/start
		rightRotator.setEnable(enable); // rechter fuss stop/start
		if (m_bCreateBag) {
                  bagRotator.setEnable(enable); // rucksack stop/start
                }
                if (m_bMoriya) {
                  hitAlpha.setStartTime(0); // Arm von moriya
                  rotator.setEnable(false);
                }
        }// End SetStartStopInterpolator


        /** showDeathAnimation()
        *  <p>when called this function will display the death animation
        *  sequence</p>
        */
        public void showDeathAnimation() {
            // zum toggeln ob Tod oder auferstehen
            if (m_bDie==true) {
              m_bDie=false;  // Auferstehen
            }else {
              m_bDie=true; // Sterben
            }
            if (m_bDie==true) {

              SetStartStopInterpolator(false); // Tod vorteuschen => Nicht bewegen
              hitAlpha.setMode(Alpha.INCREASING_ENABLE); // Nach hintenfallen
              hitAlpha.setIncreasingAlphaDuration(1500);// 1,5s bis er umfaellt
              hitAlpha.setStartTime(System.currentTimeMillis()+5); // in 5 ms geht es los
              hitRotator.setEnable(true); //Sterbeanimation starten
            }else {
              SetStartStopInterpolator(true); // aufgastanden => bewegen
              hitAlpha.setMode(Alpha.DECREASING_ENABLE); // aufstetehen
              hitAlpha.setIncreasingAlphaDuration(10); // fast sofort...in 10 ms
              hitAlpha.setStartTime(System.currentTimeMillis()); // jetzt
              hitRotator.setEnable(true); //Aufstehanimation starten
            }
        }// End showDeathAnimation
}// End Class
