package pacman3d.pacman.animation;
import javax.media.j3d.*;
import javax.vecmath.*;

public class PacImage extends TransformGroup{
    BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0,0.0),100.0);
    float n_r1 = 1.0f;
    float n_r2 = 0.15f;
    Color3f yellow = new Color3f(0.7f, 0.5f, 0.0f);
    Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    TriangleFanArray pacgeometry[] = new TriangleFanArray[3];
    int n_anglecount2 = 32;
    TransformGroup pacTG;

    double n_anglecount1[] = {Math.PI/4.0, Math.PI/8.0, Math.PI/16.0};

    private TriangleFanArray pacmaker(double n_angle, float n_radius, Color3f o_color){
        TriangleFanArray oa_pactfa;
        double n_degree = n_angle/2.0;
        Point3f coords[] = new Point3f[26];
        int stripCounts[] ={26};
        float n_x, n_y;
        Color3f colors[] = new Color3f[26];
        coords[0] = new Point3f(0.0f, 0.0f, 0.0f);
        colors[0] = o_color;

        for (int n_loop = 1; n_loop < coords.length; n_loop++){
            n_x = (float) (n_radius*Math.cos(n_degree + (n_loop-1)*(2*Math.PI-n_angle)/24.0));
            n_y = (float) (n_radius*Math.sin(n_degree + (n_loop-1)*(2*Math.PI-n_angle)/24.0));
            colors[n_loop] = o_color;
            coords[n_loop] = new Point3f(n_x, n_y, 0.0f);
        }

        oa_pactfa = new TriangleFanArray(26, TriangleFanArray.COORDINATES | TriangleFanArray.COLOR_3, stripCounts);
        oa_pactfa.setCoordinates(0, coords);
        oa_pactfa.setColors(0, colors);
        return oa_pactfa;
    }

    private TransformGroup Givingcapability() {
        TransformGroup temTG = new TransformGroup ();

        temTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        temTG.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        temTG.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
        temTG.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
        temTG.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

        return temTG;
    }
    public PacImage(){
       for (int m = 0; m<3; m++){
                pacgeometry[m] = pacmaker(n_anglecount1[m], n_r1, yellow);
        }
        Morph morph = new Morph(pacgeometry);
        morph.setCapability(Morph.ALLOW_WEIGHTS_READ);
        morph.setCapability(Morph.ALLOW_WEIGHTS_WRITE);
        Node eye = new Shape3D(pacmaker(0.0d, n_r2, black));
        pacTG =  Givingcapability();

        TransformGroup headTG = Givingcapability();
        Transform3D headtranslate = new Transform3D();
        headtranslate.setTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        headTG.setTransform(headtranslate);
        headTG.addChild(morph);
        Alpha morphAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE |
                                     Alpha.DECREASING_ENABLE,
                                     0, 0,
                                     500, 0, 0,
                                     500, 0, 0);

        MorphingBehavior mBeh = new MorphingBehavior(morphAlpha, morph);
        mBeh.setSchedulingBounds(bounds);
        headTG.addChild(mBeh);
        pacTG.addChild(headTG);

        TransformGroup eyeTG = Givingcapability();
        Transform3D eyetranslate = new Transform3D();
        eyetranslate.setTranslation(new Vector3f(0.3f, 0.55f, 0.01f));
        eyeTG.setTransform(eyetranslate);
        eyeTG.addChild(eye);
        pacTG.addChild(eyeTG);

        Billboard billboard = new Billboard(pacTG);
        billboard.setSchedulingBounds(bounds);
        pacTG.addChild(billboard);
        this.addChild(pacTG);

        //this.addChild(new Sphere(1.0f,new Appearance()));
        //Transform3D oT3d = new Transform3D();
        //oT3d.setTranslation(new Vector3d(0.0,0.0,-0.8));
        //TransformGroup oTemp = new TransformGroup(oT3d);
        //oTemp.addChild(new Sphere(0.6f,new Appearance()));
        //this.addChild(oTemp);

        this.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        this.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        this.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
        this.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
        this.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
      }
        /** showDeathAnimation()
         *  <p>when called this function will display the death animation
         *  sequence</p>
         */
        public void showDeathAnimation() {
            pacman3d.util.Debug.out (this.getClass().getName(),
                    "deathAnimation called",
                    pacman3d.util.Debug.LEVEL_NOTICE);
        }

}