package pacman3d.pacman.animation;
import java.net.*;
import javax.media.j3d.*;
import com.sun.j3d.loaders.*;
import ncsa.j3d.loaders.*;

/**
 * Title:        Java3D und vrlm
 */
public class Loader {
	ModelLoader oLoader = null;
	Scene oModel = null;

	/**
	 * <code>Loader</code> ist der Standart
	 * Konstrucktor, der den standart Body laedt
	 */
	public Loader() throws java.io.FileNotFoundException {
	   oLoader = new ModelLoader();
	   oModel = oLoader.load("./model/pacman/body.wrl");
	}

	/**
	 * <code>Loader</code> ist der
	 * Konstrucktor, der den mit dem man per URL in Form vom String
	 * einen neuen Model laden kann fuer den Pacman. Wird bei CreateObject verwendet.
	 *
	 * @param sFile ein <code>String</code> mit URL fuer den 3ds Model
	 */
	public Loader(String sFile) throws java.io.FileNotFoundException {
	   oLoader = new ModelLoader();
	   oModel = oLoader.load(sFile);

	}

	/**
	 * <code>Loader</code> ist der
	 * Konstrucktor, der den mit dem man per URL in Form vom String
	 * einen neuen Model laden kann fuer den Pacman. Wird bei CreateObject verwendet.
	 *
	 * @param oURL ein <code>URL</code> mit URL fuer den 3ds Model
	 */
	public Loader(URL oUrl) throws java.io.FileNotFoundException {
	   oLoader = new ModelLoader();
	   oModel = oLoader.load(oUrl);
	   try {
		   oModel = oLoader.load(new URL(""));
	   }
	   catch (Exception ex) {
		   ex.toString();
	   }
	}

	/**
	* <code>getBranchGroup()</code> is die Funktion, die aus dem geladenen Model die
	* komplette BranchGroup zurck gibt.
	*
	* @return <code>BrenchGroup</code> mit dem Model
	*/
	public BranchGroup getBranchGroup() {
	if (oModel != null) {
		return oModel.getSceneGroup();
	}
	return null;

	}

}