package pacman3d.pacman;

import org.w3c.dom.*;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;

import pacman3d.util.*;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import java.io.*;
import java.net.*;

/**
 * <p>title: TestClass</p>
 * <p>description:  this is a simple testclass to check whether or not
 *                  Pacman.loadfromDOM does work.</p>
 * <p>Copyright: Copyright (c) 2001</p>
 * @author Frank Bergmann
 * @version 1.0
 */

public class TestClass {

	/** the pacman to test */
	Pacman m_oPacman;

    public TestClass() {
		m_oPacman = new Pacman();


		// now i'm just going to open a test file and parse it to give it to
		// the pacman
		try {

		  // instantiate DOM
		  DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		  DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
		  Document doc;

		  // try to open the file to see whether it's there or not
		  File oXMLFile = new File("record.xml");
		  if (!oXMLFile.canRead()) {
			System.out.println("can't find input file ... quitting ");
			System.exit(-1);
		  }

		  // since i'm still here the file seams to be there,
		  // so why the nasty null pointers ... better start outputting the
		  // file
		  int nChar;
		  FileInputStream oFIS= new FileInputStream(oXMLFile);
		  StringBuffer oBuffer = new StringBuffer();
		  while (( nChar= oFIS.read()) != -1) {
			System.out.print((char)nChar);
			oBuffer.append((char)nChar);
		  }
		  // parse document
		  doc = docBuilder.parse (oXMLFile);
		  // normalize text representation
		  doc.getDocumentElement().normalize ();

		  System.err.println("doc created: " + doc.toString() +
			    " doctype: " + doc.getDoctype());


		  // now get root element and pass it to pacman
		  Element elDoc = doc.getDocumentElement();
		  m_oPacman.loadFromDOM(elDoc);

		  // now let's try to save the messages from the pacman
		  Document oNewDoc = docBuilder.newDocument();
		  Element oNewEl = m_oPacman.saveToDOM(oNewDoc);
		  oNewDoc.appendChild(oNewEl);

		  org.apache.xml.serialize.OutputFormat oOut = new org.apache.xml.serialize.OutputFormat(oNewDoc);
		  org.apache.xml.serialize.XMLSerializer oXMLSer = new org.apache.xml.serialize.XMLSerializer((OutputStream)System.out,oOut);
		  oXMLSer.serialize(oNewDoc);
		  oXMLSer.endDocument();

		} catch (Exception ex) {
			System.err.println("oups: " + ex.toString());
			ex.printStackTrace();
		} finally {
			// in case of an error make sure that i quit
			System.exit(0);
		}

    }
    public static void main(String[] args) {
        TestClass testClass1 = new TestClass();
    }
}