package pacman3d.net.testing;

import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import pacman3d.net.*;
/**
 * Insert the type's description here.
 * Creation date: (08.12.2001 11:12:59)
 * @author:
 */
public class SimpleClientTest
	extends Frame
	implements NetworkListener, ActionListener, ItemListener {
	private TextArea ta = new TextArea();
	private Button send_button = new Button("senden");
	private NetworkService client;
	private CheckboxGroup check_group = new CheckboxGroup();
	private Checkbox loop_checkbox = new Checkbox("auto reply", check_group, false);
	private Checkbox single_checkbox =
		new Checkbox("single message", check_group, true);
	private TextField single_field = new TextField("", 50);
	private boolean auto_reply = false;
	private CheckboxGroup typ_group = new CheckboxGroup();
	private Checkbox tcp_checkbox = new Checkbox("TCP", typ_group, true);
	private Checkbox udp_checkbox = new Checkbox("UDP", typ_group, false);
	/**
	 * TCPTester constructor comment.
	 */
	public SimpleClientTest() {
		setTitle("TCP-Client von Netz+IntroTest");
		setSize(600, 400);
		setLocation(500, 600);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				Window w = e.getWindow();
				w.dispose();
				if (client != null)
					client.closeNetwork();
				System.exit(0);
			}
		});
		initialize();
		setVisible(true);
	}
	/**
	 * Invoked when an action occurs.
	 */
	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();

		if (source == send_button) {
			String text = single_field.getText();
			ta.append("sending message-string: \"" + text + "\"\n");
			MessageDummy dummy = new MessageDummy(text);
			client.send(dummy);
			single_field.setText("");
		}
	}
	private void changeType(String typ) {
		if (typ == "TCP") {
			if (client != null)
				client = null;
			//client = new TCPClient("192.168.1.1",10000);
			//testing property-support
			client = new TCPClient();
			client.addNetworkListener(this);
			client.startNetwork();

		}
		else if (typ == "UDP") {
			if (client != null)
				client = null;
			/*client = new UDPClient();
			client.registerListener(this);
			client.startNetwork();*/
		}
	}

	/**
	 * Methode zum Empfangen von Nachrichten. Wird beim Erhalt einer Nachricht
	 * aufgerufen.
	 */
	public void dispatchNetworkMessage(NetworkMessage message) {
		MessageDummy dummy = (MessageDummy) message;
		ta.append("message received: \"" + dummy.toString() + "\"\n");
		if (auto_reply)
			client.send(message);
	}
	private void initialize() {
		setLayout(new BorderLayout());
		ta.setEditable(false);
		add("Center", ta);
		Panel oben = new Panel();
		oben.add(send_button);
		send_button.addActionListener(this);
		oben.add(loop_checkbox);
		loop_checkbox.addItemListener(this);
		oben.add(single_checkbox);
		single_checkbox.addItemListener(this);
		oben.add(tcp_checkbox);
		tcp_checkbox.addItemListener(this);
		oben.add(udp_checkbox);
		udp_checkbox.addItemListener(this);
		add("North", oben);
		Panel unten = new Panel();
		unten.add(single_field);
		unten.add(send_button);
		add("South", unten);
		ta.append("connect to server.\n");
		changeType("TCP");
	}
	/**
	 * Invoked when an item has been selected or deselected.
	 * The code written for this method performs the operations
	 * that need to occur when an item is selected (or deselected).
	 */
	public void itemStateChanged(ItemEvent e) {
		Object source = e.getSource();
		if (source == single_checkbox) {
			single_field.setText("");
			single_field.setEditable(true);
			send_button.setEnabled(true);
			auto_reply = false;
		}
		else if (source == loop_checkbox) {
			single_field.setText("auto-reply-mode active.");
			single_field.setEditable(false);
			send_button.setEnabled(false);
			auto_reply = true;
		}
		else if (source == tcp_checkbox) {
			changeType("TCP");
		}
		else if (source == udp_checkbox) {
			changeType("UDP");
		}
	}
	/**
	 * Starts the application.
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new SimpleClientTest();
	}
	/**
	 * Methode zum Empfangen von Nachrichten. Wird beim Erhalt einer Nachricht
	 * aufgerufen.
	 */
	public void networkMessageReceived(NetworkMessage message) {
		MessageDummy dummy = (MessageDummy) message;
		ta.append("message received: \"" + dummy.toString() + "\"\n");
		if (auto_reply)
			client.send(message);
	}

	public void networkStatus(int status) {
		String s = null;
		switch (status) {
			case NetworkListener.STATUS_CRASHED :
				s = "STATUS_CRASHED";
				break;
			case NetworkListener.STATUS_DENIED :
				s = "STATUS_FULL";
				break;
			case NetworkListener.STATUS_RECONNECT :
				s = "STATUS_RECONNECT";
				break;
			default :
				s = "meldung neu.";
				break;
		}
		ta.append(s + "\n");
	}

}