package pacman3d.net;

import java.net.*;
import java.io.*;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Jeder TCPServerThread empf&auml;ngt die Nachrichtenpakete eines Clients.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public final class TCPServerThread extends Thread {

	// Referenz zum Server
	private TCPServer server;
	// Zustaendiges Socket
	private Socket socket;
	// dazugehoeriger DataInputStream
	private DataInputStream dataIn;

	/**
	 * Erzeugt TCPServerThread-Instanz und initialisiert Server-Referenz sowie
	 * benutztes Socket.
	 * 
	 * @param server Server-Referenz
	 * @param socket Client-Socket
	 */
	public TCPServerThread(TCPServer server, Socket socket) {
		this.server = server;
		this.socket = socket;
	}

	/**
	 * Liest Nachrichten vom Client und leitet sie an den Server weiter.
	 */
	public void run() {
		try {
			dataIn = new DataInputStream(socket.getInputStream());
			while (true) {
				int status = dataIn.readInt();

				if (status == server.STATUS_HANDSHAKE){
					server.log(this,"run(): message arrived. status = STATUS_HANDSHAKE");
					server.checkHandshake(socket);}

				else {
					server.log(this,"run(): message arrived.");
					int length = dataIn.readInt();
					byte[] bytes = new byte[length];
					dataIn.readFully(bytes);
					if (bytes.length > 0) {
						server.log(this, "run(): read " + bytes.length + " bytes from client.");
                                                NetworkMessage oNetworkMessage =
                                                        server.decodeMessage(bytes);
						server.sendToNetworkListener( oNetworkMessage );
                                                server.send( oNetworkMessage,
                                                        this.socket );
					}
					else
						server.log(this, "run(): read 0 bytes from " + socket);
				}
			}
		}
		catch (Exception ex) {
			server.log(this, ex + " in run(). calling removeConnection()");
			server.removeConnection(socket);
		}
	} //end of run()

} //end of class TCPServerThread