package pacman3d.net;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Jedes registrierte Objekt kann &uuml;ber das Netzwerk Nachrichten
 * empfangen.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public interface NetworkListener {

	
	// codes fuer statusmeldungen
	public static int STATUS_CRASHED = 1;
	public static int STATUS_DENIED = 2;	
	public static int STATUS_RECONNECT = 3;	
	
	// codes nur fuer server (intro)
	public static int STATUS_CONNECTED = 9;
	
	/**
	 * Liefert den Statuscode der Netzwerkschicht.
	 * 
	 * @param status der Netzwerkschichtstatus
	 */
	public void networkStatus(int status);
	
	
	
	/**
	 * Methode zum Empfangen von Nachrichten. Wird beim Erhalt einer Nachricht
	 * aufgerufen.
	 * 
	 * @param message Nachrichtenobjekt
	 */
	public void networkMessageReceived(NetworkMessage message);
	
}
