package pacman3d.net;

import java.net.Socket;
import java.util.Enumeration;

import pacman3d.util.Debug;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Container f&uuml;r Client-Socketverbindungen 
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class ClientList {

	// maximal zugelassene anzahl von clients pro server	
	private final static int MAX_CLIENTS = 4;
	private final static int ABSOLUT_MAX_CLIENTS = 32;

	// datencontainer
	private int[] clients_id;
	private Socket[] clients_socket;
	private int[] clients_status;
	

	/**
	 * Erstellt Container-Instanz mit default-Client-Zahl
	 */
	public ClientList(){
		this(MAX_CLIENTS);	
	}
	

	/**
	 * Erstellt Container-Instanz anhand &uuml;bergebenem Parameterwert.
	 * Die Anzahl der Clients im Container ist auf 32 begrenzt. Wird dieser
	 * Wert &uuml;berschritten, dann ist der Standardwert 4.
	 * 
	 * @param maxClients Client-Obergrenze im Container
	 */	
	public ClientList(int maxClients){
		if ((maxClients < 1) && (maxClients > ABSOLUT_MAX_CLIENTS)) maxClients = MAX_CLIENTS;
		clients_id = new int[maxClients];
		clients_socket = new Socket[maxClients];
		clients_status = new int[maxClients];		
	}	
	
	
	/**
	 * F&uuml;gt einen Clienteintrag dem Container hinzu, falls Eintrag noch nicht in der
	 * Liste oder id bereits bekannt
	 * 
	 * @param socket Socket des Clients
	 * @param status aktueller Statuscode des Clients
	 * @param hashcode ID des Eintrags im Container
	 * @return wurde Client im Container akzeptiert
	 */
	public synchronized boolean addClient(Socket socket, int status, int hashcode){
		//schon in liste gwesen?
		int j = fromList(hashcode);
		if (j != -1){
				clients_socket[j] = socket;
 				clients_status[j] = status;			
 				Debug.out(getClass().getName(),"client from list", Debug.LEVEL_NOTICE);
				return true;
		}
		//sonst freie stelle suchen
		if ((inList(socket) == -1) && (socket != null)) {
			int i = freePos();
			if (i != -1){
				clients_id[i] = hashcode;
				clients_socket[i] = socket;
 				clients_status[i] = status;
 				Debug.out(getClass().getName(),"client not in list. added.", Debug.LEVEL_NOTICE); 				
 				return true;
			}							
			return false;
		}	
		return false;	
	}
	
	
	/**
	 * Entfernt einen Clienteintrag aus dem Container.
	 * 
	 * @param socket Socket des Clients, der entfernt werden soll
	 */	
	public synchronized void removeClient(Socket socket){
		if (socket != null) {
		int i = inList(socket);
		if (i != -1){
			clients_id[i] = -1;
			clients_socket[i] = null;
			clients_status[i] = -1;
		} 
		// else not in list
		}
	}
	
	
	/**
	 * Gibt Statuswert eines Client zur&uuml;ck
	 * 
	 * @param socket Client-Socket
	 * @return Status des Clients
	 */
	public int getStatus(Socket socket){
		int i = inList(socket);
		if (i != -1) return clients_status[i];
			else return -1;
	}
	
	/**
	 * Setzt Statuswert f&uuml:r einen Client
	 * 
	 * @param socket Client-Socket
	 * @param status Statuscode
	 */
	public void setStatus(Socket socket, int status){
		int i = inList(socket);
		if (i != -1) { 
			clients_status[i] = status;
		}
	}
	
	
	/**
	 * Pr&uuml;ft, ob Client im Container und gibt Position zur&uuml;ck.
	 * Ist der Eintrag nicht vorhanden, liefert inList -1.
	 * 
	 * @param socket Client-Socket
	 * @return Position im Container
	 */
	private int inList(Socket socket){
		for (int i = 0; i < clients_socket.length; i ++){
			if (socket == clients_socket[i]) return i;
		}
		return -1;	
	}


	/**
	 * Pr&uuml;ft, ob Client in der Liste bereits eingetragen ist.
	 * 
	 * @param hashcode ID des Eintrags
	 * @return Position des Eintrags
	 */
	private int fromList(int hashcode){
		for (int i = 0; i < clients_socket.length; i ++)
			if (hashcode == clients_id[i]) return i;
		return -1;
	}
	
	
	/**
	 * Bestimmt die n&auml;chste freie Position im Array. Gibt -1 zur&uuml;ck, falls
	 * alle Eintr&auml;ge besetzt sind.
	 * 
 	 * @return Position des ersten freien Eintrags
	 */
	private int freePos(){
		for (int i = 0; i < clients_socket.length; i ++){
			if (clients_socket[i] == null) return i;
		}
		return -1;		
	}
	

	/**
	 * Gibt alle Eintr&auml;ge des Containers zur&uuml;ck.
	 * 
	 * @return Socket-Array aus Container
	 */	
	public Socket[] getSockets(){
		return clients_socket;
	}

	
}//end of class ClientList

