// MonsterVoice.java
package pacman3d.monster;

//import pacman3d.monster.*;
import pacman3d.message.*;
import java.util.LinkedList;

public class MonsterVoice extends Object
{
	private Monster monster;
	private ID id;
	private MonsterChannel platform;
	private LinkedList messageQueue;

	public MonsterVoice(MonsterChannel platformTemp, ID ids, Monster monsterle)
	{
		platform = platformTemp;
		id = ids;
		monster = monsterle;
		messageQueue = new LinkedList();
        }
        /**
         * sendet eine Nachricht an alle anderen Monster
         */
        public void sendMessage(MonsterMessage message)
        {
          	monster.getChannel().doBroadcast(id, message);
        }
        /**
         * wertet empfangene Nachrichten aus
         */
        public void receiveMessage(MonsterMessage message)
        {
        	messageQueue.add(message);

		monster.getAwareness().writeVoiceInSetup(message.toString());
                //System.out.println("[" + id.toString() + "] recv: " + message);
        }

	/**
	 * liefert letzen Eintrag der Queue
	 * zur Zeit beachten wir nur die jeweils aktuellste
	 * Nachricht und loeschen die Queue
	 */
	public MonsterMessage lookupQueue()
	{
	  MonsterMessage lastMessage = null;

	  if (messageQueue.size() != 0)
	  {
	    lastMessage = (MonsterMessage) messageQueue.getLast();
	    messageQueue.clear();
	  }

	  return lastMessage;
	}

}
