/**
 * MonsterSearchTree.java
 */

package pacman3d.monster;

import java.util.*;
import javax.vecmath.*;

/**
 * <p>Die Klasse MonsterSearchTree beinhaltet den fuer die Errechnung des
 * Pfades und damit fuer die Bewegung der Monster benoetigten Suchbaum.</p>
 */
public class MonsterSearchTree {

  /** MonsterSearchTree als Elternknoten */
  private MonsterSearchTree parent;

  /** Point3i mit Informationen fuer den Suchbaum */
  private Point3i info;

  /** LinkedList mit den Kinder-Knoten */
  private LinkedList childList;

  /** Folgendes wird zurckgeliefert: eine LinkedList mit dem Pfad,
   *  ein IntegerWert mit der Suchtiefe und eine LinkedList, aus der dann
   *  der Pfad berechnet werden kann */
  private LinkedList path;
  private int tiefe;
  private static LinkedList lookupQueue = new LinkedList();

  /**
   * erzeugt einen neuen MonsterSearchTree
   *
   * Benutze ich den parameterlosen Konstruktor???
   */
  public MonsterSearchTree() {

    childList = new LinkedList();
  }

  /**
   * erzeugt einen neuen MonsterSearchTree;
   * konstruiert einen Knoten des Suchbaums
   *
   * @param point dem Knoten entsprechende Zelle
   */
  public MonsterSearchTree(Point3i point)
  {
    info = point;
    childList = new LinkedList();
  }

  /**
   * liefert die Tiefe eines Knotens
   *
   * @return die Tiefe des Knotens als Integer-Wert
   */
  public int getTreeDepth ()
  {
    return tiefe;
  }

  /**
   * liefert die Position der Zelle im Labyrinth, fr welche ein Knoten steht
   *
   * @return die Position der Zelle, fuer die der Knoten steht
   */
  public Point3i getNodeInfo ()
  {
    return this.info;
  }

  /**
   * Diese Methode fgt dem aufrufenden Knoten Kinder hinzu,
   * indem fr das bergebene Element ein neuer Knoten
   * erzeugt wird, welcher den aufrufenden Knoten als Vater erhlt.
   *
   * @param neighbour Nachbarzelle
   */
  public void setNodeChild(Point3i neighbour)
  {
    MonsterSearchTree temp = new MonsterSearchTree ((Point3i) neighbour);
    temp.setParent(this);
    temp.tiefe = this.getTreeDepth() + 1;
    this.childList.addLast(temp);
  }

  /**
   * liefert die Kinder eines Knotens
   *
   * @return Liste der Kinder eines Knotens
   */
  public LinkedList getNodeChildren()
  {
    return childList;
  }

  /**
   * setzt den Elternknoten eines Knotens
   * Diese Methode wird wahrscheinlich berflssig???
   *
   * @param node der zu setzende Knoten
   */
   public void setParent(MonsterSearchTree node)
  {
    parent = node;
  }

  /**
   * Liefert den Vaterknoten eines Knotens
   *
   * @return den Vaterknoten eines Knotens
   */
  public MonsterSearchTree getParent()
  {
    return parent;
  }

  /**
   * Liefert einen "zufllig" ausgewhlten Knoten maximaler Tiefe
   *
   * @param searchTree der Suchbaum
   * @return
   */
  public MonsterSearchTree getRandomNode(MonsterSearchTree searchTree)
  {
    if(!searchTree.getNodeChildren().isEmpty())
    {
      Random random = new Random();
      MonsterSearchTree endCell = (MonsterSearchTree) searchTree.getNodeChildren().
                                      get(random.nextInt(searchTree.getNodeChildren().size())) ;
      return getRandomNode(endCell);
    }
    return searchTree;
  }

  /**
   * Liefert den Pfad von einem Knoten zur Wurzel
   *
   * @param look
   * @return den Pfad von einem Knoten zur Wurzel
   */
  public LinkedList getParents (Point3i look)//, LinkedList lookupQueue)
  {
   //  Die Verwendung der LinkedList lookupQueue wird noch berarbeitet ???
    LinkedList searchPath = new LinkedList();
    //  wenn das gesuchte Element erreicht wurde, wird der Pfad zurckgegeben
      if (this.getNodeInfo().equals(look))
      {
        searchPath.add(this.getNodeInfo());
        return searchPath;
      }
    lookupQueue.clear();

    // wenn dies noch nicht das gesuchte Element ist: suchen im Baum
    MonsterSearchTree temp = this.lookup (look);

    // der Pfad wird zusammengebaut
      while(temp.parent!=null)
      {
        searchPath.addFirst(temp.getNodeInfo());
        temp = temp.getParent();
          if(temp.getParent() == null)
          {
            searchPath.addFirst(temp.getNodeInfo());
          }
      }
    return searchPath;
  }

  /**
   * Diese Methode durchluft den Suchbaum auf der
   * Suche nach dem bergebenen Element (einer Zelle) und liefert
   * NULL zurck, falls es nicht im Baum enthalten ist
   *
   * @param look die Zelle, die abgefragt werden soll
   * @return null, falls das Element nicht im Baum enthalten ist
   */
  public MonsterSearchTree lookup (Point3i look)
  {
    // Rekursion abbrechen, wenn gesuchtes Element gefunden wurde
      if(this.info.equals(look))
      {
        lookupQueue.clear();
        return this;
      }
    // Wenn die Liste der Kinder dieses Knotens nicht leer ist,
    // dann werden sie der lookupQueue hinzugefgt, um sie spter besuchen zu knnen
      if (!this.childList.isEmpty())
      {
        lookupQueue.addAll(this.childList);
      }

      if(lookupQueue.isEmpty() && !this.info.equals(look))
      {
        return null;
      }
    // Die Rekursion luft weiter mit dem noch nicht besuchten, aber
    // aus der Queue gelschten Knoten
    MonsterSearchTree tempTree = (MonsterSearchTree) lookupQueue.getFirst();
    lookupQueue.removeFirst();
    return tempTree.lookup (look);
  }
}