package pacman3d.monster;

import javax.vecmath.Point3i;
import pacman3d.labyrinth.Labyrinth;
import pacman3d.labyrinth.cells.*;//Cell;

public class MonsterProperties
{
  /** Suchtiefe des Monsters, entspricht seinem Aktionsradius */
  private int ghostSearchDepth;

  /** Kommunikationsreichweite des Monsters, Nachrichten von ausserhalb
   *  werden nicht empfangen */
  private int ghostCommunicationRadius;

  /** Strategie des Monsters */
  private int ghostStrategy;

  /** Startposition des Monsters */
  private Point3i ghostPosition;

  /** Monster-Modell das geladen werden soll */
  private int ghostModel;

  /** Monster-Geschwindigkeit */
  private int ghostSpeed;

  /** Fenster zur Konfiguration der Monster-Eigenschaften
   *  sichtbar/nicht sichtbar */
  private boolean ghostSetupWindowVisible;

  /** Referenz auf Labyrinth fuer Suche der Startposition und Methodenaufrufe
   *  durch MonsterChannel
   */
  private Labyrinth monsterGarden;

  // Default Monster-Parameter
  private static int defaultSearchDepth = 5;
  private static int defaultCommRadius = 5;
  private static int defaultStratey = 2;
  private static int defaultModel = 1;
  private static int defaultSpeed = 100;
  private static boolean defaultSetupVisibilaty = true;

  /**
   * alle Monster-Eigenschaften mit Default-Werten initialisieren
   */
  public MonsterProperties(Labyrinth theLaby)
  {
    monsterGarden = theLaby;

    ghostSearchDepth         = defaultSearchDepth;
    ghostCommunicationRadius = defaultCommRadius;
    ghostStrategy            = defaultStratey;
    ghostModel               = defaultModel;
    ghostSetupWindowVisible  = defaultSetupVisibilaty;
    ghostSpeed               = defaultSpeed;

    ghostPosition = null;
  }

  public MonsterProperties(Labyrinth theLaby, int genericMonster)
  {
    System.out.println("Beginn von MonsterProperties");

    monsterGarden = theLaby;

    // zufaellige Startposition fuer Monster suchen
    Cell testCell;
    int xPos, yPos, zPos;
    Point3i labyConstraints = theLaby.getConstraints();

    do
    {
      xPos = (int) Math.floor(Math.random() * labyConstraints.x);
      yPos = (int) Math.floor(Math.random() * labyConstraints.y);
      zPos = (int) Math.floor(Math.random() * labyConstraints.z);

      System.out.println("x " + xPos + " y " + yPos + " z " + zPos);

      testCell = theLaby.getCell(xPos, yPos, zPos);
    }
    while (!testCell.isWalkable());

    // Monster auf gefundene Zelle setzen
    ghostPosition = new Point3i(xPos, yPos, zPos);
    System.out.println("Monster auf Position " + ghostPosition.toString() + " gesetzt.");

    switch (genericMonster)
    {
      case 1:
      {
  ghostCommunicationRadius = 5;
  ghostSearchDepth = 5;
  ghostSetupWindowVisible = true;
  ghostStrategy = 2;

  // TODO: beim Laden abfragen
  ghostModel = 1;

  break;
      }
      default:
      {
        break;
      }
    } // end of switch
  }

  /** Setzen der Kommunikationsweite */
  public void setMonsterCommunicationRadius(int commRadius)
  {
    this.ghostCommunicationRadius = commRadius;
  }

  /** Setzen des zu ladenden Monster-Modells */
  public void setMonsterModel(int modelVersion)
  {
    this.ghostModel = modelVersion;
  }

  /** Setzen der Start-Position */
  public void setMonsterPosition(Point3i initPosition)
  {
    this.ghostPosition = initPosition;
  }

  /** Setzen der Suchtiefe */
  public void setMonsterSearchDepth(int searchDepth)
  {
    this.ghostSearchDepth = searchDepth;
  }

  /** Setup-Fenster anzeigen? */
  public void setMonsterWindowVisibility(boolean windowVisibility)
  {
    this.ghostSetupWindowVisible = windowVisibility;
  }

  /** Setzen der Monster-Strategie */
  public void setMonsterStrategy(int strategyVersion)
  {
    this.ghostStrategy = strategyVersion;
  }

  /** liefert eine Referenz auf das Labyrinth */
  public Labyrinth getLabyrinth()
  {
    return monsterGarden;
  }

  /** liefert die Startposition des Monsters */
  public Point3i getStartPosition()
  {
    return ghostPosition;
  }

  /** gibt an, ob das Setup-Fenster des Monsters sichtbar ist oder nicht */
  public boolean getMonsterWindowVisibility()
  {
    return ghostSetupWindowVisible;
  }


  /** liefert die Kommunikationsreichweite des Monsters */
  public int getMonsterCommunicationRadius()
  {
    return ghostCommunicationRadius;
  }

  /** liefert das zu ladende Monster-Modell */
  public int getMonsterModel()
  {
    return ghostModel;
  }

  /** liefert die eingestellen Monster-Geschwindigkeit */
  public int getMonsterSpeed()
  {
    return ghostSpeed;
  }

  /** liefert die Suchtiefe des Monsters */
  public int getMonsterSearchDepth()
  {
    return ghostSearchDepth;
  }

  /** liefert die Monster-Strategie */
  public int getMonsterStrategy()
  {
    return ghostStrategy;
  }
}