package pacman3d.monster;

import java.lang.*;
import java.util.*;
import java.io.File;

import javax.vecmath.*;
import javax.media.j3d.*;

import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.LoaderBase;

import pacman3d.labyrinth.cells.*;//;Cell;
import pacman3d.message.*;
import pacman3d.util.*;
import pacman3d.pacman.Pacman;

import ncsa.j3d.loaders.ModelLoader;



/**
 * Die MonsterControl steuert die Breitensuche und baut den Szenegraph fuer die
 * Monster auf. Ueber die Methode <code>getView</code> kann die Monster-BranchGroup
 * abgefragt werden.
 */

public class MonsterControl extends Object
{
  /** Referenz auf Monster-Objekt */
  private Monster monster;

  private static MessageService messageService;
  private ID id;

  private LinkedList aktuellerPfad = new LinkedList();
  private LinkedList myQueue = new LinkedList();

  private BranchGroup monsterBranchGroup = new BranchGroup();

  private Switch monsterSwitch = new Switch();

  private Transform3D transAktuellePos = new Transform3D();
  private Transform3D tempTransform = new Transform3D();

  private TransformGroup direction = new TransformGroup();
  private TransformGroup monsterTransformGroup = new TransformGroup();

  private float laufzeit;

  // fr die bermittlung der aktuellen Position und Blickrichtung an den Channel
  private Vector4f vectorForPositionMessage = new Vector4f();

  private double rotationAngle;
  private double tempAngle, stoppingAngle;

  private boolean endReached = true;
  private boolean pacmanIsHunting = false;
  private boolean fluchtwegBerechnet = false;

  // die folgenden Variablen werden fr walkThePath bentigt (ja, im Header)
  private Vector3f turnDirection = new Vector3f();
  private boolean iAmLookingInWalkingDirection = true;
  private boolean zelleErreicht = true;
  int rotationCount = 0;
  private Vector3f currentDirection = new Vector3f();
  private Vector3f movementSpeed    = new Vector3f();
  private Vector3f aktuell          = new Vector3f();
  private Vector3f ziel             = new Vector3f();
  private Point3i initPosition     = new Point3i();
  private Point3i aktuellePosition = new Point3i();
  private Vector3f viewDirection = new Vector3f(0.0f, 0.0f, 1.0f);
  // Ende


  public MonsterControl(Monster monsterle, ID tempId, Point3i positionTemp)
  {
          monster = monsterle;
          initPosition = positionTemp;
          aktuellePosition = positionTemp;
          id = tempId;

          // wir haben nur auf dem Server ein Setup-Fenster
          // System.out.println("isServer ist: " + monster.getChannel().getLabyrinth().isServer());
          if(monster.getChannel().getLabyrinth().isServer() || !monster.getChannel().getLabyrinth().isMultiplayerGame())
               laufzeit = monster.getAwareness().getSpeedFromSetup();
          else laufzeit = 0;

          setMonsterInChannel(id, monster);
          setMonsterPosInChannel(id, aktuellePosition);

          makeMonsterTransformGroup();

          messageService = MessageService.getInstance();
        }

        /**
         * stellt Zugriff auf Labyrinth-Methode dar
         */
        public Point3i getPacmanPosFromChannel (ID pacmanID)
        {
          return monster.getChannel().getPacmanPosFromLaby(pacmanID);
        }
        /**
         * erster Ansatz vom 08.02.02
         * Noch zu klren: Wer schickt wem die Nachricht ber die Jagd?
         */
        public void checkAllPacmanPositions(ID[] pacmanIDs)
        {

        try{
          int i = 0;
          while (pacmanIDs[i] != null)
          {
            if (pacmanReached(pacmanIDs[i]))
            {
              monster.getChannel().sendMessage(pacmanIDs[i], "die");
              monster.getResponse().setPacmanReached(pacmanIDs[i]);
            }
          i++;
          }
          }
          catch(ArrayIndexOutOfBoundsException e)
          {
            //System.out.println("hallo, ich bin outOfBounds");
          }
        }
        /**
         * Signalisiert einen gefangenen PacMan
         */
        public boolean pacmanReached(ID id)
        {
            if(aktuellePosition.equals(monster.getChannel().getPacmanPosFromLaby(id)))
            {
              // System.out.println("Pacman gefangen");
              monster.getChannel().PlaySoundPacmanReached();
              return true;
            }
          //
          return false;
        }
        /**
         * Erzeugt den SzeneGraphen fr das Monster
         * (Dies knnte noch in die Awareness wandern)
         */

         private void makeMonsterTransformGroup()
         {
           // System.out.println("mache monster");


           String path, stringWRL = null;

           Scene model1 = null;

     path = System.getProperty( "user.dir");

    // welches Monster-Modell soll geladen werden?
    String modelFile = null;

    if (monster.getProperties() != null)
    {
      switch (monster.getProperties().getMonsterModel())
      {
        case 1:
        {
          // System.out.println("benutze Kodos");
          modelFile = "Kodos.wrl";
          break;
        }
        case 2:
        {
          // System.out.println("benutze Ghost");
          modelFile = "ghost.wrl";
          break;
        }
        case 3:
        {
          // System.out.println("benutze PacBorg");
          modelFile = "PacBorg_small.wrl";
          break;
        }
        default:
        {
          modelFile = "ghost.wrl";
          break;
        }
      }
      stringWRL = new String(path + "/models/monster/" + modelFile);
    }

    if (stringWRL == null) stringWRL = new String( path + "/models/monster/ghost.wrl");

           monsterTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
     monsterBranchGroup.setCapability(BranchGroup.ALLOW_DETACH);


           Appearance appear = new Appearance();
           Material material = new Material();
           material.setShininess(0.5f);
           material.setAmbientColor(0.0f, 0.3f, 1.0f);
           material.setDiffuseColor(0.0f, 0.3f, 1.0f);
           material.setSpecularColor(0.0f, 0.3f, 1.0f);
           material.setEmissiveColor(0.0f, 0.3f, 1.0f);
           material.setLightingEnable(true);
           appear.setMaterial(material);
/*           RenderingAttributes render = new RenderingAttributes();
           render.setDepthBufferEnable(true);
           render.setVisible(true);
           appear.setRenderingAttributes(render);
           PolygonAttributes attr = new PolygonAttributes();
           attr.setCullFace(PolygonAttributes.CULL_FRONT);
           appear.setPolygonAttributes(attr);
*/
           ModelLoader loader = new ModelLoader();
           try{
             model1 = loader.load(stringWRL);
           }
           catch (Exception e){
             System.out.println(e.getMessage());
             //return;
           }
           //Monster skalieren
          /* TransformGroup modelTransform = new TransformGroup();
           Transform3D modelTrans = new Transform3D();
           modelTrans.setScale(0.05d);
           modelTransform.setTransform(modelTrans);

           modelTransform.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);*/

           //Monster aufrecht stehen lassen
           Transform3D modelRotate = new Transform3D();
           modelRotate.rotX(-1.5708);
           TransformGroup modelRotationGroup = new TransformGroup();
           modelRotationGroup.setTransform(modelRotate);
           modelRotationGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

           //Monster in Blickrichtung drehen
           direction.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
           direction.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

           direction.setTransform(tempTransform);

           //modelTransform.addChild(direction);


//           modelRotationGroup.addChild(modelTransform);

            // unskaliertes Monster einfgen
            modelRotationGroup.addChild(direction);
           direction.addChild(model1.getSceneGroup());

           monsterTransformGroup.addChild(modelRotationGroup);

           monsterSwitch.setCapability(Switch.ALLOW_SWITCH_WRITE);
           monsterSwitch.addChild(monsterTransformGroup);

           monsterBranchGroup.addChild(monsterSwitch);

          // TP, 15.01.02
          // Directionale Lichtquelle erzeugen
          Point3d p2 = new Point3d (0.0d, 0.0d, 0.0d);
          Bounds b2 = new BoundingSphere (p2, 500.0d);
          Color3f dircol = new Color3f(0.01f, 0.01f, 0.01f);
          AmbientLight dir = new AmbientLight();


          dir.setInfluencingBounds(b2);
          //dir.setDirection(0.5f,-0.5f,-1f);
          //dir.setCapability(dir.ALLOW_DIRECTION_READ|
          //dir.ALLOW_INFLUENCING_BOUNDS_READ);
          //monsterTransformGroup.addChild(dir);
          //TP, 15.01.02


          Color3f lightColor = new Color3f(0.2f, 0.6f, 0.1f);
          Point3f lightAttenuation = new Point3f(0.5f, 0.0f, 0.95f);

          // Monster leuchten lassen: Punktlichtquelle an MonsterPos
          PointLight monsterPointLight = new PointLight();
          monsterPointLight.setColor(lightColor);
          BoundingSphere pointLightBounds = new BoundingSphere(new Point3d(), 0.3d);
          monsterPointLight.setInfluencingBounds(pointLightBounds);
          monsterPointLight.setAttenuation(lightAttenuation);



          // Monster leuchten lassen: SpotLight in Laufrichtung
          Vector3f lightPosition = new Vector3f(0.0f, -0.3f, 0.3f);

          TransformGroup lightTransform = new TransformGroup();
          Transform3D light3d = new Transform3D();

          light3d.set(lightPosition);

          lightTransform.setTransform(light3d);

          SpotLight lightPoint = new SpotLight();
          //lightPoint.setPosition(lightPosition);
          lightPoint.setAttenuation(lightAttenuation);
          lightPoint.setColor(lightColor);

          lightPoint.setDirection(0.0f, -1.0f, -0.4f);
          lightPoint.setSpreadAngle(0.628f);
          //lightPoint.setConcentration(0.2f);
          //lightPoint.setBoundsAutoCompute(true);
          BoundingSphere lightBounds = new BoundingSphere(new Point3d(), 3.0d);
          lightPoint.setInfluencingBounds(lightBounds);
          lightTransform.addChild(lightPoint);
          lightTransform.addChild(monsterPointLight);

          direction.addChild(lightTransform);


          Box testBox = new Box (0.1f, 0.4f, 0.1f, appear);

          //lightTransform.addChild(testBox);

        }
        /**
         * Monster im Channel anmelden
         */
        private void setMonsterInChannel(ID id, Monster monster)
        {
          this.monster.getChannel().setMonsterInLaby(id, monster);
        }
        /**
         * Monster Position an Channel bermitteln
         */
        private void setMonsterPosInChannel(ID id, Point3i position)
        {

          // System.out.println("neue Zelle erreicht");

          this.monster.getChannel().setMonsterPosInLaby(id, position);
        }
        private void checkMonsterView ()
        {
          //den aktiven Pacman und dessen Position abfragen
          ID id = monster.getChannel().getPacmanIDFromLaby();
          Point3i pacPoint = monster.getChannel().getPacmanPosFromLaby(id);

          if (pacPoint.y == aktuellePosition.y)
          {
            monsterSwitch.setWhichChild(0);
          }
          else monsterSwitch.setWhichChild(1);
        }
        /**
         * Anzahl der PacMan im Labyrinth von MonsterChannel abfragen
         */
        public int getPacmanCountFromChannel()
        {
          return monster.getChannel().getPacmanCountFromLaby();
        }
        /**
         * die durch die bergebene Position gegebene Zelle abfragen
         */
        private Cell getCellFromChannel(Point3i cellPosition)
        {
          return this.monster.getChannel().getCellFromLaby(cellPosition);
        }
        /**
         * Kann zum Abfragen der MonsterPosition genutzt werden
         */
        public Point3i getMonsterPosition ()
        {
          return aktuellePosition;
        }
        /**
         * Setzt den aktuellen Suchpfad (zu laufenden Weg)
         */
        public void setSearchPath(LinkedList searchPath)
        {
          aktuellerPfad = searchPath;
        }
        /**
         * Flag fr die Koordinierung der Module
         */
        public void newPathComputed()
        {
          endReached = false;
        }
        /**
         * Flag fr die Koordinierung der Module
         */
        public boolean didWeReachTheEnd()
        {
          return endReached;
        }
        /**
         * Monster SzeneGraph abfragen
         */
        public BranchGroup getView()
        {
          //monsterBranchGroup.compile();
          return monsterBranchGroup;
        }
        /**
         * Ermittelt die begehbaren Nachbarn einer Zelle
         */
        private LinkedList getNeighbours(Point3i position)
  {
    LinkedList neighbourList = new LinkedList();

    int x = 0, y = 0, z = 0;
                // wir untersuchen 6 Zellen
                int help[] = {1,0,0,-1,0,0};

                Point3i tempPoint = new Point3i();
                for (int i = 0; i <= 5; i++)
    {
                  x = help[i];
                  tempPoint.set((position.x + x), (position.y + y), (position.z + z));

                  Point3i constraints = this.monster.getChannel().getLabyrinth().getConstraints();
                  if ( tempPoint.x < constraints.x && tempPoint.y < constraints.y && tempPoint.z < constraints.z
                        && tempPoint.x >= 0 && tempPoint.y >= 0 && tempPoint.z >= 0)
                  {
                    Cell tempCell = getCellFromChannel(tempPoint);
                    if(tempCell.isWalkable())
                    {
                      Point3i temp = new Point3i((position.x + x), (position.y + y), (position.z + z));
                      neighbourList.add(temp);
                    }
                  }
                  z=y;
                  y=x;
                }
            return neighbourList;
        }
        /**
         * Suchbaum aufstellen mit Start- und Endpunkt (Abbruchbedingung) und maximaler
         * Tiefe (Abbruchbedingung)
         */
   public MonsterSearchTree doBFS(Point3i startPoint, Point3i endPoint, int maxTiefe)
  {
    LinkedList schonBesucht = new LinkedList();

    LinkedList neighbours = new LinkedList();

                //Die Zelle, ab welcher die Suche startet, in die Queue einfgen
                myQueue.add((Point3i) startPoint);
                //Wurzel des Suchbaums
                MonsterSearchTree searchTree = new MonsterSearchTree (startPoint);
                //Liste mit schon besuchten Knoten
                schonBesucht.add((Point3i) myQueue.getFirst());
                MonsterSearchTree look = searchTree.lookup((Point3i) myQueue.getFirst());

              //solange der Endpunkt (oder maxTiefe) nicht erreicht wurde
        search:{
                while(!endPoint.equals((Point3i) myQueue.getFirst()))
                {

                  //Suchbaum aufbauen
                  neighbours.clear();
                  neighbours = (getNeighbours((Point3i) myQueue.getFirst()));

                  for (int i = 0; i<neighbours.size(); i++)
                  {
                    //Nur noch nicht besuchte Zellen einfgen!!!
                    if(!schonBesucht.contains((Point3i) neighbours.get(i)))
                    {
                      schonBesucht.addLast((Point3i) neighbours.get(i));
                      myQueue.addLast((Point3i) neighbours.get(i));
                      look.setNodeChild((Point3i) neighbours.get(i));
                    }
                  }


                  if(endPoint.equals(myQueue.getFirst()) || myQueue.size() == 1)
                  {
                    break search;
                  }
                  myQueue.removeFirst();

                  look = searchTree.lookup((Point3i) myQueue.getFirst());
                  //So, ist die maximale Tiefe des Suchbaums erreicht?
                  if(look.getTreeDepth() > maxTiefe)
                  {
                    break search;
                  }
                }// end  while(!endPoint.equals((Point3i) myQueue.getFirst()))
            }//end of search
          myQueue.clear();
          schonBesucht.clear();

          return searchTree;

        }
        /**
         * Animiert die Bewegung des Monsters
         */
        public void walkThePath(boolean mayI)
        {
          boolean noRotation;
          int realTicks;

          //Ticks abfragen
          realTicks = monster.getTicks();
          //Erlaubnis kann von Response erteilt werden
          if(mayI)
          {
          //Bedingung fr Ausfhrung
        pfadKleinerEins:{//Dies hier verhindert sinnlose Durchlufe
            if (zelleErreicht)//Setzen dieses Bits muss (sollte) gut berlegt sein
            {



              setMonsterPosInChannel(monster.getMonsterID(), aktuellePosition);
              aktuellePosition = (Point3i) aktuellerPfad.getFirst();

              // jagender Pacmen in der Naehe?? - wir sind erstmal optimistisch gestimmt...
              pacmanIsHunting = false;

              LinkedList closePacmen = getPacmenInRadius(aktuellePosition, 3);
              if ((closePacmen.size() != 0) && (fluchtwegBerechnet == false))
              {

                // jagd einer dieser Pacmaenner?
                for (int i = 0; i < closePacmen.size(); i++)
                {
                  Pacman testPacman = monster.getChannel().getLabyrinth().getPacman((ID) closePacmen.get(i));
                  pacmanIsHunting = testPacman.isInvincible();

                  // Pacman ist auf der Jagd, schnell weg!
                  if (pacmanIsHunting == true) aktuellerPfad.clear();
                  if (testPacman.getID().equals(monster.getChannel().getLabyrinth().getActivePacmanID()))
                  {
                    monster.getChannel().PlaySoundIfPacmanInReach();
                  }
                }
              }


              //aktuelle Position wird in Vector kopiert (wegen Transform3D)
              aktuell.set((float) aktuellePosition.x, (float) aktuellePosition.y, (float) aktuellePosition.z);
              //wenn hier nur noch ein Element enthalten ist, mssen wir am Ziel sein
              if(aktuellerPfad.size()<2)
              {
                endReached = true;
                fluchtwegBerechnet = false;
                aktuellerPfad.clear();
                break pfadKleinerEins;
              }
              //Ziel in Vector3D umwandeln
              Point3i zielPosition = (Point3i) aktuellerPfad.get(1);

              ziel.set((float) zielPosition.x, (float) zielPosition.y, (float) zielPosition.z);
              //Transform3D erzeugen und aktuelle Position bergeben
              transAktuellePos.setTranslation(aktuell);

        float moveX = ((float) (zielPosition.x - aktuellePosition.x)) / laufzeit;
              float moveY = ((float) (zielPosition.y - aktuellePosition.y)) / laufzeit;
              float moveZ = ((float) (zielPosition.z - aktuellePosition.z)) / laufzeit;

        movementSpeed.set(moveX, moveY, moveZ);

              //das hier fngt einen Ebenenwechsel ab und verhindert hier die Drehbewegung,
              //was den Drehwurm vernichtet
              if (Math.abs(zielPosition.y - aktuellePosition.y) == 1.0f)  noRotation = true;
              else                                                        noRotation = false;

        currentDirection.set((float) zielPosition.x, (float) zielPosition.y, (float) zielPosition.z);

        currentDirection.sub(new Vector3f((float) aktuellePosition.x,
                                          (float) aktuellePosition.y,
                        (float) aktuellePosition.z));

        if (!viewDirection.equals(currentDirection) && !noRotation)
        {
    //Dreh-Erweiterungen von Rolf eingebaut: Flag fr sptere Animation setzen
                iAmLookingInWalkingDirection = false;

                turnDirection.cross(currentDirection, viewDirection);
                //System.out.println(" Vektor: "+ turnDirection);

    double monsterTurn = turnDirection.y;

    // Auswertung des Kreuzprodukts: 0 = 180 Grad, 1/-1 = links/rechts
    if (monsterTurn == 0) rotationAngle = Math.PI;
    else                  rotationAngle = -monsterTurn * Math.PI * 0.5d;

                //laufzeit-viele Drehungen werden berechnet, bevor Monster luft
                rotationCount = (int) laufzeit;
                //stoppingAngle erreicht: Abbruch der Drehbewegung
                stoppingAngle = tempAngle + rotationAngle;
        }
              zelleErreicht = false;
              aktuellerPfad.removeFirst();
            }//endif(zelleErreicht)
        }//endOf pfadKleinerEins

          //schaut Monster in gewnschte Richtung?
          if(!iAmLookingInWalkingDirection)
          {
        rotate:
          {
            double tempRotationAngle = rotationAngle / (double) laufzeit;
            double y;
            //fr Anzahl Ticks wird der Rotationswinkel hochgezhlt
            while (realTicks!=0)
            {
              realTicks--;
              tempAngle += tempRotationAngle;

              y = (double) Math.abs (tempAngle-stoppingAngle);
              if(y <= 0.000001d)
              {
                iAmLookingInWalkingDirection = true;
                realTicks = 0;
                viewDirection.set(currentDirection);
                direction.setTransform(tempTransform);
                tempAngle = stoppingAngle;
                break rotate;
              }
            }//end while
          tempTransform.rotZ(tempAngle);
          direction.setTransform(tempTransform);
          }//end rotate
          }//end if(!iAmLookingInWalkingDirection)

          if(iAmLookingInWalkingDirection)
          {

          //Laufe alle Ticks ab
           walk:{
              while (realTicks!=0 && (aktuellerPfad.size()>=1))
              {
                double temp = Math.abs((aktuell.x - ziel.x) + (aktuell.y - ziel.y) + (aktuell.z - ziel.z));

                //die Abfrage in dieser Bedingung geht auf die Genauigkeit bei floatingPoint
                //Operationen zurck. Dort treten bei Verknpfung jeder Art Rundungsfehler auf,
                //so dass 1.0f + 0.01f = 1.000000997 o.. passieren kann.
                //Die Java Klassen fangen dies nicht auf!!!
                if ((1.0d/laufzeit) > temp)
                {
                  zelleErreicht = true;
                  realTicks = 0;
                  break walk;
                }
              aktuell.x += movementSpeed.x;
              aktuell.y += movementSpeed.y;
              aktuell.z += movementSpeed.z;
              //Das hier kann man ausgeben lassen, um sich die Rundungsfehler anzuschauen
              //System.out.println("Vector aktuell nach Addition: " + aktuell.toString());
              transAktuellePos.setTranslation(aktuell);
              realTicks--;
              }//endwhile
            }//endwalk
            }//end if(iAmLookingInWalkingDirection)
          monsterTransformGroup.setTransform(transAktuellePos);

          }//endif(mayI)

        //die monsterView switchen
        checkMonsterView();

        // die aktuelle Position und Blickrichtung in die positionMessage schreiben
        vectorForPositionMessage.x = aktuell.x;
        vectorForPositionMessage.y = aktuell.y;
        vectorForPositionMessage.z = aktuell.z;
        vectorForPositionMessage.w = (float) tempAngle;

        monster.getChannel().writeToPositionMessage(vectorForPositionMessage);
        }
  /**
   * setzt die aktuellen Positionen der Client-Monster
   */
  public void setClientPosition (Vector4f vector)
  {
    aktuell.x = vector.x;
    aktuell.y = vector.y;
    aktuell.z = vector.z;
    //System.out.println("aktuell: " + aktuell.toString());
    tempAngle = (double) vector.w;
    transAktuellePos.setTranslation(aktuell);
    monsterTransformGroup.setTransform(transAktuellePos);
    tempTransform.rotZ(tempAngle);
    direction.setTransform(tempTransform);
    aktuellePosition.x = (int) aktuell.x;
    aktuellePosition.y = (int) aktuell.y;
    aktuellePosition.z = (int) aktuell.z;
    //System.out.println("nach cast: " + aktuellePosition.x);
    setMonsterPosInChannel(monster.getMonsterID(), aktuellePosition);
    checkMonsterView();

    LinkedList closePacmen = getPacmenInRadius(aktuellePosition, 3);
      if ((closePacmen.size() != 0) && (fluchtwegBerechnet == false))
        {
          Pacman testPacman;
            // jagd einer dieser Pacmaenner?
          for (int i = 0; i < closePacmen.size(); i++)
            {
              testPacman = monster.getChannel().getLabyrinth().getPacman((ID) closePacmen.get(i));
              //pacmanIsHunting = testPacman.isInvincible();

              // Pacman ist auf der Jagd, schnell weg!
              //if (pacmanIsHunting == true) aktuellerPfad.clear();
              if (testPacman.getID().equals(monster.getChannel().getLabyrinth().getActivePacmanID()))
                {
                  monster.getChannel().PlaySoundIfPacmanInReach();
                }
              }
            }
  }


  /**
   * liefert eine Liste mit IDs der Pacmen, die sich innerhalb
   * des angegebenen Suchradius befinden; wird benutzt, um zu pruefen,
   * von welchen Pacman der Jagd-Status abgefragt werden muss; kann ebenfalls
   * benutzt werden, um zu pruefen, ob der Monster-Sound zu spielen ist.
   */
  public LinkedList getPacmenInRadius(Point3i currentPos, int radius)
  {
    // Liste fuer Pacmen in der Naehe
    LinkedList pacmenList = new LinkedList();

    // Suchbaum mit angegebenen Radius aufbauen
    Point3i noWay = new Point3i(-1, -1, -1);
    MonsterSearchTree searchTree = doBFS(currentPos, noWay, radius);

    // eine Liste mit allen Pacman-IDs holen
    ID[] pacmenIDs = monster.getChannel().getLabyrinth().getAllPacmanIds();

    for (int i = 0; i < pacmenIDs.length; i++)
    {
      if (searchTree.lookup(getPacmanPosFromChannel(pacmenIDs[i])) != null)
      {
        // untersuchter Pacman ist in Suchbaum -> in Rueckgabe-Liste schreiben
        pacmenList.add(pacmenIDs[i]);
      }
    }

    return (pacmenList);
  }

  /**
   * liefert den aktuellen Flucht-Status; true, wenn gefluechtet werden soll,
   * sonst false...
   */
  public boolean getEscapeState()
  {
    return pacmanIsHunting;
  }

  /**
   * setzt den aktuellen Flucht-Status; true, wenn Fluchtweg berechnet ist,
   * sonst false...
   */
  public void setEscapeComputed(boolean berechnet)
  {
    fluchtwegBerechnet = berechnet;
  }


  /**
   * loescht den berechneten Pfad (zum Beispiel, wenn das Monster
   * getoetet wurde)
   */
  public void moveToInitPosition()
  {
    // Debug.out(this.getClass().getName(), "monster killed", Debug.LEVEL_NOTICE);
    this.aktuellerPfad.clear();
    aktuellePosition = initPosition;
    endReached = true;
  }
}//endOfClass

