/**
 * MonsterAwareness.java
 */
package pacman3d.monster;

import java.util.*;
import javax.vecmath.*;

import java.awt.*;

/**
 * <p>Die MonsterAwareness enthlt das Selbstbild des Monsters.</p>
 *
 * <p>Es fragt die im Setup-Fenster vom Spieler vorgenommenen Einstellungen ab
 * und liefert auch wieder Daten zum Setup-Fenster zurck.</p>
 *
 * <p>Aufgrund der MonsterAwareness werden dann die Strategien fuer das Monster
 * ausgewaehlt.</p>
 */
public class MonsterAwareness extends Object
{
  /** das Monster */
  private Monster monster;

  /** die kommen beide in dieesr Klasse gar nicht mehr vor, wofuer werden die gebraucht??? */
  private Point3i destination = new Point3i();
  private Vector path = new Vector();

  /** das Monster-Setup */
  private MonsterSetup setup;

  /** Linked List mit den zu ladenden Bildern; notwendig ??? */
  private LinkedList pics;

  /** ebenfalls:??? */
  private Image tempImage;

  /**
   * erzeugt eine neue MonsterAwareness
   *
   * @param monsterle ein Monster
   */
  public MonsterAwareness(Monster monsterle)
  {
    monster = monsterle;
    this.setup = new MonsterSetup(this);
    this.setup.show();
    drawMonsterImage(0);
  }

  /**
   * erzeugt eine neue MonsterAwareness;
   * neuer Konstruktor, der die MonsterProperties ins Setup weiterreicht
   *
   * @param monsterProperties
   */
  public MonsterAwareness(MonsterProperties monsterProperties)
  {
    this.setup = new MonsterSetup(monsterProperties);

    if (monsterProperties.getMonsterWindowVisibility())
    {
      this.setup.show();
      drawMonsterImage(0);
    }
  }

  /**
   * Zeichnet im Fenster MonsterSetup das Bild aus der Liste monsterImages mit
   * der Nummer imageNumber
   *
   * @param imageNumber Nummer des im SetupFenster zu zeichnenden gifs
   * @see MonsterSetup
   */
  public void drawMonsterImage (int imageNumber)
  {
    setup.drawMonster(imageNumber);
  }

  /**
   * schleift GameLoop zu Awareness durch
   */
  public void updateAwareness()
  {
    setup.updatePicture();
    setup.updateStatus();

    //MonsterSetup Fenster neu zeichnen. Ohne diesen Aufruf gibt es Probleme mit der Ansicht
    setup.repaint();
  }

  /**
   * fragt den Kommunikationsradius des Monsters von den Eintstellungen
   * im Setup-Fenster ab.
   *
   * @return den eingesetellten Wert fuer den Kommunikationsradius
   */
  public int getCommDistanceFromSetup()
  {
    return setup.getValueCom();
  }

  /**
   * fragt die Suchtiefe des Monsters von den Einstellungen
   * im Setup-Fenster ab.
   *
   * @return den eingesetellten Wert fuer die Suchtiefe
   */
  public int getDepth()
  {
    return setup.getValueSearchDepth();
  }

  /**
   * fragt die Intelligenz (AI) des Monsters von den Einstellunegn
   * im Setup-Fenster ab
   *
   * @return den eingestellten AI-Wert
   */
  public int getAIFromSetup()
  {
    return setup.getValueAI();
  }

  /**
   * liefert die aktuelle Geschwindigkeit des Monsters
   *
   * @return die aktuelle Geschwindigkeit des Monsters
   */
  public float getSpeedFromSetup()
  {
    return setup.getValueSpeed();
  }

  /**
   * setzt den aktuellen Monster-Status im Monster-Setup
   *
   * @param status Integer-Wert, der den Staus des Monsters angibt
   * @see MonsterSetup#setMonsterStatus
   */
   public void setMonsterStatusInSetup(int status)
   {
     setup.setMonsterStatus(status);
   }

   /**
    * setzt die Startposition des Monsters; fuer Wiedergeburt nach "DIE"
    *
    * @param startPosition Point3i mit der Startposition
    */
   public void setMonsterStartPosition(Point3i startPosition)
   {
     setup.setStartPosition(startPosition);
   }

  /**
   *  Schnittstelle zum Setup
   *
   * @return true wenn ein Wert zurckgegeben wird ???
   */
  public boolean getMyStateFromSetup()
  {
    return setup.getMyState();
  }


  /**
   * bermittelt gesendete Nachrichten zwecks Visualisierung an das MonsterSetup
   *
   * @param string String mit der Nachricht
   */
  public void writeVoiceInSetup (String string)
  {
    setup.writeVoice(string);
  }

  /**
   * fragt das Setup ab
   *
   * @return MonsterSetup
   */
  public MonsterSetup getSetup()
  {
    return setup;
  }

}
