/**
 * Monster.java
 */
package pacman3d.monster;

import pacman3d.message.*;
import pacman3d.labyrinth.*;

import java.util.*;
import java.util.Enumeration;
import javax.vecmath.*;
import javax.media.j3d.BranchGroup;

/**
 * <p> </p>
 */
public class Monster extends Object implements pacman3d.message.MessageListener
{
  private MonsterControl control;
  private MonsterVoice voice;
  private MonsterAwareness awareness;
  private MonsterResponse response;
  private MonsterProperties property;

  /** Referenz auf den MonsterChannel */
  private static MonsterChannel channel;
  private ID id;
  private int ticks;


  /** Referenz auf den Message-Service zum Empfangen und Senden von Nachrichten */
  private static MessageService messageService;

  /**
   * erzeugt ein neues Monster
   */
  public Monster()
  {
  }

  /**
   * erzeugt ein neues Monster;
   * dieser Monster-Konstruktor erwartet statt der Startposition ein
   * MonsterProperties-Objekt.
   *
   * @param ids eine Monster-ID
   * @param monsterProperties die MonsterProperties
   * @param monsterChannel der MonsterChannel
   */
  public Monster(ID ids, MonsterProperties monsterProperties, MonsterChannel monsterChannel)
  {
     id = ids;
     channel = monsterChannel;
     property = monsterProperties;
     awareness = new MonsterAwareness(monsterProperties);
     // Start-Position in MonsterSetup schreiben
     Point3i monsterStartPosition = monsterProperties.getStartPosition();
     awareness.setMonsterStartPosition(monsterStartPosition);
     awareness.getSetup().setStrategy(monsterProperties.getMonsterStrategy());
     control = new MonsterControl(this, id, monsterStartPosition);
     voice = new MonsterVoice(channel, id, this);
     response = new MonsterResponse(this);

    // Message-Service holen
    messageService = MessageService.getInstance();
    messageService.addMessageListener(this);
  }

  /**
   * erzeugt ein neues Client-Monster;
   * dieser Konstruktor erzeugt die Client-Version des Monsters
   *
   * @param ids die Monster-ID
   * @param position die Startposition des Monsters
   * @param monsterChannel der MonsterChannel
   * @param server notwendig zur Unterscheidung der Konstruktoren
   */

  public Monster(ID ids, Point3i startPosition, MonsterChannel monsterChannel, boolean server)
  {
     id = ids;
     channel = monsterChannel;
     //awareness = new MonsterAwareness(monsterProperties);
     // Start-Position in MonsterSetup schreiben
     Point3i monsterStartPosition = startPosition;
     //awareness.setMonsterStartPosition(monsterStartPosition);
     control = new MonsterControl(this, id, monsterStartPosition);
     //voice = new MonsterVoice(channel, id, this);
     //response = new MonsterResponse(this);
  }
  /**
   * erzeugt ein neues Monster;
   * dieser Konstruktor des Monsters kapselt alle Module des Agentenmodells
   * und erwartet eine Startposition
   *
   * @param ids die Monster-ID
   * @param position die Startposition des Monsters
   * @param monsterChannel der MonsterChannel
   */
  public Monster(ID ids, Point3i position, MonsterChannel monsterChannel)
  {
    id = ids;
    channel = monsterChannel;
    awareness = new MonsterAwareness(this);
    control = new MonsterControl(this, id, position);

    voice = new MonsterVoice(channel, id, this);
    // response = new MonsterResponse(control, awareness, voice);
    // tp, 14.01.02:  Kann der Kommentar weg???
    response = new MonsterResponse(this);

    // Message-Service holen
    messageService = MessageService.getInstance();
    messageService.addMessageListener(this);

  }

  /**
   * Diese Methode wird zyklisch vom Game aufgerufen
   * und updated die Monsterpositionen und deren Handlungen
   *
   * @param deltaTicks duie vergangenen Ticks
   * @param pacmanIDs Array der PacmanIDs
   */
  public void update(int deltaTicks, ID[] pacmanIDs)
  {
    ticks = deltaTicks;

      if(awareness.getMyStateFromSetup() == true)
      {
        control.checkAllPacmanPositions(pacmanIDs);
      }

    response.whatAmIThinking(pacmanIDs);
    awareness.updateAwareness();
  }

  /**
   * die vergangenen Ticks werden zur Abfrage bereitgestellt
   *
   * @return die vergangenen Ticks
   */
  public int getTicks()
  {
    return ticks;
  }

  /**
   * die MonsterControl wird zur Abfrage bereitgestellt
   *
   * @return gibt die MonsterControl zurck
   */
  public MonsterControl getControl()
  {
    return control;
  }

  /**
   * die MonsterVoice wird zur Abfrage bereitgestellt
   *
   * @return gibt die MonsterVoice zurck
   */
  public MonsterVoice getVoice()
  {
    return voice;
  }

  /**
   * der MonsterChannel wird zur Abfrage bereitgestellt
   *
   * @return gibt den MonsterChannel zurck
   */
  public MonsterChannel getChannel()
  {
    return channel;
  }

  /**
   * die MonsterResponse wird zur Abfrage bereitgestellt
   *
   * @return gibt die MonsterResponse zurck
   */
  public MonsterResponse getResponse()
  {
    return response;
  }

  /**
   * die MonsterAwareness wird zur Abfrage bereitgestellt
   *
   * @return gibt die MonsterAwareness zurck
   */
  public MonsterAwareness getAwareness()
  {
    return awareness;
  }

  /**
   * die MonsterID wird zur Abfrage bereitgestellt
   *
   * @return gibt die MonsterID zurck
   */
  public ID getMonsterID()
  {
    return id;
  }

  /**
   * die View wird zur Abfrage bereitgestellt
   *
   * @return gibt die View zurck
   */
  public BranchGroup getView()
  {
    return control.getView();
  }


  /**
   * liefert das MonsterProperty-Objekt
   */
  public MonsterProperties getProperties()
  {
    return property;
  }

  /**
   * empfaengt eine Nachricht (vom Pacman) und wertet sie aus
   * (wenn es sich um die "die"-Nachricht handelt, setzt sich das
   * Monster beleidigt wieder auf seine Startposition - ohne ueber Los
   * zu gehen...)
   */
  public void getMessage(Message message)
  {
    if (message.getContent().equals("die"))
    {
    Integer monsterNumber = this.getChannel().getMonsterNumber(id);
     try
      {
        Message dieMessageForMasterChannel = new Message(id);
        dieMessageForMasterChannel.addReceiverGroup(1);
        dieMessageForMasterChannel.setContent(monsterNumber);
        messageService.sendMessage(dieMessageForMasterChannel);
      }
      catch (pacman3d.message.MissingMessageSenderException ex)
      {
        System.out.println("Fehler beim Senden der monsterNumber an Master-MonsterChannel...........");
      }
    }
  }

  /**
   * liefert die ID des Monsters
   *
   * @return ID      die ID dieses Monsters
   */
  public ID getID()
  {
    return id;
  }
}
