package pacman3d.message;

/**
 * <p>Title:     Praktikum Java3D und VRML </p>
 * Description:  <p>this class is just a container for the current
 *               score and number of lives to be shown in the score-panel</p>
 * Copyright:    Copyright (c) 2001<br>
 *
 * @author <a href="mailto:bergmann@cs.uni-frankfurt.de">Frank Bergmann </a>
 * @version 1.0
 *
 */

public class ScoreUpdateContent implements java.io.Serializable{

    /** current score of the pacman */
    private int m_nScore;
    /** current number of lives */
    private int m_nLives;
	/** current number of times killed */
	private int m_nTimesKilled;

    /** construtor initializing the values */
    public ScoreUpdateContent () {
        m_nScore=0;
        m_nLives=0;
    }
    /**
     * init ...
     * @param oScore the score of the pacman
     * @param oLives the number of lives of the pacman
	 * @param nTimesKilled the number of times this pacman was killed
     */
    public ScoreUpdateContent (Integer oScore, Integer oLives,int nTimesKilled) {
        m_nScore=oScore.intValue();
        m_nLives=oLives.intValue();
		m_nTimesKilled=nTimesKilled;
    }
    /**
     * get the score
     * @return the score
     */
    public int getScore() {
        return m_nScore;
    }
	/**
	 * return the number of times this pacman was killed
	 * @return number of times this pacman was killed
	 */
	public int getKillCount() {
		return m_nTimesKilled;
	}
    /**
     * get the number of lives left
     * @return the number of lives left
     */
    public int getLives() {
        return m_nLives;
    }
}