package pacman3d.message;

import pacman3d.pacman.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * Description:  <p>Ein Inhalt fr eine Nachricht, die die Anwesenheit eines
 *               neuen Spielers bekannt gibt</p>
 * Copyright:    Copyright (c) 2001-2002<br>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version $Version$ $Date: 2002/03/04 07:53:39 $<br/>
 */

public class PlayerLeftContent implements java.io.Serializable {

	/* die ID des Games, das diese Nachricht absetzt */
	private ID m_idGame = null;

	/* die ID des Subjekt-Pacmans auf dem Spiel, das diese Nachricht
	geschickt hat  */
	private ID m_idPacman = null;


	/**
	 * Konstruktor ohne Parameter fr das Erstellen einer leeren Instanz
	 */
	public PlayerLeftContent() {

	}

	/**
	 * Konstruktor nimmt die ID der Game-Instanz und des entsprechenden
	 * Subject-Pacmans auf
	 *
	 * @param idGame die ID des beschriebenen Games
	 * @param idPacman die ID des Pacman
	 */
	public PlayerLeftContent(ID idGame, ID idPacman ) {
		m_idGame = idGame;
		m_idPacman = idPacman;
	}

	/**
	 * setzt die Nachrichten-ID des beschriebenen Games auf den Parameterwert
	 * @param idGame die zu setzende Game-ID
	 */
	public void setID(ID idGame) {
		m_idGame = idGame;
	}

	/**
	 * liefert die Nachrichten-ID des beschriebenen Games zurck
	 * @return die ID des Games
	 */
	public ID getID() {
		return m_idGame;
	}

	/**
	 * setzt die Nachrichten-ID des Subjekt-Pacmans auf diesem Game
	 * @param idPacman die zu setzende Pacman-ID
	 */
	public void setPacmanID(ID idPacman) {
		m_idPacman = idPacman;
	}

	/**
	 * liefert die Nachrichten-ID des beschriebenen Pacmans zurck
	 * @return die ID des Pacman
	 */
	public ID getPacmanID() {
		return m_idPacman;
	}

}