package pacman3d.message;

import pacman3d.pacman.*;

import javax.media.j3d.*;
import javax.vecmath.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * Description:  <p>Eine Instanz dieser Klassen nimmt Daten, die fr die
 *               Instanzierung eines Pacman-Objekts ntig sind, auf</p>
 * Copyright:    Copyright (c) 2001-2002<br>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version $Version$ $Date: 2002/03/04 10:22:52 $<br/>
 */

public class PacmanSpawnedContent implements java.io.Serializable {

	/* die ID des Pacmans, der von diesem Content-Objekt beschrieben wird */
	private ID m_idPacman = null;

	Vector3d m_oLineOfSight = null;
	Point3i m_oPacmanPos = null;
	String m_sPacmanModel = null;
	boolean m_bIsFriendly = true;


	/**
	 * Konstruktor ohne Parameter fr das Erstellen einer leeren Instanz
	 */
	public PacmanSpawnedContent() {

	}

	/**
	 * Konstruktor nimmt die beschreibenden Parameter der Pacman-Instanz auf
	 *
	 * @param idPacman die ID des beschriebenen Pacmans
	 */
	public PacmanSpawnedContent(ID idPacman) {
		m_idPacman = idPacman;
	}

	/**
	 * Konstruktor nimmt eine Pacman-Instanz entgegen und holt sich von
	 * ihr die relevanten Werte fr den Nachrichtenversand
	 *
	 * @param oPacman der zu verschickende Pacman
	 */
	public PacmanSpawnedContent(Pacman oPacman) {
		m_idPacman = oPacman.getID();
		m_oLineOfSight = oPacman.getLineOfSight();
		m_oPacmanPos = oPacman.getPacmanPos();
		m_sPacmanModel = "";
		m_bIsFriendly = true;
	}

	/**
	 * Konstruktor nimmt eine Pacman-Instanz entgegen und holt sich von
	 * ihr die relevanten Werte fr den Nachrichtenversand. Zudem werden
	 * der Modellname und die Strategie mit gespeichert
	 *
	 * @param oPacman der zu verschickende Pacman
	 * @param sPacmanModel der Modellname
	 * @param isFriendly das Strategieflag
	 */
	public PacmanSpawnedContent(Pacman oPacman, String sPacmanModel, boolean bIsFriendly) {
		m_idPacman = oPacman.getID();
		m_oLineOfSight = oPacman.getLineOfSight();
		m_oPacmanPos = oPacman.getPacmanPos();
		m_sPacmanModel = sPacmanModel;
		m_bIsFriendly = bIsFriendly;
	}

	/**
	 * setzt die Nachrichten-ID des beschriebenen Pacmans auf den Parameterwert
	 * @param idPacman die zu setzende Pacman-ID
	 */
	public void setID(ID idPacman) {
		m_idPacman = idPacman;
	}

	/**
	 * liefert die Nachrichten-ID des beschriebenen Pacmans zurck
	 * @return die ID des Pacmans
	 */
	public ID getID() {
		return m_idPacman;
	}

	public Vector3d getLineOfSight() {
		return m_oLineOfSight;
	}

	public Point3i getPacmanPos() {
		return m_oPacmanPos;
	}

	public boolean isFriendly() {
		return m_bIsFriendly;
	}

	public String getPacmanModel() {
		return m_sPacmanModel;
	}

}