package pacman3d.message;

/**
 * Title:        Praktikum Java3D und VRML <br>
 * Description:  <p>this class will provide a basic MoveMent message it will tell
 *               the PacMan where to turn to, or where to move to </p>
 *               <p>the update was made to be able to make the pacman run.
 *               Of course it will still be compatible with the old version,
 *               but an update is recommended.</p>
 * Copyright:    Copyright (c) 2001<br>
 * last changed: 10.12.2001<br>
 * @author Frank Bergmann
 * @version 1.2
 *
 */

public class MovementMessage extends java.lang.Object implements java.io.Serializable {

	/** have to know when this message was sent*/
	private java.util.Date m_oMessageSent;
	/** how important is this message */
	private int m_nPriority;
	/** time to live */
	private int m_nTTL;
	/** what exactly should I do */
	private String m_sAction;
	/** where should I turn to ? */
	private String m_sDirection;
	/** boolean deciding whether pacman moves fast, or normal */
	private boolean m_bIsFast;

	/**  constructs a simple message that indicates a movement action */
	public MovementMessage(String sAction, String sDirection) {
		m_sAction=sAction;
		m_sDirection=sDirection;
		m_bIsFast=false;
	}
	public MovementMessage(String sAction, String sDirection,boolean bIsFast) {
		m_sAction=sAction;
		m_sDirection=sDirection;
		m_bIsFast=bIsFast;
	}
	/** returns the operation that should be executed. Examples for operations are:<br>
	 *  <ul>
	 *  <li><b>move</b> which will move PacMan or </li>
	 *  <li><b>rotate</b> which will rotate PacMan</li>
	 *  </ul>
	 */
	public String getAction () {
		return m_sAction;
	}
	/** returns direction to move/rotate to */
	public String getDirection () {
		return m_sDirection;
	}
	/** returns Priority of this Message */
	public int getPriority () {
		return m_nPriority;
	}
	/** returns time to live */
	public int getTTL () {
		return m_nTTL;
	}
	/** returns whether pacman runs or not */
	public boolean isFast () {
		return m_bIsFast;
	}
	/** returns the time at which this message was sent */
	public java.util.Date getSentDate () {
		return m_oMessageSent;
	}
	/** returns the content in a string */
	public String toString() {
		return "[action: " + m_sAction + ", direction: " + m_sDirection + "]";
	}

}