package pacman3d.message;

/**
 */
public class MonsterMessage implements java.io.Serializable
{
  private ID receiverID = null;
  private String messageText = null;

  /**
   * Erzeugt ein neues MonsterMessage-Objekt, das verwendet werden kann, um
   * einem Monster eine Nachricht zukommen zu lassen. Die Kommunikation mit
   * den einzelnen Monstern ist ueber den MonsterChannel gekapselt, d. h. die
   * Nachricht wird nicht direkt an das Monster geschickt, sondern an MonsterChannel,
   * der die Nachricht weiterleitet.
   *
   * @param receiverMonster   die ID des Monsters, an das die Nachricht geschickt
   *                          werden soll
   * @param messageText       der zu verschickende String
   **/
  public MonsterMessage(ID receiverMonster, String messageText)
  {
    this.receiverID = receiverMonster;
    this.messageText = messageText;
  }

  /**
   * liefert die ID des Monsters, fuer das die Nachricht bestimmt ist
   *
   * @return receiverID         ID des Empfaenger-Monsters
   */
  public ID getReceiverID()
  {
    return receiverID;
  }

  /**
   * liefert den Text der Nachricht
   *
   * @return messageText        Text der zu sendenden Nachricht
   */
  public String getMessageText()
  {
    return messageText;
  }


}