package pacman3d.message;

import java.util.Vector;

import javax.media.j3d.*;
import javax.vecmath.*;

import pacman3d.labyrinth.cells.Cell;
import pacman3d.labyrinth.items.Item;
import pacman3d.util.ItemHandler;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * Description:  <p>Ein Inhalt fr Nachricht, die Informationen ber ein Item
 *               aufnimmt und diese an andere Spieler verschickt</p>
 * Copyright:    Copyright (c) 2001-2002<br>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version $Version$ $Date: 2002/02/25 10:01:45 $<br/>
 */

public class ItemInfoContent implements java.io.Serializable {

	/* die Position der Zelle, in der die Items der Nachricht sitzen
	bzw. sitzen sollen  */
	private Point3i m_p3iCellPos = null;

	/* Flag, ob Item aufnehmbar ist */
	private boolean m_bTakable = false;

	/* Flag, ob Item sichtbar ist */
	private boolean m_bVisible = false;

	/* die Nachrichten-ID des beschriebenen Items */
	private ID m_idItem = null;

	/* der Typname beschriebenen Items im ItemHandler des aktuellen Levels */
	private String m_sItemName = null;



	/**
	 * Konstruktor nimmt die Position der Zelle und ihre Items entgegen, um
	 * daraus eine kompakte Nachricht fr den Versand zu generieren
	 *
	 * @param idGame die ID des beschriebenen Games
	 */
	public ItemInfoContent(Point3i p3iCellPos, Item oItem) {

		m_p3iCellPos = p3iCellPos;

		// Informationen aus Vector herausziehen
		m_bTakable = oItem.isTakable();
		m_bVisible = oItem.isVisible();
		m_idItem = oItem.getID();
		ItemHandler oItemHandler = ItemHandler.getInstance();
		m_sItemName = oItemHandler.getItemName (oItem);

	}

	/**
	 * liefert die Position der Zelle, in der sich die beschriebenen
	 * Items befinden
	 * @return die Koordinaten der Zelle
	 */
	public Point3i getCellPos() {
		return m_p3iCellPos;
	}

	/**
	 * liefert zurck, ob das Sichtbarkeitsflag gesetzt ist
	 * @return der Wert des Sichtbarkeitsflags
	 */
	public boolean isVisible() {
		return m_bVisible;
	}

	/**
	 * liefert zurck, ob das beschriebene Item aufgenommen werden kann
	 * @return der Wert des Aufnehmbarkeitsflags
	 */
	public boolean isTakable() {
		return m_bTakable;
	}

	/**
	 * liefert die Nachrichten-ID des beschriebenen Items zurck
	 * @return die ID des Items
	 */
	public ID getID() {
		return m_idItem;
	}

	/**
	 * liefert den Typnamen des Items aus dem Itemhandler zurck
	 * @return der Name des Items, wie er im Itemhandler aufgefhrt ist
	 */
	public String getItemName() {
		return m_sItemName;
	}

}