package pacman3d.message;
import pacman3d.labyrinth.items.*;

/**
 * <p>Title:     Praktikum Java3D und VRML </p>
 * Description:  <p>this class is just a container for the current
 *               selected Item along with the number of items in inventory</p>
 * Copyright:    Copyright (c) 2001<br>
 *
 * @author <a href="mailto:bergmann@cs.uni-frankfurt.de">Frank Bergmann </a>
 * @version 1.0
 *
 */


public class InventoryUpdatedContent implements java.io.Serializable {

    /** the currently selected item */
    Item m_oSelectedItem;
    /** position of the currently selected item */
    int m_nPos;
    /** the number of all Items in stock */
    int m_nMax;

    /** default constructor just to be sureeverything is initialized */
    public InventoryUpdatedContent() {
        m_oSelectedItem=null;
        m_nPos=0;
        m_nMax=0;
    }
    /** constructor needed by pacman
     *
     * @param oCurrentItem currently selected item
     * @param nPos position of that item
     * @param nMax number of all items
     */
    public InventoryUpdatedContent(Item oCurrentItem, int nPos, int nMax) {
        m_oSelectedItem=oCurrentItem;
        m_nPos=nPos;
        m_nMax=nMax;
    }
    /**
     *
     * @return position of selected item
     */
    public int getPosition() {
        return m_nPos;
    }
    /**
     *
     * @return the number of all items in stock
     */
    public int getMaximum(){
        return m_nMax;
    }
    /**
     *
     * @return the currently selected item
     */
    public Item getSelectedItem() {
        return m_oSelectedItem;
    }
}