package pacman3d.message;

/**
 * <b>Title:</b>      	Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * Repraesentiert einen eindrutigen Bezeichner fuer ein
 * &quot;Monster&quot;, einen &quot;Pacman&quot;, oder ein anderes Subjekt des
 * Spiels.<br>
 *
 * <b>Copyright:</b>	Copyright (c) 2001<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             26.11.2001<br>
 */
public class ID extends java.lang.Object implements java.io.Serializable {

        /**
         * Eigentlicher "Wert" dieser ID. Der genaue Wertetyp ist allerdings
         * nur fuer private Methoden dieser Klasse von Bedeutung, externe
         * Module sollten mit dem Typ dieser Variablen nie (!) in
         * Beruehrung kommen!
         */
        private String m_sId;

        /**
         * Ein Hashwert ber den internen Wert dieser ID. Er kann z.B.
         * fr performante Vergleiche herangezogen werden!
         */
        private int m_iIdHashCode;

        /**
         * Konstruktor, erzeugt eine neue ID.
         */
        public ID() {
                this.m_sId = new java.rmi.server.UID().toString();
                this.m_iIdHashCode = m_sId.hashCode();
        }

        /**
         * Liefert <code>true</code> zurueck, wenn die Id mit der
         * gegebenen ID (<code>oId</code>) uebereinstimmt, anderenfalls
         * <code>false</code>.
         */
        public boolean equals( ID oId ) {
                return (m_iIdHashCode == oId.hashCode());
        }

        /**
         * Liefert <code>true</code> zurueck, wenn die Id mit dem
         * gegebenen Objekt (<code>oObject</code>) uebereinstimmt, anderenfalls
         * <code>false</code>. Es kann ein Objekt beliebiger Klasse uebergeben
         * werden.
         */
        public boolean equals( Object oObject ) {
                if (oObject instanceof ID) {
                        return this.equals( (ID) oObject );
                } else {
                        return false;
                }
        }

        /**
         * Liefert einen Hash-Wert fuer die ID zurueck. Achtung: dieser Wert
         * ist nur mit hoher Wahrscheinlichkeit, also nicht mit absoluter
         * Sicherheit eindeutig fuer diese ID! (Eben ein Hash-Wert... ;-))
         */
        public int hashCode() {
                return m_iIdHashCode;
        }

        /**
         * Liefert eine String-Repraesentation der aktuellen ID zurueck, kann
         * z.B. fuer Testzwecke benutzt werden, um verschiedene IDs optisch
         * voneinander zu unterscheiden.
         */
        public String toString() {
                return m_sId;
        }
}