package pacman3d.message;

/**
 * <h1>FallingContent</h1>
 *
 * <p>There'll be a change in the way pacman will handle movement-messages soon.
 * So far every message that arrives will be executed according to the FIFO
 * model.</p>
 * <p>But now this model will be overthrown 'cause it is thought that this model
 * won't support the "real-time" idea. (If someone would know the layout of the
 * labyrinth it would be possible to enter all the messages at the begin of the
 * game and then just watch). So only the latest movement operation will be
 * allowed. Nonetheless pacman should still fall down, so i came up with the idea
 * of writing this class. A message with this content won't be thrown out of the
 * MessageQueue.</p>
 *
 * @author <a href="mailto:bergmann@cs.uni-frankfurt.de">Frank Bergmann </a>
 * @version 1.0
 */

public class FallingContent implements java.io.Serializable{

	/** Message containing the falling parameter */
	private MovementMessage m_oMove = null;

	/** the constructor initializing this content
	 *  @param oMove the movement message containing the direction to fall to
	 */
    public FallingContent(MovementMessage oMove) {
		m_oMove = oMove;
    }
	/** return the move
	 * @return the movement message containing the falling information
	 */
	public MovementMessage getMove() {
		return m_oMove;
	}
}