package pacman3d.labyrinth.leveleditor;

import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.*;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse implementiert das Interface {@link java.io.FilenameFilter
 * FilenameFilter} und wird von der Klasse {@link
 * pacman3d.labyrinth.leveleditor.TextureSelectionJPanel TextureSelectionJPanel}
 * verwendet, um eingelesene Dateien als Verzeichnis oder als JPEG- oder
 * GIF-Datei zu identifizieren.<p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class MyFileFilter implements FilenameFilter {
  /**
   * {@link java.lang.String String-Konstante}, die dem Konstruktor bergeben
   * werden mu, falls die Methode {@link #accept} nur bei Verzeichnissen
   * <b>true</b> zurckliefern soll.
   *
   * @see #GIF_AND_JPEG
   */
  public final static String DIR  = "dir";

  /**
   * {@link java.lang.String String-Konstante}, die dem Konstruktor bergeben
   * werden mu, falls die Methode {@link #accept} nur bei Grafikdatein vom
   * Typ JPG bzw. JPEG und GIF <b>true</b> zurckliefern soll.
   *
   * @see #DIR
   */
  public final static String GIF_AND_JPEG = "gif and jpeg";

  /**
   * {@link java.lang.String String-Feld}, welches entweder den Wert des Feldes
   * {@link #DIR} oder {@link #GIF_AND_JPEG} trgt und somit angibt, welche
   * Dateitypen bei Aufruf der Methode {@link #accept} <b>true</b> zurckliefern.
   */
  private String fileTyp = null;

  /**
   * Konstruktor:<p>
   *
   * Um den durch diese Klasse implementierten FilenameFilter zu verwenden, ist
   * diese Klasse durch Aufruf dieses Konstruktors mit bergabe der
   * String-Konstanten {@link #DIR} oder {@link #GIF_AND_JPEG} fr den Parameter
   * <b>fileTyp</b> zu instantiieren.
   *
   * @param fileTyp {@link #DIR} oder {@link #GIF_AND_JPEG}.
   */
  public MyFileFilter(String fileTyp) {
    this.fileTyp = fileTyp;
  }

  /**
   * Wurde diese Klasse mit der String-Konstanten {@link #DIR} instantiiert, so
   * liefert diese Methode fr die bergebene Datei <b>filename</b> im
   * Verzeichnis <b>f</b> genau dann <b>true</b> zurck, falls es sich bei
   * <b>filename</b> ebenfalls um ein Verezeichnis handelt und bei Instantiierung
   * mittels der String-Konstanten {@link #GIF_AND_JPEG} genau dann <b>true</b>,
   * falls es sich bei der Datei <b>filename</b> um eine Datei mit der Endung
   * <code>jpg</code>, <code>jpeg</code> oder <code>gif</code> handelt.
   *
   * @param f         Verzeichnis, in dem die zu berprfende Datei
   *                  <b>filename</b> liegt.
   * @param filename  Zu berprfende Datei.
   *
   * @return          Siehe Methodenbeschreibung.
   */
  public boolean accept(File f, String filename) {
    f = new File(f, filename);

    if (fileTyp.equals(DIR)) {
      if (f.isDirectory()) {
        return true;
      }
    }
    else if (fileTyp.equals(GIF_AND_JPEG)){
      String extension = getExtension(f);
      if (extension != null) {
        if (extension.equals("gif") ||
          extension.equals("jpeg") ||
          extension.equals("jpg")) {
          return true;
        }
        else {
          return false;
        }
      }
    }
    return false;
  }

    // The description of this filter
  /*
  public String getDescription() {
    if (fileTyp.equals(DIR))
      return "directories";
    else if (fileTyp.equals(GIF_AND_JPEG))
      return "gif and jpeg";

    return null;
  }
*/
  /**
   * Diese Hilfsmethode liefert denjenigen Teil des Dateinamens der bergebenen
   * Datei <b>f</b>, welcher nach dem zuletzt vorkommenden Punkt "." im
   * Dateinamen steht, also die Dateiendung.
   *
   * @param f Datei, dessen Dateiendung bestimmt werden soll.
   *
   * @return Dateiendung der Datei <b>f</b>
   */
  protected static String getExtension(File f) {
    String ext = null;
    String s = f.getName();
    int i = s.lastIndexOf('.');

    if (i > 0 &&  i < s.length() - 1) {
      ext = s.substring(i+1).toLowerCase();
    }
    return ext;
  }
}
