package pacman3d.labyrinth.leveleditor;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import javax.swing.border.*;
import javax.swing.colorchooser.*;
import javax.swing.filechooser.*;
import javax.accessibility.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
import java.io.*;
import java.applet.*;
import java.net.*;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse ist eine Subklasse von {@link javax.swing.JPanel JPanel} und
 * kann als solche GUI-Komponente verwendet werden.<br>
 * Diese Subklasse ist um solche Funktionalitt erweitert, so da durch sie
 * eine in HTML geschriebene Hilfeseite angezeigt und in dieser navigiert werden
 * kann.<p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class LeveleditorHelpJPanel extends JPanel {
  /**
   * Instanz der Klasse {@link javax.swing.JEditorPane JEditorPane}, welche
   * dazu verwendet wird, um die in HTML geschriebene Hilfeseite anzuzeigen.
   */
  protected JEditorPane html;

  /**
   * Instanz der Klasse {@link java.lang.String String}, mit der absoluten
   * Pfandangabe zu der in HTML geschriebenen Hilfeseite.
   */
  protected String path = "/pacman3d/labyrinth/leveleditor/help/leveleditorhelpfile.html";

  /**
   * Konstruktor:<p>
   *
   * Initialisierung dieser Komponente.
   */
  public LeveleditorHelpJPanel() {
    guiInit();
  }

  /**
   * Initialisierung diverser GUI-Einstellungen dieser Komponente. Diese Methode
   * wird automatisch vom Konstruktor dieser Klasse aufgerufen und sollte somit nicht
   * von Interesse fr den Endanwender sein.
   *
   * @see #LeveleditorHelpJPanel()
   */
  protected void guiInit() {
    this.setLayout(new BorderLayout());
    URL url = null;
    try {
      try {
        url = getClass().getResource(path);
      }
      catch (Exception e) {
        pacman3d.util.Debug.out(this.getClass().getName(), "Failed to open " + path);
        url = null;
      }

      if(url != null) {
          html = new JEditorPane(url);
          html.setEditable(false);
          html.addHyperlinkListener(createHyperLinkListener());

          JScrollPane scroller = new JScrollPane();
          JViewport vp = scroller.getViewport();
          vp.add(html);
          this.add(scroller, BorderLayout.CENTER);
      }
    }
    catch (MalformedURLException e) {
      pacman3d.util.Debug.out(this.getClass().getName(), "Malformed URL: " + e);
    }
    catch (IOException e) {
      pacman3d.util.Debug.out(this.getClass().getName(), "IOException: " + e);
    }
  }

  /**
   * Hilfsmethode, die einen {@link javax.swing.event.HyperlinkListener Hyperlinklistener}
   * instantiiert und zurckliefert. Dieser wird dazu verwendet, um innerhalb des
   * durch diese Komponente dargestellten Helpfiles zu navigieren.
   *
   * @return Instanz der Klasse {@link javax.swing.event.HyperlinkListener HyperlinkListener}.
   */
  private HyperlinkListener createHyperLinkListener() {
    return new HyperlinkListener() {
      public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
          if (e instanceof HTMLFrameHyperlinkEvent) {
            ((HTMLDocument)html.getDocument()).processHTMLFrameHyperlinkEvent(
            (HTMLFrameHyperlinkEvent)e);
          }
          else {
            try {
              html.setPage(e.getURL());
            }
            catch (IOException ioe) {
              pacman3d.util.Debug.out(this.getClass().getName(), "IOE: " + ioe);
            }
          }
        }
      }
    };
  }
}


