package pacman3d.labyrinth.leveleditor;

import pacman3d.labyrinth.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.plaf.*;
import javax.swing.filechooser.*;
import java.io.*;
import javax.media.j3d.*;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.*;
import java.net.*;
import pacman3d.util.*;
import pacman3d.pacman.*;
import pacman3d.monster.*;
import pacman3d.message.*;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse ist sozusagen die "Hauptklasse" des Leveleditors, da durch
 * diese Klasse das Zusammenspiel aller dem Leveleditor zugehrigen Klassen
 * erfolgt. So erzeugt diese Klasse die verschiedenen Fenster des Leveleditors
 * und kmmert sich um die korrekte Initialisierung der vom Leveleditor
 * verwendeten Klassen und der Kommunikation zwischen diesen.<p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class Leveleditor implements java.awt.event.ActionListener {
  /**
   * Verzeichnis, in welchem sich die vom Benutzer zuletzt geffnete Labyrinthdatei
   * befindet oder zu Begin, falls noch keine Labyrinthdatei geffnet wurde, dasjenige
   * Verzeichnis, von welchem aus der Leveleditor z.B. mit java oder javaw aufgerufen
   * wurde. Diese Information wird dazu verwendet, da der OpenDialog immer bei Aufruf
   * das zuletzt vom Benutzer geffnete Verzeichnis als Ausgangspunkt verwendet.
   *
   * @see #saveDir
   */
  protected String openDir = System.getProperty("user.dir");

  /**
   * Verzeichnis, in welchem sich die vom Benutzer zuletzt abgespeicherte Labyrinthdatei
   * befindet oder zu Begin, falls noch keine Labyrinthdatei gespeichert wurde, dasjenige
   * Verzeichnis, von welchem aus der Leveleditor z.B. mit java oder javaw aufgerufen
   * wurde. Diese Information wird dazu verwendet, da der SaveDialog immer bei Aufruf
   * das zuletzt vom Benutzer geffnete Verzeichnis als Ausgangspunkt verwendet.
   *
   * @see #saveDir
   */
  protected String saveDir = System.getProperty("user.dir");

  /**
   * Dateiname der vom Benutzer zuletzt abgespeicherten Labyrinthdatei.
   */
  protected String fileName = null;

  /**
   * Referenz auf Instanz der Klasse <b>JToolBarLeveleditor</b>, welche die
   * Toolbar des Leveleditors darstellt.
   *
   * @see pacman3d.labyrinth.leveleditor.JToolBarLeveleditor
   */
  protected JToolBarLeveleditor jToolBarLeveleditor;

  /**
   * Verzeichnis, in welchem sich die verwendeten Texturen befinden.
   */
  protected static File imageSourceFile = new File("media/textures/");;

  /**
   * ImageIcon, welches das ImageIcons des Leveleditor-Hauptfensters und
   * diverser JInternalFrames ersetzt
   */
  protected static ImageIcon imageIcon;
  // Statischer Initialisierer des ImageIcons
  static {
    URL url = ClassLoader.getSystemResource("pacman3d/labyrinth/leveleditor/images/dukeWaveRed.gif");

    // ImageIcon laden
    if (url != null)
      imageIcon = new ImageIcon(url);
  }

  /**
   * URL mit demjenigen Verzeichnis, in welchem sich diverse vom Leveleditor
   * bentigte Bilder befinden, die z.B. in der Toolbar des Leveleditors verwendet
   * werden.
   */
  protected static URL url = null;
  // Statischer Initialisierer
  static {
    url = ClassLoader.getSystemResource("pacman3d/labyrinth/leveleditor/images/");
  }

  //
  // Referenzen auf die einzelnen JPanel fr diverse Einstellmglichkeiten
  //
  /**
   * Referenz auf Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.LevelMetaInfoJPanel LevelMetaInfoJPanel},
   * welche diejenigen GUI-Komponenten zur Verfgung stellt, um die Felder der Klasse
   * {@link pacman3d.util.LevelMetaInfo LevelMetaInfo} zu bearbeiten.
   *
   * @see pacman3d.labyrinth.leveleditor.LevelMetaInfoJPanel
   * @see pacman3d.util.LevelMetaInfo
   */
  protected LevelMetaInfoJPanel levelMetaInfoJPanel;

  /**
   * Referenz auf Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel LevelEditingJPanel},
   * welche das zu bearbeitende Labyrinth auf dem Bildschirm graphisch darstellt
   * und diverse Editiermglichkeiten bietet.
   *
   * @see pacman3d.labyrinth.leveleditor.LevelEditingJPanel
   */
  protected LevelEditingJPanel levelEditingJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.TextureSelectionJPanel TextureSelectionJPanel},
   * welche die Mglichkeit zur Textur- und Farbauswahl bietet.
   *
   * @see pacman3d.labyrinth.leveleditor.TextureSelectionJPanel
   */
  protected TextureSelectionJPanel textureSelectionPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.ItemJPanel ItemJPanel}, welche
   * die Mglichkeit zur Auswahl und Editierung diverse <b>Items</b>, d.h.
   * Instanzen und Subklassen der Klase {@link pacman3d.labyrinth.items.Item Item},
   * bietet.
   *
   * @see pacman3d.labyrinth.leveleditor.ItemJPanel
   * @see pacman3d.labyrinth.items.Item
   */
  protected ItemJPanel itemJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.PacmanJPanel PacmanJPanel}, welche
   * die Mglichkeit zur Auswahl und Editierung diverser <b>Pacmen</b>, d.h.
   * Instanzen der Klasse {@link pacman3d.pacman.Pacman Pacman}, bietet.<br>
   * Aktuell wird davon kein Gebrauch gemacht.
   *
   * @see pacman3d.labyrinth.leveleditor.ItemJPanel
   * @see pacman3d.labyrinth.items.Item
   */
  protected PacmanJPanel pacmanJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.CellsJPanel CellsJPanel}, welche
   * die Mglichkeit zur Auswahl und Editierung diverser <b>Zellentypen</b>, d.h.
   * Instanzen und Subklassen der Klasse {@link pacman3d.labyrinth.cells.Cell Cell},
   * bietet.<br>
   *
   * @see pacman3d.labyrinth.leveleditor.CellsJPanel
   * @see pacman3d.labyrinth.cells.Cell
   */
  protected CellsJPanel cellsJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.MonsterJPanel MonsterJPanel}, welche
   * zur Auswahl diverser Monstertypen und deren Einstellung verwendet wird.<br>
   * Die Klasse {@link pacman3d.labyrinth.leveleditor.MonsterJPanel MonsterJPanel} ist zwar vorhanden,
   * stellt am aktuell noch keine Funktionalitt zur Verfgung.
   *
   * @see pacman3d.labyrinth.leveleditor.MonsterJPanel
   */
  protected MonsterJPanel monsterJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.LeveleditorHelpJPanel LeveleditorHelpJPanel},
   * welche diejenigen Komponenten zur Verfgung stellt, um eine in HTML geschriebene
   * Hilfe-Seite anzuzeigen.
   *
   * @see pacman3d.labyrinth.leveleditor.LeveleditorHelpJPanel
   */
  protected LeveleditorHelpJPanel help = null;


  protected JTabbedPane tabbedPane2;

  //
  // Die diversen Frames bzw. InternalFrames des Leveleditors
  //

  /**
   * Haupfenster des Leveleditors.
   */
  protected JFrame mainEditorFrame;

  /**
   * {@link javax.swing.JInternalFrame JInternalFrame}, welche die durch das Feld
   * {@link #levelEditingJPanel} referenzierte Instanz als GUI-Komponente enthlt,
   * welche allerdings in ein {@link javax.swing.JScrollPane JScrollPane} eingebettet
   * ist.
   *
   * @see #levelEditingJPanel
   * @see #jScrollPane
   */
  protected JInternalFrame levelEditingInternalFrame;

  /**
   * {@link javax.swing.JScrollPane JScrollPane}, welche die durch das Feld
   * {@link #levelEditingJPanel} referenzierte Instanz als GUI-Komponente enthlt.
   *
   * @see #levelEditingJPanel
   * @see #levelEditingInternalFrame
   * @see javax.swing.JScrollPane
   */
  protected JScrollPane jScrollPane;

  // JInternalFrame fr die Textur-Auswahl
  protected JInternalFrame textureInternalFrame;

  /**
   * Instanz der Klasse {@link
   * pacman3d.labyrinth.leveleditor.ColorChooser2DComponents} zur Auswahl der
   * Farben diverser darstellender Elemente auf dem 2D-Leveleditierungsbereich.
   *
   * @see pacman3d.labyrinth.leveleditor.ColorChooser2DComponents
   * @see javax.swing.JInternalFrame
   */
  protected ColorChooser2DComponents colorChooser2DComponentsInternalFrame;

  /**
   * {@link javax.swing.JInternalFrame JInternalFrame}, welche die durch das Feld
   * {@link #levelMetaInfoJPanel} referenzierte Instanz der Klasse
   * {@link pacman3d.labyrinth.leveleditor.LevelMetaInfoJPanel} enthlt und
   * als GUI-Komponente darstellt.
   *
   * @see #levelMetaInfoJPanel
   * @see pacman3d.labyrinth.leveleditor.LevelMetaInfoJPanel
   * @see javax.swing.JInternalFrame
   */
  protected JInternalFrame levelMetaInfoInternalFrame;

  /**
   * {@link javax.swing.JInternalFrame JInternalFrame}, welches die GUI-Komponenten
   * der Felder {@link #cellsJPanel}, {@link #itemJPanel}, {@link #pacmanJPanel}
   * und {@link #monsterJPanel} zur Auswahl des zu setzenden Zellentyps,
   * Itemtyps, Monster und Pacman enthlt und auf dem Bildschirm darstellt.
   *
   * @see #cellsJPanel
   * @see #itemJPanel
   * @see #pacmanJPanel
   * @see #monsterJPanel
   * @see javax.swing.JInternalFrame
   */
  protected JInternalFrame cellsAndItemsInternalFrame;

  /**
   * {@link javax.swing.JInternalFrame JInternalFrame}, welche eine Instanz der
   * Klasse {@link pacman3d.labyrinth.leveleditor.LeveleditorHelpJPanel
   * LeveleditorHelpJPanel} enthlt und als GUI-Komponente darstellt.
   *
   * @see pacman3d.labyrinth.leveleditor.LeveleditorHelpJPanel
   * @see javax.swing.JInternalFrame
   */
  protected JInternalFrame helpInternalFrame;

  /**
   * Instanz der Klasse {@link javax.swing.JDesktopPane}, welche dem {@link #mainEditorFrame
   * Hauptfenster} des Leveleditors hinzugefgt wird, um mit diversen {@link javax.swing.JInternalFrame
   * JInternalFrames} arbeiten zu knnen.
   *
   * @see #mainEditorFrame
   * @see javax.swing.JDesktopPane
   * @see javax.swing.JInternalFrame
   */
  protected JDesktopPane jDesktopPane;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.LevelSizeDialog},
   * welche dazu verwendet wird, um vom Benutzer abzufragen, wie die Abmessungen
   * eines neu zu erzeugenden Labyrinths sein sollen.
   *
   * @see pacman3d.labyrinth.leveleditor.LevelSizeDialog
   */
  protected LevelSizeDialog levelSizeDialog;

  /**
   * Referenz auf Instanz der Klasse {@link pacman3d.labyrinth.Labyrinth}, welche
   * die Hauptklasse des spter im eigentlichen Spiel dargestellten Labyrinthes
   * darstellt. Diese Klasse wird durch den Leveleditor verwendet und editiert.
   *
   * @see pacman3d.labyrinth.Labyrinth
   */
  protected Labyrinth lab;

  // Texturen
  //protected Texture[][] texs;

  /**
   * Instanz der Klasse {@link java.awt.Dimension}, welche die Gre des
   * {@link #mainEditorFrame Hauptfensters des Leveleditors} angibt.
   *
   * @see #mainEditorFrame
   * @see java.awt.Dimension
   */
  protected Dimension dimension = new Dimension(1024, 768);

  /**
   * Konstruktor:<p>
   *
   * Um den Leveleditor zu verwenden, ist diese Klasse nur durch Aufruf dieses
   * parameterlosen Konstruktors zu initialisieren. Hierbei ist aber zu beachten,
   * da sich das Verzeichnis <b>media/textures/</b> innerhalb des Classpath von
   * Java befindet.
   */
  public Leveleditor() {
    // Klasse zur Textur/Farbauswahl initialisieren, da diese einige Zeit bentigt,
    // um alle vorhandenen Texturen einzulesen und darzustellen.
    textureSelectionPanel = new TextureSelectionJPanel(this);

    // GUI initialisieren.
    guiInit();
  }

  /**
   * Die durch das von dieser Klasse implementierte Interface {@link java.awt.event.ActionListener}
   * geforderte Methode, um auf {@link java.awt.event.ActionEvent ActionEvents} reagieren
   * und somit diverse Interaktion mit dem Benutzer des Leveleditors realisieren
   * zu knnen.
   *
   * @param actionEvent {@link java.awt.event.ActionEvent}
   *
   * @see java.awt.event.ActionListener
   */
  public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
    /*
     * Speichern
     */
    if ((actionEvent.getActionCommand().equals("Labyrinth speichern") ||
         actionEvent.getActionCommand().equals("save as") )
        &&
        lab != null) {

      // Nur Speichern, falls mindestens eine Pacmanstartposition und mindestens
      // ein Monster dem Labyrinth hinzugefgt wurde, denn anderenfalls ist ein
      // Speichern des editierten Labyrinthes nicht mglich. Ist dies nicht der
      // Fall, so weien wir den Benutzer durch einen entsprechenden Dialog daraufhin,
      // da er evtl. noch eine Pacmanstartposition bzw. ein Monster bzw. beides
      // zu setzen hat.
      if ((lab.getAllPacmanStartPositions() == null && lab.getAllMonsterStartPositions() == null) ||
          (lab.getAllPacmanStartPositions() != null && lab.getAllPacmanStartPositions().size() < 1 && lab.getAllMonsterStartPositions() == null) ||
          (lab.getAllMonsterStartPositions() != null && lab.getAllMonsterStartPositions().size() < 1 && lab.getAllPacmanStartPositions() == null) ||
          (lab.getAllPacmanStartPositions() != null && lab.getAllPacmanStartPositions().size() < 1 &&
           lab.getAllMonsterStartPositions() != null && lab.getAllMonsterStartPositions().size() < 1)) {
        JOptionPane.showMessageDialog(this.mainEditorFrame, "Sie mssen mindestens eine Monster- und Pacmanstartposition gesetzt haben!",
                                                            "Speichern nicht mglich",
                                                            JOptionPane.WARNING_MESSAGE);
        return;
      }
      if (lab.getAllMonsterStartPositions() == null || lab.getAllMonsterStartPositions().size() < 1) {
          JOptionPane.showMessageDialog(this.mainEditorFrame, "Sie mssen mindestens eine Monsterstartposition gesetzt haben!",
                                                              "Speichern nicht mglich",
                                                              JOptionPane.WARNING_MESSAGE);
        return;
      }
      if (lab.getAllPacmanStartPositions() == null || lab.getAllPacmanStartPositions().size() < 1) {
          JOptionPane.showMessageDialog(this.mainEditorFrame, "Sie mssen mindestens eine Pacmanstartposition gesetzt haben!",
                                                              "Speichern nicht mglich",
                                                              JOptionPane.WARNING_MESSAGE);
        return;
      }

      // Speichern (ohne FileDialog; mit FileDialog -> Speichern unter...)
      if (fileName != null && actionEvent.getActionCommand().equals("Labyrinth speichern")) {
        // LevelMetaInfo-Instanz evtl. aktualisieren oder neu anlegen
        try {
          pacman3d.util.LevelMetaInfo levelMetaInfo = lab.getLevelMetaInfo();
          if (levelMetaInfo != null)
            levelMetaInfoJPanel.getLevelMetaInfo(levelMetaInfo);
          else {
          levelMetaInfo = levelMetaInfoJPanel.getLevelMetaInfo();
          lab.setLevelMetaInfo(levelMetaInfo);
          }
          // Labyrinth speichern
          lab.saveLevel(fileName);
          //levelEditingInternalFrame.setTitle(chooser.getSelectedFile().getName());
        }
        catch (Exception exception) {
          Debug.out(this.getClass().getName(), exception);
        }
      }
      // "Speichern unter"
      else {
        /*
        if ( (lab.getAllPacmanStartPositions() == null && lab.getAllMonsterStartPositions() == null) ||
             (lab.getAllPacmanStartPositions() != null && lab.getAllPacmanStartPositions().size() < 1 && lab.getAllMonsterStartPositions() == null) ||
             (lab.getAllMonsterStartPositions() != null && lab.getAllMonsterStartPositions().size() < 1 && lab.getAllPacmanStartPositions() == null) ||
             (lab.getAllPacmanStartPositions() != null && lab.getAllPacmanStartPositions().size() < 1 &&
              lab.getAllMonsterStartPositions() != null && lab.getAllMonsterStartPositions().size() < 1)) {
          JOptionPane.showMessageDialog(this.mainEditorFrame, "Sie mssen mindestens eine Monster- und Pacmanstartposition gesetzt haben!",
                                                              "Speichern nicht mglich",
                                        JOptionPane.WARNING_MESSAGE);
          return;
        }
        if (lab.getAllMonsterStartPositions() == null || lab.getAllMonsterStartPositions().size() < 1) {
          JOptionPane.showMessageDialog(this.mainEditorFrame, "Sie mssen mindestens eine Monsterstartposition gesetzt haben!",
                                                              "Speichern nicht mglich",
                                        JOptionPane.WARNING_MESSAGE);
          return;
        }
        if (lab.getAllPacmanStartPositions() == null || lab.getAllPacmanStartPositions().size() < 1) {
          JOptionPane.showMessageDialog(this.mainEditorFrame, "Sie mssen mindestens eine Pacmanstartposition gesetzt haben!",
                                                              "Speichern nicht mglich",
                                        JOptionPane.WARNING_MESSAGE);
          return;
        }
        */

        // Filechooser zur Abfrage des Levelnamens und des Vereichnisses, in welchem
        // das zu speichernde Labyrinth abgelegt werden soll:
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Speichern unter");

        // Filefilter, damit nur Files mit der Endung "xml" angenommen bzw. angezeigt
        // werden.
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("xml");
        filter.setDescription("xml");
        filter.addExtension("p3d");
        filter.setDescription("p3d");
        chooser.setFileFilter(filter);

        chooser.setCurrentDirectory(new File(this.saveDir));

        // Exit-Wert des FileChooser bestimmen:
        int returnVal = chooser.showSaveDialog(this.mainEditorFrame);
        // Nur Speichern, wenn dies auch vom Benutzer erwnscht ist:
        if(returnVal == JFileChooser.APPROVE_OPTION) {
          this.saveDir = chooser.getSelectedFile().getParent();
          // LevelMetaInfo evtl. aktualisieren bzw. neu anlegen:
          try {
            pacman3d.util.LevelMetaInfo levelMetaInfo = lab.getLevelMetaInfo();
            if (levelMetaInfo != null)
              levelMetaInfoJPanel.getLevelMetaInfo(levelMetaInfo);
            else {
              levelMetaInfo = levelMetaInfoJPanel.getLevelMetaInfo();
              lab.setLevelMetaInfo(levelMetaInfo);
            }
            // Labyrinth speichern:
            lab.saveLevel(chooser.getSelectedFile().getAbsolutePath());
            levelEditingInternalFrame.setTitle(chooser.getSelectedFile().getName());
            this.fileName = chooser.getSelectedFile().getAbsolutePath();
          }
          catch (Exception exception) {
            Debug.out(this.getClass().getName(), exception);
          }
        }
      }
    }

    //
    // Labyrinth laden:
    //
    else if (actionEvent.getActionCommand().equals("Labyrinth laden")) {
      // FileChooser instantiieren:
      JFileChooser chooser = new JFileChooser();
      ExampleFileFilter filter = new ExampleFileFilter();
      filter.addExtension("xml");
      filter.setDescription("xml");
      filter.addExtension("p3d");
      filter.setDescription("p3d");
      chooser.setFileFilter(filter);
      chooser.setCurrentDirectory(new File(this.openDir));

      // Exit-Wert des FileDialogs merken.
      int returnVal = chooser.showOpenDialog(this.mainEditorFrame);

      // Vom Benutzer ausgewhlte Labyrinthdatei nur dann laden, wenn er den
      // FileDialog mit "OK" beendet hat.
      if(returnVal == JFileChooser.APPROVE_OPTION) {
        try {
          openDir = chooser.getSelectedFile().getParent();
          fileName = chooser.getSelectedFile().getAbsolutePath();

          // Ein neues Labyrinth instantiieren &
          lab = new Labyrinth();

          // Methode zum Einlesen eines abgespeicherten Labyrinthes aufrufen
          lab.loadLevel(new FileInputStream(chooser.getSelectedFile()));

          // LevelMetaInfo holen um der entsprechenden darstellenden Komponente
          // des Leveleditors bergeben, damit die entsprechenden Informationen
          // angezeigt bzw. editiert werden knnen.
          if (lab.getLevelMetaInfo() != null)
            levelMetaInfoJPanel.setLevelMetaInfo(lab.getLevelMetaInfo());

          // Vorkehrungen, um das eingelesene Labyrinth darzustellen:
          if (levelEditingInternalFrame != null) {
            textureSelectionPanel.removeActionListener(levelEditingJPanel);
            levelEditingInternalFrame.dispose();
          }
          levelEditingJPanel = new LevelEditingJPanel(this);
          textureSelectionPanel.addActionListener(levelEditingJPanel);
          levelEditingJPanel.setTextureChooser(textureSelectionPanel);

          // LevelEditingInternalFrame immer dann den Focus zuweisen, wenn sich
          // der Mauscursor ber dem 2D-Editierbereich des Labyrinths befindet.
          levelEditingJPanel.addMouseMotionListener(new MouseMotionAdapter() {
            public void mouseMoved(MouseEvent mouseEvent) {
              try {
                levelEditingInternalFrame.setSelected(true);
              }
              catch (Exception exception) {
              }
            }
          });

          // Ein neues InternalFrame anlegen, um in dieses die Komponente
          // zur 2D-Leveleditierung einzufgen
          levelEditingInternalFrame = new JInternalFrame("Neues Labyrinth", true, true, true, true);
          levelEditingInternalFrame.addInternalFrameListener( new InternalFrameAdapter() {
            public void internalFrameClosed(InternalFrameEvent e) {
              jToolBarLeveleditor.setEnabled(false);
            }
          });
          levelEditingInternalFrame.setTitle(chooser.getSelectedFile().getName());

          // Bildchen fr's Fenster setzen
          if (imageIcon != null)
            levelEditingInternalFrame.setFrameIcon(imageIcon);

          // Restliche Arbeiten fr's Einfgen des Panels fr
          // die 2D-Leveleditierung
          GridBagLayout gbl = new GridBagLayout();
          GridBagConstraints gbc = null;
          JPanel panel = new JPanel(gbl);
          gbc = makeGBC(0, 0, 1, 1);
          gbc.insets = new Insets(2, 2, 2, 2);
          gbc.anchor = GridBagConstraints.CENTER;
          gbl.setConstraints(levelEditingJPanel, gbc);

          // Fge "LevelEditingJPanel" in ein andere JPanel ein, damit
          // dieses zentriert dargestellt wird:
          panel.add(levelEditingJPanel);

          // Alles in ein JScrollPane einfgen,
          jScrollPane = new JScrollPane();
          jScrollPane.getViewport().add(panel);

          // Scrollbars nur benutzen, falls levelEditingJPanel zu gro fr das JInternalFrame ist
          jScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
          jScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
          levelEditingInternalFrame.getContentPane().add(jScrollPane);
          levelEditingInternalFrame.pack();
          jDesktopPane.add(levelEditingInternalFrame);

          levelEditingInternalFrame.setLocation(299, 0);
          levelEditingInternalFrame.setVisible(true);
          jToolBarLeveleditor.setEnabled(true);
        }
        catch (Exception exception) {
          Debug.out(this.getClass().getName(), exception);
        }
      }
    }

    //
    // Dialog zur Erzeugung eines neuen Labyrinthes aufrufen:
    //
    else if (actionEvent.getActionCommand().equals("Neues Labyrinth")) {
      // Dialog zur Levelgreabfrage anzeigen
      Point point = getStartPointForCenteredLocation(levelSizeDialog.getSize());
      levelSizeDialog.setLocation(point.x+this.mainEditorFrame.getLocation().x, point.y+this.mainEditorFrame.getLocation().y);
      levelSizeDialog.show();
    }
    // Falls der Benutzer doch kein neues Level erzeugen will:
    else if (actionEvent.getActionCommand().equals("cancel new level")) {
      levelSizeDialog.setVisible(false);
    }
    //
    // Neues Labyrinth anlegen:
    //
    else if (actionEvent.getActionCommand().equals("new level size ok")) {
      fileName = null;
      // Dialog fr Levelgre ausblenden
      levelSizeDialog.setVisible(false);

      // Eine neue Labyrinthinstanz der gewnschten Gre instantiieren
      int x = levelSizeDialog.getXSize();
      int y = levelSizeDialog.getYSize();
      int z = levelSizeDialog.getZSize();

      lab = new Labyrinth(x, y, z);

      String cellName;
      pacman3d.util.CellHandler cellHandler = pacman3d.util.CellHandler.getInstance();
      javax.vecmath.Point3i position;

      for (int yTmp = 0; yTmp < y; yTmp++)
        for (int xTmp = 0; xTmp < x; xTmp++)
	  for (int zTmp = 0; zTmp < z; zTmp++) {
	    position = new javax.vecmath.Point3i(xTmp, yTmp, zTmp);
            cellName = cellHandler.addCell(new pacman3d.labyrinth.cells.CellFloor(position));
            lab.setCell(cellName, position);
	}

      // Falls bereits zuvor ein Level editiert wurde, das darstellende Fenster schlieen.
      if (levelEditingInternalFrame != null) {
        textureSelectionPanel.removeActionListener(levelEditingJPanel);
        levelEditingInternalFrame.dispose();
      }
      //jToolBarLeveleditor.setEnabled(false);

      // Panel zur 2D-Leveleditierung instantiieren
      levelEditingJPanel = new LevelEditingJPanel(this);
      textureSelectionPanel.addActionListener(levelEditingJPanel);
      levelEditingJPanel.setTextureChooser(textureSelectionPanel);

      // Methode, damit das LevelEditingJPanel den Focus erhlt und sofort
      // bearbeitet werden kann, falls sich die Mouse ber diesem befindet.
      levelEditingJPanel.addMouseMotionListener(new MouseMotionAdapter() {
        public void mouseMoved(MouseEvent mouseEvent) {
          try {
            levelEditingInternalFrame.setSelected(true);
          }
          catch (Exception exception) {
          }
        }
      });

      // Ein neues InternalFrame anlegen, um die Komponente zur 2D-Leveleditierung
      // diesem hinzuzufgen
      levelEditingInternalFrame = new JInternalFrame("Neues Labyrinth", true, true, true, true);
          levelEditingInternalFrame.addInternalFrameListener( new InternalFrameAdapter() {
            public void internalFrameClosed(InternalFrameEvent e) {
              jToolBarLeveleditor.setEnabled(false);
            }
          });
      if (imageIcon != null)
        levelEditingInternalFrame.setFrameIcon(imageIcon);

      // DummyPanel, welchem die 2D-Leveleditierungskomponente hinzugefgt wird
      // (leider geht's nicht anders, damit die 2D-Leveleditierungskomponente
      //  zentriert dargestellt wird)
      GridBagLayout gbl = new GridBagLayout();
      GridBagConstraints gbc = null;
      JPanel panel = new JPanel(gbl);
      gbc = this.makeGBC(0, 0, 1, 1);
      gbc.insets = new Insets(2, 2, 2, 2);
      gbc.anchor = GridBagConstraints.CENTER;
      gbl.setConstraints(levelEditingJPanel, gbc);

      panel.add(levelEditingJPanel);

      // Alles in ein JScrollPane packen:
      jScrollPane = new JScrollPane();
      jScrollPane.getViewport().add(panel);
      jScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
      jScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
      levelEditingInternalFrame.getContentPane().add(jScrollPane);//, BorderLayout.CENTER);

      // Alles anzeigen
      jDesktopPane.add(levelEditingInternalFrame);
      levelEditingInternalFrame.pack();
      levelEditingInternalFrame.setLocation(299, 0);
      levelEditingInternalFrame.setVisible(true);
      jToolBarLeveleditor.setEnabled(true);
    }

    //
    // Fenster fr "Texturen" soll ein- bzw. ausgeblendet werden
    //
    else if (actionEvent.getActionCommand().equals("Texturen")) {
      if (textureInternalFrame.isVisible())
        textureInternalFrame.setVisible(false);
      else
        textureInternalFrame.setVisible(true);
    }

    //
    // Levelelemente-Fenster soll ein- bzw. ausgeblendet werden
    //
    else if (actionEvent.getActionCommand().equals("Cells")) {
      if (this.cellsAndItemsInternalFrame.isVisible())
        cellsAndItemsInternalFrame.setVisible(false);
      else
        cellsAndItemsInternalFrame.setVisible(true);
    }

    //
    // Fenster fr "LevelMetaInfo" soll ein- bzw. ausgeblendet werden
    //
    else if (actionEvent.getActionCommand().equals("levelmetainfo")) {
      if (levelMetaInfoInternalFrame.isVisible()) {
        levelMetaInfoInternalFrame.setVisible(false);
      }
      else {
        Point startPoint = getStartPointForCenteredLocation(levelMetaInfoInternalFrame.getSize());
        levelMetaInfoInternalFrame.setLocation(startPoint);
        levelMetaInfoInternalFrame.setVisible(true);
      }
    }

    //
    // Game starten
    //
    else if (actionEvent.getActionCommand().equals("Java3D Preview")) {
      try {
        File tmpFile = File.createTempFile("game","tmp");
        lab.saveLevel(tmpFile.getAbsolutePath());

        Runtime.getRuntime().exec("java -Xmx200M " +
          "-classpath .;jaxp.jar;ncsaportfolia13beta3.jar;parser.jar;portfolio.jar;StarfireExt.jar;xalan.jar;xmlrpc.jar " +
          "pacman3d.Game --withoutintro --levelfile " + tmpFile, null, new File(ClassLoader.getSystemResource("pacman3d/").getFile()+"/.."));
      }
      catch (Exception exception) {
        Debug.out(this.getClass().getName(), exception);
      }
    }

    //
    // Hilfe-Fenster soll ein- bzw. ausgeblendet werden
    //
    else if (actionEvent.getActionCommand().equals("help")) {
      if (this.helpInternalFrame.isVisible()) {
        helpInternalFrame.setVisible(false);
      }
      else {
        Point startPoint = getStartPointForCenteredLocation(helpInternalFrame.getSize());
        helpInternalFrame.setLocation(startPoint);
        helpInternalFrame.setVisible(true);
      }
    }

    //
    // About-Fenster soll ein- bzw. ausgeblendet werden
    //
    else if (actionEvent.getActionCommand().equals("about")) {
      /*
      AboutJDialog diag = new AboutJDialog(this);
      diag.setSize(400, 300);
      Point point = this.getStartPointForCenteredLocation(diag.getSize());
      diag.setLocation(point.x+this.mainEditorFrame.getLocation().x, point.y+this.mainEditorFrame.getLocation().y);
      diag.setVisible(true);
      */
    }

    //
    // Fenster fr Farbeinstellungen soll ein- bzw. ausgeblendet werden
    //
    else if (actionEvent.getActionCommand().equals("properties")) {
      if (colorChooser2DComponentsInternalFrame.isVisible())
        colorChooser2DComponentsInternalFrame.setVisible(false);
      else
        colorChooser2DComponentsInternalFrame.setVisible(true);
    }

    //
    // Benutzer will in der 2D-Leveldarstellung hineinzoomen.
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("zoom in")) {
      levelEditingJPanel.zoomIn();
      jScrollPane.validate();
      jScrollPane.getViewport().validate();
    }

    //
    // Benutzer will aus der 2D-Leveldarstellung hinauszoomen.
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("zoom out")) {
      levelEditingJPanel.zoomOut();
      jScrollPane.validate();
      jScrollPane.getViewport().validate();
    }

    //
    // Pacmanstartpositionen ein- bzw. ausblenden
    //
    else if (actionEvent.getActionCommand().equals("show pacman startpositions")) {
      levelEditingJPanel.drawPacmanStartPositions();
    }

    //
    // Grid bei der 2D-Leveldarstellung einblenden.
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("grid on")) {
      JButton gridCheckBox = (JButton)actionEvent.getSource();
      gridCheckBox.setActionCommand("grid off");
      levelEditingJPanel.setGrid(true);
    }

    //
    // Benutzer will Grid bei der 2D-Leveldarstellung ausblenden.
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("grid off")) {
      JButton gridCheckBox = (JButton)actionEvent.getSource();
      gridCheckBox.setActionCommand("grid on");
      levelEditingJPanel.setGrid(false);
    }

    //
    // Gnge der unteren Ebene in der aktuellen Ebene anzeigen:
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("show lower level floors")) {
      this.levelEditingJPanel.drawLowerLevelFloors();
    }

    //
    // Wnde der unteren Ebene in der aktuellen Ebene anzeigen:
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("show lower level walls")) {
      this.levelEditingJPanel.drawLowerLevelWalls();
    }

    //
    // Gnge der oberen Ebene in der aktuellen Ebene anzeigen:
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("show upper level floors")) {
      this.levelEditingJPanel.drawUpperLevelFloors();
    }

    //
    // Wnde der oberen Ebene in der aktuellen Ebene anzeigen:
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("show upper level walls")) {
      this.levelEditingJPanel.drawUpperLevelWalls();
    }

    //
    // Items in der aktuellen Ebene ein- bzw. ausblenden
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("show items")) {
      this.levelEditingJPanel.drawItems();
    }

    //
    // Monster in der aktuellen Ebene ein- bzw. ausblenden
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    //
    else if (actionEvent.getActionCommand().equals("show monsters & startpositions")) {
      this.levelEditingJPanel.drawMonstersAndPossibleStartPositions();
    }

    /*
    // :)
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    else if (actionEvent.getActionCommand().equals("closeFloorsToLower")) {
      this.levelEditingJPanel.closeFloorsToLower();
    }
    // :)
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    else if (actionEvent.getActionCommand().equals("openWallsToLower")) {
      this.levelEditingJPanel.openWallsToLower();
    }
    // :)
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    else if (actionEvent.getActionCommand().equals("closeFloorsToUpper")) {
      this.levelEditingJPanel.closeFloorsToUpper();
    }
    // :p
    // Diesen Teil hier lschen und direkt auf "LevelEditingJPanel" aufrufen?!
    else if (actionEvent.getActionCommand().equals("openWallsToUpper")) {
      this.levelEditingJPanel.openWallsToUpper();
    }
    */
  }

  /**
   * Innerhalb dieser Methode erfolgt der Aufbau des Leveleditors, d.h. die
   * Initialsierung der GUI und die notwendigen Initialisierungen der bentigten
   * Klassen. Diese Methode wird vom Konstruktor dieser Klasse automatisch aufgerufen
   * und sollte somit fr den Endanwender von keinem Interesse sein.
   *
   * @see #Leveleditor()
   */
  private final void guiInit() {
    // Leveleditor-Hauptfenster:
    mainEditorFrame = new JFrame("Leveleditor");

    mainEditorFrame.setSize(810, 852);


    // Leveleditor-Hauptfenster einen WindowAdapter verpassen, damit's
    // geschlossen werden kann
    mainEditorFrame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });

    // Bildchen fr das Fenster
    if (imageIcon != null) {
      Image image = imageIcon.getImage();
      mainEditorFrame.setIconImage(image);
    }

    // mainEditorFrame ein "JDesktopPane" zuweisen, damit wir mit
    // JInternalFrame arbeiten knnen.
    jDesktopPane = new JDesktopPane();
    mainEditorFrame.getContentPane().setLayout(new BorderLayout());
    mainEditorFrame.getContentPane().add(jDesktopPane, BorderLayout.CENTER);

    // Toolbar setzen
    jToolBarLeveleditor = new JToolBarLeveleditor(this);
    this.mainEditorFrame.getContentPane().add(jToolBarLeveleditor, BorderLayout.NORTH);

    //
    // Menleiste des Leveleditorhauptfensters:
    //
    JMenuBar menubar = new JMenuBar();
    mainEditorFrame.setJMenuBar(menubar);

    // Menpunkte fr "Labyrinth laden", "Labyrinth speichern" und
    // "Neues Labyrinth"
    JMenu fileMenu = new JMenu("Datei");
    fileMenu.setMnemonic(KeyEvent.VK_D);
    menubar.add(fileMenu);

    // "Neues Labyrinth" Menpunkt
    JMenuItem newLevelMenuItem = new JMenuItem("Neues Labyrinth", new ImageIcon(url.getFile()+"new.gif"));
    newLevelMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
    newLevelMenuItem.getAccessibleContext().setAccessibleDescription("Neues Labyrinth");
    newLevelMenuItem.setActionCommand("Neues Labyrinth");
    newLevelMenuItem.addActionListener(this);
    fileMenu.add(newLevelMenuItem);

    // "ffnen"-Menpunkt
    JMenuItem load = new JMenuItem("ffnen", new ImageIcon(url.getFile()+"open.gif"));
    load.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, ActionEvent.CTRL_MASK));
    load.getAccessibleContext().setAccessibleDescription("Labyrinth laden");
    load.setActionCommand("Labyrinth laden");
    load.addActionListener(this);
    fileMenu.add(load);

    // "Speichern"-Menpunkt
    JMenuItem save = new JMenuItem("Speichern", new ImageIcon(url.getFile()+"save.gif"));
    save.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.ALT_MASK));
    save.getAccessibleContext().setAccessibleDescription("Labyrinth speichern");
    save.setActionCommand("Labyrinth speichern");
    save.addActionListener(this);
    fileMenu.add(save);

    // "Speichern unter..."-Menpunkt
    JMenuItem saveAs = new JMenuItem("Speichern unter...", new ImageIcon(url.getFile()+"save_dummy.gif"));
    saveAs.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
    saveAs.getAccessibleContext().setAccessibleDescription("Labyrinth speichern unter...");
    saveAs.setActionCommand("save as");
    saveAs.addActionListener(this);
    fileMenu.add(saveAs);


    //
    // Menpunkte fr "Texturen" und "Levelelemente"
    //
    JMenu windowsMenu = new JMenu("Fenster");
    windowsMenu.setMnemonic(KeyEvent.VK_F);
    menubar.add(windowsMenu);

    // "Texturen & Farben"-Menpunkt
    JMenuItem textureMenu = new JMenuItem("Texturen & Farben",new ImageIcon(url.getFile()+"textur.gif"));
    textureMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, ActionEvent.CTRL_MASK));
    textureMenu.getAccessibleContext().setAccessibleDescription("Texturen & Farben");
    textureMenu.setActionCommand("Texturen");
    textureMenu.addActionListener(this);
    windowsMenu.add(textureMenu);

    // "Levelelemente"-Menpunkt
    JMenuItem cellsMenu = new JMenuItem("Levelelemente",new ImageIcon(url.getFile()+"3dShapes.gif"));
    cellsMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_L, ActionEvent.CTRL_MASK));
    cellsMenu.getAccessibleContext().setAccessibleDescription("Levelelemente");
    cellsMenu.setActionCommand("Cells");
    cellsMenu.addActionListener(this);
    windowsMenu.add(cellsMenu);

    windowsMenu.addSeparator();

    // "Java3D-Preview" Menpunkt
    JMenuItem previewMenu = new JMenuItem("Spiel starten",new ImageIcon(url.getFile()+"save_dummy.gif"));
    previewMenu.setEnabled(true);
    previewMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, ActionEvent.CTRL_MASK));
    previewMenu.setActionCommand("Java3D Preview");
    previewMenu.addActionListener(this);
    windowsMenu.add(previewMenu);


    menubar.add(Box.createHorizontalGlue());

    //
    // Hilfe
    //
    JMenu helpMenu = new JMenu("Hilfe");
    helpMenu.setMnemonic(KeyEvent.VK_H);
    menubar.add(helpMenu);

    // "Hilfe"-Menpunkt
    JMenuItem helpMenuItem = new JMenuItem("Hilfe",new ImageIcon(url.getFile()+"help.gif"));
    helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
    helpMenuItem.getAccessibleContext().setAccessibleDescription("Hilfe");
    helpMenuItem.setActionCommand("help");
    helpMenuItem.addActionListener(this);
    helpMenu.add(helpMenuItem);

    helpMenu.addSeparator();

    // "ber"-Menpunkt
    /*
    JMenuItem aboutMenuItem = new JMenuItem("ber",new ImageIcon(url.getFile()+"save_dummy.gif"));
    aboutMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I, ActionEvent.CTRL_MASK));
    aboutMenuItem.getAccessibleContext().setAccessibleDescription("ber...");
    aboutMenuItem.setActionCommand("about");
    aboutMenuItem.addActionListener(this);
    helpMenu.add(aboutMenuItem);
    */

    //
    // Die versch. Fensterchen
    //

    // Dialog fr die Levelgreabfrage bei Erzeugung eines
    // neuen Levels
    levelSizeDialog = new LevelSizeDialog(this);
    levelSizeDialog.pack();
    levelSizeDialog.setVisible(false);

    //
    // Fensterchen fr "Texturen & Farben" und "Levelelemente"
    // Diese werden von Beginn an angezeigt
    //

    // InternalFrame fr "Texturen & Farben"
    textureInternalFrame = new JInternalFrame("Texturen & Farben", true, true, true, true);
    if (imageIcon != null)
      textureInternalFrame.setFrameIcon(new ImageIcon(url.getFile()+"textur.gif"));

    textureInternalFrame.setLocation(0, 0);
    textureInternalFrame.setDefaultCloseOperation(JInternalFrame.HIDE_ON_CLOSE);

    textureInternalFrame.getContentPane().add(textureSelectionPanel);
    textureInternalFrame.setSize(299, 305);
    jDesktopPane.add(textureInternalFrame);
    textureInternalFrame.setVisible(true);

    // JInternalFrame fr "Levelelemente"
    cellsAndItemsInternalFrame = new JInternalFrame("Levelelemente", true, true, true, true);
    if (imageIcon != null)
      cellsAndItemsInternalFrame.setFrameIcon(new ImageIcon(url.getFile()+"3dShapes.gif"));

    cellsAndItemsInternalFrame.setSize(220, 200);
    cellsAndItemsInternalFrame.setLocation(40,40);
    cellsAndItemsInternalFrame.setDefaultCloseOperation(JInternalFrame.HIDE_ON_CLOSE);
    cellsJPanel = new CellsJPanel(this);
    itemJPanel = new ItemJPanel(this);
    pacmanJPanel = new PacmanJPanel();
    monsterJPanel = new MonsterJPanel();

    JPanel jPanel = new JPanel(new BorderLayout());
    tabbedPane2 = new JTabbedPane(JTabbedPane.TOP);
    tabbedPane2.addTab("Zelltypen", cellsJPanel);
    tabbedPane2.addTab("Items", itemJPanel);
    tabbedPane2.addTab("Pacman", pacmanJPanel);
    tabbedPane2.addTab("Monster", monsterJPanel);
    jPanel.add(tabbedPane2, BorderLayout.CENTER);

    cellsAndItemsInternalFrame.getContentPane().add(jPanel);
    cellsAndItemsInternalFrame.setSize(299, 460);
    cellsAndItemsInternalFrame.setLocation(0,305);

    jDesktopPane.add(cellsAndItemsInternalFrame);
    jDesktopPane.setBackground(Color.lightGray);
    cellsAndItemsInternalFrame.setVisible(true);

    //
    // JInternalFrame fr "Farbeinstellungen"
    //
    colorChooser2DComponentsInternalFrame = new ColorChooser2DComponents(this);
    colorChooser2DComponentsInternalFrame.pack();
    jDesktopPane.add(colorChooser2DComponentsInternalFrame);
    colorChooser2DComponentsInternalFrame.setVisible(false);


    //
    // JInternalFrame fr "LevelMetaInfo"
    //
    levelMetaInfoInternalFrame = new JInternalFrame("LevelMetaInfo", true, true, true, true);
    levelMetaInfoInternalFrame.setFrameIcon(new ImageIcon(url.getFile()+"info.gif"));

    levelMetaInfoInternalFrame.setDefaultCloseOperation(JInternalFrame.HIDE_ON_CLOSE);
    levelMetaInfoJPanel = new LevelMetaInfoJPanel();
    levelMetaInfoInternalFrame.getContentPane().add(levelMetaInfoJPanel);
    levelMetaInfoInternalFrame.pack();

    jDesktopPane.add(levelMetaInfoInternalFrame);
    levelMetaInfoInternalFrame.setVisible(false);

    //
    // JInternalFrame fr "Hilfe"
    //
    helpInternalFrame = new JInternalFrame("Hilfe", true, true, true, true);
    helpInternalFrame.setFrameIcon(new ImageIcon(url.getFile()+"help.gif"));

    helpInternalFrame.setDefaultCloseOperation(JInternalFrame.HIDE_ON_CLOSE);
    help = new LeveleditorHelpJPanel();
    helpInternalFrame.getContentPane().add(help);
    helpInternalFrame.pack();

    jDesktopPane.add(helpInternalFrame);
    helpInternalFrame.setSize(500, 300);
    Point startPoint = this.getStartPointForCenteredLocation(helpInternalFrame.getSize());
    helpInternalFrame.setLocation(startPoint);

    helpInternalFrame.setVisible(false);

    // Alles anzeigen:
    mainEditorFrame.setVisible(true);
  }

  /**
   * Hilfsmethode fr den GridBagLayout-Manager.
   *
   * @param x x-Koordinate der einzufgenden Komponente.
   * @param y y-Koordinate der einzufgenden Komponente.
   * @param width Horizontal Ausbreitung der einzufgenden Komponente.
   * @param height Vertikale Ausbreitung der einzufgenden Komponente.
   *
   * @return java.awt.GridBagConstraints Instanz.
   */
  private GridBagConstraints makeGBC(int x, int y, int width, int height) {
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.gridx = x;
    gbc.gridy = y;
    gbc.gridwidth = width;
    gbc.gridheight = height;
    gbc.insets = new Insets(1, 1, 1, 1);
    return gbc;
  }

  /**
   * Hilfsmethode, die den Anfangspunkt fr ein Fenster der {@link java.awt.Dimension}
   * liefert, um im {@link #mainEditorFrame Hauptfenster} zentriert dargestellt zu
   * erscheinen.
   *
   * @param internalFrameSize Gre des im Leveleditor-Hauptfenster zentriert darzustellenden Fensters.
   * @return Anfangspunkt, damit das darzustellende Fenster zentriert im Leveleditor-Hauptfenster erscheint.
   */
  private Point getStartPointForCenteredLocation(Dimension internalFrameSize) {
    Dimension dimension = this.mainEditorFrame.getSize();
    Point point = new Point(dimension.width/2-internalFrameSize.width/2, dimension.height/2-internalFrameSize.height/2);
    return point;
  }

  /**
   * Main-Methode, damit diese Klasse als Applikation ausgefhrt werden kann.
   */
  public static void main(String args[]) {
    /*
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch (Exception e) {}
    */
    Leveleditor test = new Leveleditor();
  }
}