package pacman3d.labyrinth.leveleditor;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse ist eine Subklasse von {@link javax.swing.JDialog JDialog} und
 * kann als solche GUI-Komponente verwendet werden.<br>
 * Diese Subklasse ist um weitere GUI-Komponenten erweitert, um vom Benutzer
 * abzufragen, wie gro ein neu zu erstellendes {@link
 * pacman3d.labyrinth.Labyrinth Labyrinth} sein soll.<p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class LevelSizeDialog extends JDialog {
  /**
   * Instanz der Klasse {@link javax.swing.JFrame JFrame}, welche hier als
   * <b>Dummy-Frame</b> verwendet wird, um dieser Klasse ein andere Frame-Icon
   * zuweisen zu knnen.
   */
  protected static JFrame dummy_frame = new JFrame();

  /**
   * Referenz auf die {@link pacman3d.labyrinth.leveleditor.Leveleditor
   * Hauptklasse des Leveleditors}.
   */
  protected Leveleditor leveleditor;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField} zur Eingabe
   * der Anzahl der Zellen in x-Richtung.
   */
  protected JTextField xTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField} zur Eingabe
   * der Anzahl der Zellen in y-Richtung.
   */
  protected JTextField yTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField} zur Eingabe
   * der Anzahl der Zellen in z-Richtung.
   */
  protected JTextField zTextField;

  /**
   * Konstruktor:<p>
   *
   * Um diesen durch diese Klasse realisierten Eingabedialog fr die Gre eines
   * neuen Labyrinthes zu verwenden, ist nur eine Referenz auf die {@link
   * pacman3d.labyrinth.leveleditor.Leveleditor Hauptklasse des Leveleditors}
   * zu bergeben.
   *
   * @param leveleditor Referenz auf Hauptklasse des Leveleditors.
   */
  public LevelSizeDialog(Leveleditor leveleditor) {
    super(dummy_frame, "Neues Labyrinth", true);
    this.leveleditor = leveleditor;

    guiInit();
  }

  /**
   * Innerhalb dieser Methode erfolgt der Aufbau dieser Komponente, d.h. die
   * Initialsierung der GUI und die notwendigen Initialisierungen der bentigten
   * Klassen. Diese Methode wird vom Konstruktor dieser Klasse automatisch aufgerufen
   * und sollte somit fr den Endanwender von keinem Interesse sein.
   *
   * @see #LevelSizeDialog
   */
  private void guiInit() {
    ImageIcon icon = new ImageIcon(leveleditor.url.getFile()+"new.gif");
    dummy_frame.setIconImage(icon.getImage());

    this.getContentPane().setLayout(new BorderLayout());

    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = null;

    // JPanel mit den Einstellmglichkeiten der Labyrinthgre
    JPanel panel = new JPanel(gbl);
    panel.setBorder(BorderFactory.createTitledBorder("Labyrinthgre"));
    this.getContentPane().add(panel, BorderLayout.CENTER);

    // Ausdehnung in x-Richtung: Ein Zhler entspricht einer Zelle
    JLabel      xLabel      = new JLabel("Zellen in x-Richtung");
    xLabel.setForeground(Color.black);
    gbc = makeGBC(1, 0, 1, 1);
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.WEST;
    gbc.weightx = 0.5f;
    gbc.weighty = 0.3f;
    gbl.addLayoutComponent(xLabel, gbc);
    panel.add(xLabel);

    xTextField  = new JTextField("4", 4);
    xTextField.setHorizontalAlignment(JTextField.RIGHT);
    gbc = makeGBC(0, 0, 1, 1);
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.CENTER;
    gbc.weightx = 0.5f;
    gbc.weighty = 0.3f;
    gbl.addLayoutComponent(xTextField, gbc);
    panel.add(xTextField);

    // Ausdehnung in y-Richtung: Ein Zhler entspricht einer Zelle
    JLabel      yLabel      = new JLabel("Zellen in y-Richtung");
    yLabel.setForeground(Color.black);
    gbc = makeGBC(1, 1, 1, 1);
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.WEST;
    gbc.weightx = 0.5f;
    gbc.weighty = 0.3f;
    gbl.addLayoutComponent(yLabel, gbc);
    panel.add(yLabel);

    yTextField  = new JTextField("2", 4);
    yTextField.setHorizontalAlignment(JTextField.RIGHT);
    gbc = makeGBC(0, 1, 1, 1);
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.CENTER;
    gbc.weightx = 0.5f;
    gbc.weighty = 0.3f;
    gbl.addLayoutComponent(yTextField, gbc);
    panel.add(yTextField);

    // Ausdehnung in z-Richtung: Ein Zhler entspricht einer Zelle
    JLabel      zLabel      = new JLabel("Zellen in z-Richtung");
    zLabel.setForeground(Color.black);

    gbc = makeGBC(1, 2, 1, 1);
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.WEST;
    gbc.weightx = 0.5f;
    gbc.weighty = 0.3f;
    gbl.addLayoutComponent(zLabel, gbc);
    panel.add(zLabel);

    zTextField  = new JTextField("4", 4);
    zTextField.setHorizontalAlignment(JTextField.RIGHT);
    gbc = makeGBC(0, 2, 1, 1);
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.CENTER;
    gbc.weightx = 0.5f;
    gbc.weighty = 0.3f;
    gbl.addLayoutComponent(zTextField, gbc);
    panel.add(zTextField);


    // Buttons zum Beenden des Eingabedialogs:
    JPanel buttonsPanel = new JPanel(new FlowLayout());
    JButton okButton        = new JButton("Ok");
    okButton.setActionCommand("new level size ok");
    okButton.addActionListener(leveleditor);
    buttonsPanel.add(okButton);

    JButton cancelButton    = new JButton("Abbrechen");
    cancelButton.setActionCommand("cancel new level");
    cancelButton.addActionListener(leveleditor);
    buttonsPanel.add(cancelButton);

    this.getContentPane().add(buttonsPanel, BorderLayout.SOUTH);


    this.pack();
  }

  /**
   * Liefert die vom Benutzer gemachte Eingabe im Feld {@link #xTextField}
   * zurck.
   *
   * @return Die vom Benutzer gemachte Eingabe im Feld {@link #xTextField}.
   */
  public int getXSize() {
    return Integer.parseInt(xTextField.getText());
  }

  /**
   * Liefert die vom Benutzer gemachte Eingabe im Feld {@link #yTextField}
   * zurck.
   *
   * @return Die vom Benutzer gemachte Eingabe im Feld {@link #yTextField}.
   */
  public int getYSize() {
    return Integer.parseInt(yTextField.getText());
  }

  /**
   * Liefert die vom Benutzer gemachte Eingabe im Feld {@link #zTextField}
   * zurck.
   *
   * @return Die vom Benutzer gemachte Eingabe im Feld {@link #zTextField}.
   */
  public int getZSize() {
    return Integer.parseInt(zTextField.getText());
  }

  /**
   * Hilfsmethode fr den GridBagLayout-Manager.
   *
   * @param x x-Koordinate der einzufgenden Komponente.
   * @param y y-Koordinate der einzufgenden Komponente.
   * @param width Horizontal Ausbreitung der einzufgenden Komponente.
   * @param height Vertikale Ausbreitung der einzufgenden Komponente.
   *
   * @return java.awt.GridBagConstraints Instanz.
   */
  private GridBagConstraints makeGBC(int x, int y, int width, int height) {
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.gridx = x;
    gbc.gridy = y;
    gbc.gridwidth = width;
    gbc.gridheight = height;
    gbc.insets = new Insets(1, 4, 1, 2);
    return gbc;
  }
}