package pacman3d.labyrinth.leveleditor;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import pacman3d.util.*;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse ist eine Subklasse von {@link javax.swing.JPanel JPanel} und
 * kann als solche GUI-Komponente verwendet werden.<br>
 * Diese Subklasse ist um weitere GUI-Komponenten erweitert, so da durch sie
 * eine Editierung und Darstellung der Klasse {@link pacman3d.util.LevelMetaInfo
 * LevelMetaInfo} durch den Benutzer mglich ist.<p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class LevelMetaInfoJPanel extends JPanel {

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField}, zur Eingabe
   * des Titels eines vom Benutzer erzeugten Labyrinthes.<br>
   * Diese Information wird in einer Instanz der Klasse {@link
   * pacman3d.util.LevelMetaInfo LevelMetaInfo} abgelegt.
   *
   * @see #versionTextField
   * @see #dateTextField
   * @see #authorTextField
   * @see #eMailTextField
   * @see #urlTextField
   * @see #gameVersionTextField
   * @see #missionTextArea
   */
  protected JTextField  titleTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField}, zur Eingabe
   * der Version eines vom Benutzer erzeugten Labyrinthes.<br>
   * Diese Information wird in einer Instanz der Klasse {@link
   * pacman3d.util.LevelMetaInfo LevelMetaInfo} abgelegt.
   *
   * @see #titleTextField
   * @see #dateTextField
   * @see #authorTextField
   * @see #eMailTextField
   * @see #urlTextField
   * @see #gameVersionTextField
   * @see #missionTextArea
   */
  protected JTextField  versionTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField}, zur Eingabe
   * des Entstehungsdatum eines vom Benutzer erzeugten Labyrinthes.<br>
   * Diese Information wird in einer Instanz der Klasse {@link
   * pacman3d.util.LevelMetaInfo LevelMetaInfo} abgelegt.
   *
   * @see #titleTextField
   * @see #versionTextField
   * @see #dateTextField
   * @see #authorTextField
   * @see #eMailTextField
   * @see #urlTextField
   * @see #gameVersionTextField
   * @see #missionTextArea
   */
  protected JTextField  dateTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField}, zur Eingabe
   * des Autors eines vom Benutzer erzeugten Labyrinthes.<br>
   * Diese Information wird in einer Instanz der Klasse {@link
   * pacman3d.util.LevelMetaInfo LevelMetaInfo} abgelegt.
   *
   * @see #titleTextField
   * @see #versionTextField
   * @see #dateTextField
   * @see #eMailTextField
   * @see #urlTextField
   * @see #gameVersionTextField
   * @see #missionTextArea
   */
  protected JTextField  authorTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField}, zur Eingabe
   * der eMail-Adresse Autors des erzeugten Labyrinthes.<br>
   * Diese Information wird in einer Instanz der Klasse {@link
   * pacman3d.util.LevelMetaInfo LevelMetaInfo} abgelegt.
   *
   * @see #titleTextField
   * @see #versionTextField
   * @see #dateTextField
   * @see #authorTextField
   * @see #urlTextField
   * @see #gameVersionTextField
   * @see #missionTextArea
   */
  protected JTextField  eMailTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField}, zur Eingabe
   * der Homepage-URL des Benutzer des erzeugten Labyrinthes.<br>
   * Diese Information wird in einer Instanz der Klasse {@link
   * pacman3d.util.LevelMetaInfo LevelMetaInfo} abgelegt.
   *
   * @see #titleTextField
   * @see #versionTextField
   * @see #dateTextField
   * @see #authorTextField
   * @see #eMailTextField
   * @see #gameVersionTextField
   * @see #missionTextArea
   */
  protected JTextField  urlTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField}, zur Eingabe
   * der Spielversion des vom Benutzer erzeugten Labyrinthes.<br>
   * Diese Information wird in einer Instanz der Klasse {@link
   * pacman3d.util.LevelMetaInfo LevelMetaInfo} abgelegt.
   *
   * @see #titleTextField
   * @see #versionTextField
   * @see #dateTextField
   * @see #authorTextField
   * @see #eMailTextField
   * @see #urlTextField
   * @see #missionTextArea
   */
  protected JTextField  gameVersionTextField;

  /**
   * Instanz der Klasse {@link javax.swing.JTextArea JTextArea}, zur Eingabe
   * der Mission eines vom Benutzer erzeugten Labyrinthes.<br>
   * Diese Information wird in einer Instanz der Klasse {@link
   * pacman3d.util.LevelMetaInfo LevelMetaInfo} abgelegt.
   *
   * @see #titleTextField
   * @see #versionTextField
   * @see #dateTextField
   * @see #authorTextField
   * @see #eMailTextField
   * @see #urlTextField
   * @see #gameVersionTextField
   */
  protected JTextArea missionTextArea;

  /**
   * Konstruktor:<br>
   *
   * Instantiierung dieser Komponente. Um die Daten aus einer Instanz der Klasse
   * {@link pacman3d.util.LevelMetaInfo LevelMetaInfo} anzuzeigen bzw. die vom
   * Benutzer gemachten Eingaben abzufragen, sind die Methode {@link
   * #setLevelMetaInfo}, {@link #getLevelMetaInfo} oder {@link
   * #getLevelMetaInfo(pacman3d.util.LevelMetaInfo levelMetaInfo)} zu verwenden.
   */
  public LevelMetaInfoJPanel() {
    guiInit();
  }

  /**
   * Zeigt die in der Instanz <b>levelMetaInfo</b> gespeicherten Daten in den
   * entsprechenden Feldern dieser Klasse an.<br>
   * Wird der Wert <b>null</b> bergeben, so werden alle Felder dieser
   * Komponenten gelscht.
   *
   * @param levelMetaInfo Instanz der Klasse {@link pacman3d.util.LevelMetaInfo
   *        LevelMetaInfo}, deren Daten in dieser Komponenten angezeigt werden
   *        sollen.<br>
   *        Wird der Wert <b>null</b> bergeben, so werden alle Felder dieser
   *        Komponenten gelscht.
   *
   * @see #getLevelMetaInfo()
   * @see #getLevelMetaInfo(pacman3d.util.LevelMetaInfo levelMetaInfo)
   */
  public void setLevelMetaInfo(LevelMetaInfo levelMetaInfo) {
    if (levelMetaInfo != null) {
      titleTextField.setText(levelMetaInfo.getTitle());
      missionTextArea.setText(levelMetaInfo.getMission());
      versionTextField.setText(levelMetaInfo.getVersion());
      dateTextField.setText(levelMetaInfo.getDate());
      authorTextField.setText(levelMetaInfo.getAuthor());
      eMailTextField.setText(levelMetaInfo.getContactEmail());
      urlTextField.setText(levelMetaInfo.getUri());
      gameVersionTextField.setText(levelMetaInfo.getGameVersion());
    }
    else {
      titleTextField.setText("");
      missionTextArea.setText("");
      versionTextField.setText("");
      dateTextField.setText("");
      authorTextField.setText("");
      eMailTextField.setText("");
      urlTextField.setText("");
      gameVersionTextField.setText("");
    }
  }

  /**
   * Liefert die vom Benutzer in dieser Komponenten gemachten Eingaben als
   * Instanz der Klasse {@link pacman3d.util.LevelMetaInfo LevelMetaInfo}
   * zurck.
   *
   * @return Instanz der Klasse {@link pacman3d.util.LevelMetaInfo LevelMetaInfo}
   *         mit den vom Benutzer gemachten Eingaben initialisiert.
   *
   * @see #getLevelMetaInfo(LevelMetaInfo levelMetaInfo)
   * @see #setLevelMetaInfo
   */
  public LevelMetaInfo getLevelMetaInfo() {
    LevelMetaInfo levelMetaInfo = new LevelMetaInfo();

    levelMetaInfo.setTitle(titleTextField.getText());
    levelMetaInfo.setMission(missionTextArea.getText());
    levelMetaInfo.setVersion(versionTextField.getText());
    levelMetaInfo.setDate(dateTextField.getText());
    levelMetaInfo.setAuthor(authorTextField.getText());
    levelMetaInfo.setContactEmail(eMailTextField.getText());
    levelMetaInfo.setUri(urlTextField.getText());
    levelMetaInfo.setGameVersion(gameVersionTextField.getText());

    return levelMetaInfo;

  }

  /**
   * Ersetzt die entsprechenden Felder in der bergebenen Instanz
   * <b>levelMetaInfo</b> durch die vom Benutzer in dieser Komponenten gemachten
   * Eingaben.
   *
   * @param levelMetaInfo LevelMetaInfo-Instanz, deren entsprechende Felder durch
   *        die vom Benutzer in dieser Komponenten gemachten Eingaben ersetzt
   *        werden sollen.
   *
   * @see #getLevelMetaInfo()
   * @see #setLevelMetaInfo
   */
  public void getLevelMetaInfo(LevelMetaInfo levelMetaInfo) {
    if (levelMetaInfo != null) {
      levelMetaInfo.setTitle(titleTextField.getText());
      levelMetaInfo.setMission(missionTextArea.getText());
      levelMetaInfo.setVersion(versionTextField.getText());
      levelMetaInfo.setDate(dateTextField.getText());
      levelMetaInfo.setAuthor(authorTextField.getText());
      levelMetaInfo.setContactEmail(eMailTextField.getText());
      levelMetaInfo.setUri(urlTextField.getText());
      levelMetaInfo.setGameVersion(gameVersionTextField.getText());
    }
  }


  /**
   * Innerhalb dieser Methode erfolgt der Aufbau der LevelMetaInfo-Eingabekomponente,
   * d.h. die Initialsierung der GUI und die notwendigen Initialisierungen der bentigten
   * Klassen. Diese Methode wird vom Konstruktor dieser Klasse automatisch aufgerufen
   * und sollte somit fr den Endanwender von keinem Interesse sein.
   *
   * @see #LevelMetaInfoJPanel
   */
  private final void guiInit() {
  LevelMetaInfo levelMetaInfo = new LevelMetaInfo();

    GridBagLayout gbl       = new GridBagLayout();
    GridBagConstraints gbc  = null;

    this.setLayout(gbl);

    JLabel label;

    //
    // Title
    //
    label = new JLabel("Titel :");
    label.setForeground(Color.black);

    gbc = makeGBC(0, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.NORTHEAST;
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;

    gbl.addLayoutComponent(label, gbc);
    this.add(label);

    this.titleTextField = new JTextField();
    this.titleTextField.setHorizontalAlignment(JTextField.LEFT);

    gbc = makeGBC(1, 0, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.NORTHWEST;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(titleTextField, gbc);
    this.add(titleTextField);

    //
    // Mission
    //
    label = new JLabel("Mission :");
    label.setForeground(Color.black);

    gbc = makeGBC(0, 1, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.NORTHEAST;
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;

    gbl.addLayoutComponent(label, gbc);
    this.add(label);

    this.missionTextArea = new JTextArea(4,40);

    gbc = makeGBC(1, 1, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.NORTHWEST;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    JScrollPane missionTextAreaScrollPane = new JScrollPane(missionTextArea);
    gbl.addLayoutComponent(missionTextAreaScrollPane, gbc);
    this.add(missionTextAreaScrollPane);

    //
    // Version
    //
    label = new JLabel("Version :");
    label.setForeground(Color.black);

    gbc = makeGBC(0, 2, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.NORTHEAST;
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;

    gbl.addLayoutComponent(label, gbc);
    this.add(label);

    this.versionTextField = new JTextField();
    this.versionTextField.setHorizontalAlignment(JTextField.LEFT);

    gbc = makeGBC(1, 2, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.NORTHWEST;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(versionTextField, gbc);
    this.add(versionTextField);

    //
    // Date
    //
    label = new JLabel("Datum :");
    label.setForeground(Color.black);

    gbc = makeGBC(0, 3, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.NORTHEAST;
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;

    gbl.addLayoutComponent(label, gbc);
    this.add(label);

    this.dateTextField = new JTextField();
    this.dateTextField.setHorizontalAlignment(JTextField.LEFT);

    gbc = makeGBC(1, 3, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.NORTHWEST;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(dateTextField, gbc);
    this.add(dateTextField);

    //
    // Autor
    //
    label = new JLabel("Autor :");
    label.setForeground(Color.black);

    gbc = makeGBC(0, 4, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.NORTHEAST;
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;

    gbl.addLayoutComponent(label, gbc);
    this.add(label);

    this.authorTextField = new JTextField();
    this.authorTextField.setHorizontalAlignment(JTextField.LEFT);

    gbc = makeGBC(1, 4, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.NORTHWEST;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(authorTextField, gbc);
    this.add(authorTextField);

    //
    // eMail
    //
    label = new JLabel("eMail :");
    label.setForeground(Color.black);

    gbc = makeGBC(0, 5, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.NORTHEAST;
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;

    gbl.addLayoutComponent(label, gbc);
    this.add(label);

    this.eMailTextField = new JTextField();
    this.eMailTextField.setHorizontalAlignment(JTextField.LEFT);

    gbc = makeGBC(1, 5, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.NORTHWEST;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(eMailTextField, gbc);
    this.add(eMailTextField);

    //
    // Homepage
    //
    label = new JLabel("Homepage :");
    label.setForeground(Color.black);

    gbc = makeGBC(0, 6, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.NORTHEAST;
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;

    gbl.addLayoutComponent(label, gbc);
    this.add(label);

    this.urlTextField = new JTextField();
    this.urlTextField.setHorizontalAlignment(JTextField.LEFT);

    gbc = makeGBC(1, 6, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.NORTHWEST;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(urlTextField, gbc);
    this.add(urlTextField);

    //
    // Gameversion
    //
    label = new JLabel("Spielversion :");
    label.setForeground(Color.black);

    gbc = makeGBC(0, 7, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.NORTHEAST;
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;

    gbl.addLayoutComponent(label, gbc);
    this.add(label);

    this.gameVersionTextField = new JTextField();
    this.gameVersionTextField.setHorizontalAlignment(JTextField.LEFT);

    gbc = makeGBC(1, 7, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.NORTHWEST;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(gameVersionTextField, gbc);
    this.add(gameVersionTextField);
  }

  /**
   * Hilfsmethode, um das GridBagLayout fr diese Methode zu verwenden.
   *
   * @param x       x-Anfangskoordinate im Gitternetz
   * @param y       y-Anfangskoordinate im Gitternetz
   * @param width   Erstreckung der Komponente in horizontaler Richtung auf dem Gitternetz
   * @param height  Erstreckung der KOmponente in vertikaler Richtung auf dem Gitternetz
   */
  protected GridBagConstraints makeGBC(int x, int y, int width, int height) {
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.gridx = x;
    gbc.gridy = y;
    gbc.gridwidth = width;
    gbc.gridheight = height;
    gbc.insets = new Insets(3, 4, 3, 4);
    return gbc;
  }
}