package pacman3d.labyrinth.leveleditor;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse ist eine Subklasse von {@link javax.swing.JToolBar JToolBar} und
 * kann als solche GUI-Komponente verwendet werden.<br>
 * Diese Subklasse stellt die im Leveleditor-Hauptfenster dargestellte <b>Toolbar</b>
 * dar, ber welche diverse Aktionen am Leveleditor durch den Benutzer ausgefhrt
 * werden knnen, wie z.B. ffnen und Speichern einer Labyrinthdatei, Auswahl
 * der zu editierenden Levelebene, Ein- bzw. Ausblendung gesetzter {@link
 * pacman3d.labyrinth.items.Item Items} und {@link pacman3d.monster.Monster
 * Monster} und auch Aktivierung diverser Hilfsmittel bei der Leveleditierung.<p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class JToolBarLeveleditor extends JToolBar implements java.awt.event.ActionListener {

  /**
   * Verzeichnis, in welchem sich die von der Toolbar bentigten Bilder befinden.
   */
  protected static URL url = null;
  static {
    url = ClassLoader.getSystemResource("pacman3d/labyrinth/leveleditor/images/");
  }

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, zum Aufruf des Fensters
   * zur Bearbeitung einer Instanz der Klasse {@link pacman3d.util.LevelMetaInfo
   * LevelMetaInfo}
   *
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton levelMetaInfoButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um in den
   * {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
   * 2D-Leveleditierungsbereich} hineinzuzoomen.
   *
   * @see #levelMetaInfoButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton zoomInButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um aus dem
   * {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
   * 2D-Leveleditierungsbereich} herauszuzoomen.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton zoomOutButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um auf dem
   * {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
   * 2D-Leveleditierungsbereich} ein Gitternetz ein- bzw. auszublenden.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton gridButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um auf dem
   * {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
   * 2D-Leveleditierungsbereich} im berarbeiteten Labyrinth befindliche
   * {@link pacman3d.labyrinth.items.Item Items} ein- bzw. auszublenden.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton itemsButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um auf dem
   * {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
   * 2D-Leveleditierungsbereich} im berarbeiteten Labyrinth befindliche
   * {@link pacman3d.monster.Monster Monster & Monsterstartpositionene} ein-
   * bzw. auszublenden.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton monsterButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um auf dem
   * {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
   * 2D-Leveleditierungsbereich} im berarbeiteten Labyrinth befindliche
   * {@link pacman3d.labyrinth.Position Pacmanstartpositionen} ein- bzw. auszublenden.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton pacmanStartpositionButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um die unterhalb
   * einer bearbeiteten Levelebene befindlichen begehbaren Zellen in die bearbeitete
   * Levelebene einzublenden.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton lowerLevelFloorButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um die unterhalb
   * einer bearbeiteten Levelebene befindlichen nicht begehbaren Zellen in die
   * bearbeitete Levelebene einzublenden.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton lowerLevelWallButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um die oberhalb
   * einer bearbeiteten Levelebene befindlichen begehbaren Zellen in die bearbeitete
   * Levelebene einzublenden.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton upperLevelFloorButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um die oberhalb
   * einer bearbeiteten Levelebene befindlichen nicht begehbaren Zellen in die
   * bearbeitete Levelebene einzublenden.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #buttonDecrease
   * @see #buttonIncrease
   */
  protected JButton upperLevelWallButton;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um die nchst niedrigere
   * Levelebene zur Bearbeitung auszuwhlen.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonIncrease
   */
  protected JButton buttonDecrease;

  /**
   * Instanz der Klasse {@link javax.swing.JButton JButton}, um die nchst hhere
   * Levelebene zur Bearbeitung auszuwhlen.
   *
   * @see #levelMetaInfoButton
   * @see #zoomInButton
   * @see #zoomOutButton
   * @see #gridButton
   * @see #itemsButton
   * @see #monsterButton
   * @see #pacmanStartpositionButton
   * @see #lowerLevelFloorButton
   * @see #lowerLevelWallButton
   * @see #upperLevelFloorButton
   * @see #upperLevelWallButton
   * @see #buttonDecrease
   */
  protected JButton buttonIncrease;

  /**
   * Instanz der Klasse {@link javax.swing.JTextField JTextField} zur direkten
   * Eingabe der zu bearbeiteten Levelebene.
   *
   * @see #buttonIncrease
   * @see #buttonIncrease
   * @see #level
   */
  protected JTextField textField;

  /**
   * Aktuell bearbeitete Levelebene.
   *
   * @see #maxLevel
   */
  protected int level = 1;

  /**
   * Maximale Anzahl der Ebenen des bearbeitetend Labyrinthes.
   *
   * @see #level
   */
  protected int maxLevel = 1;

  /**
   * Referenz auf diejenige Instanz der Klasse {@link
   * pacman3d.labyrinth.leveleditor.LevelEditingJPanel LevelEditingJPanel}, welche
   * das aktuell bearbeitete Labyrinth in einer 2D-Darstellung ebenenweie
   * darstellt.
   */
  protected LevelEditingJPanel editingJPanel = null;

  /**
   * Referenz auf die {@link pacman3d.labyrinth.leveleditor.Leveleditor Hauptklasse
   * des Leveleditors}, der diese Instanz instantiiert hat.
   */
  protected Leveleditor leveleditor = null;

  /**
   * Konstruktor:<p>
   * Initialisierung dieser Komponenten.
   *
   * @param leveleditor Referenz auf die {@link
   *        pacman3d.labyrinth.leveleditor.Leveleditor Hauptklasse des
   *        Leveleditors}, der diese Instanz instantiiert hat.
   */
  public JToolBarLeveleditor(Leveleditor leveleditor) {
    this.maxLevel = 1;
    this.leveleditor = leveleditor;
    this.editingJPanel = leveleditor.levelEditingJPanel;
    this.setFloatable(false);

    guiInit();
  }

  /**
   * Innerhalb dieser Methode erfolgt der Aufbau der Toolbar, d.h. die
   * Initialsierung der GUI und die notwendigen Initialisierungen der bentigten
   * Klassen. Diese Methode wird vom Konstruktor dieser Klasse automatisch aufgerufen
   * und sollte somit fr den Endanwender von keinem Interesse sein.
   *
   * @see #JToolBarLeveleditor
   */
  protected void guiInit() {
    int xpos = 0;
    //JPanel components
    GridBagLayout gbl       = new GridBagLayout();
    GridBagConstraints gbc  = null;
    this.setLayout(gbl);

    // JButtons fr ein
    // Neues Labyrinth
    JButton newLabyrinthButton = new JButton(new ImageIcon(url.getFile()+"new.gif"));
    newLabyrinthButton.setToolTipText("Neues Labyrinth");
    newLabyrinthButton.setActionCommand("Neues Labyrinth");
    newLabyrinthButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(newLabyrinthButton, gbc);
    this.add(newLabyrinthButton);

    // Labyrinth laden
    JButton openLabyrinthButton = new JButton(new ImageIcon(url.getFile()+"open.gif"));
    openLabyrinthButton.setToolTipText("Labyrinth laden");
    openLabyrinthButton.setActionCommand("Labyrinth laden");
    openLabyrinthButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(openLabyrinthButton, gbc);
    this.add(openLabyrinthButton);

    // Labyrinth abspeichern
    JButton saveLabyrinthButton = new JButton(new ImageIcon(url.getFile()+"save.gif"));
    saveLabyrinthButton.setToolTipText("Labyrinth speichern");
    saveLabyrinthButton.setActionCommand("Labyrinth speichern");
    saveLabyrinthButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(saveLabyrinthButton, gbc);
    this.add(saveLabyrinthButton);

    JSeparator separator = new JToolBar.Separator();
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbl.setConstraints(separator, gbc);
    this.add(separator);

    // LevelMetaInfo
    levelMetaInfoButton = new JButton(new ImageIcon(url.getFile()+"info.gif"));
    levelMetaInfoButton.setActionCommand("levelmetainfo");
    levelMetaInfoButton.addActionListener(leveleditor);
    levelMetaInfoButton.setEnabled(false);
    levelMetaInfoButton.setToolTipText("Levelinfo");

    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(levelMetaInfoButton, gbc);
    this.add(levelMetaInfoButton);

    separator = new JToolBar.Separator();
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbl.setConstraints(separator, gbc);
    this.add(separator);

    //
    // Komponenten fr's Zoomen...
    //
    zoomInButton = new JButton(new ImageIcon(url.getFile()+"zoom_in.gif"));
    zoomInButton.setEnabled(false);
    zoomInButton.setToolTipText("Zoom in");
    zoomInButton.setActionCommand("zoom in");
    zoomInButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.EAST;
    gbl.setConstraints(zoomInButton, gbc);
    this.add(zoomInButton);

    zoomOutButton = new JButton(new ImageIcon(url.getFile()+"zoom_out.gif"));
    zoomOutButton.setEnabled(false);
    zoomOutButton.setToolTipText("Zoom out");
    zoomOutButton.setActionCommand("zoom out");
    zoomOutButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(zoomOutButton, gbc);
    this.add(zoomOutButton);

    separator = new JToolBar.Separator();
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbl.setConstraints(separator, gbc);
    this.add(separator);

    // Grid
    gridButton = new JButton(new ImageIcon(url.getFile()+"grid.gif"));
    gridButton.setEnabled(false);
    gridButton.setToolTipText("Gitternetz ein/aus");

    gridButton.setActionCommand("grid off");
    gridButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(gridButton, gbc);
    this.add(gridButton);

    // Items anzeigen/ausblenden
    itemsButton = new JButton(new ImageIcon(url.getFile()+"cherry-32.gif"));
    itemsButton.setEnabled(false);
    itemsButton.setToolTipText("Items ein-/ausblenden");
    itemsButton.setActionCommand("show items");
    itemsButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(itemsButton, gbc);
    this.add(itemsButton);

    // Monster anzeigen/ausblenden
    monsterButton = new JButton(new ImageIcon(url.getFile()+"Kodos.gif"));
    monsterButton.setEnabled(false);
    monsterButton.setToolTipText("Monster & deren mglichen Startpositionen ein-/ausblenden");
    monsterButton.setActionCommand("show monsters & startpositions");
    monsterButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(monsterButton, gbc);
    this.add(monsterButton);

    // Pacmanstartpositionen ein- bzw. ausblenden
    pacmanStartpositionButton = new JButton(new ImageIcon(url.getFile()+"pacman.gif"));
    pacmanStartpositionButton.setEnabled(false);
    pacmanStartpositionButton.setToolTipText("Pacmanstartpositionen ein-/ausblenden");
    pacmanStartpositionButton.setActionCommand("show pacman startpositions");
    pacmanStartpositionButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(pacmanStartpositionButton, gbc);
    this.add(pacmanStartpositionButton);

    // Obere/untere Levelebene auf aktuell editierte Ebene projezieren
    lowerLevelFloorButton = new JButton(new ImageIcon(url.getFile()+"yellow_arrow_down.gif"));
    lowerLevelFloorButton.setEnabled(false);
    lowerLevelFloorButton.setToolTipText("Untere begehbare Zellen einblenden");
    lowerLevelFloorButton.setActionCommand("show lower level floors");
    lowerLevelFloorButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(lowerLevelFloorButton, gbc);
    this.add(lowerLevelFloorButton);

    lowerLevelWallButton = new JButton(new ImageIcon(url.getFile()+"yellow_arrow_down.gif"));
    lowerLevelWallButton.setEnabled(false);
    lowerLevelWallButton.setToolTipText("Untere nicht begehbare Zellen einblenden");
    lowerLevelWallButton.setActionCommand("show lower level walls");
    lowerLevelWallButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(lowerLevelWallButton, gbc);
    this.add(lowerLevelWallButton);

    upperLevelFloorButton = new JButton(new ImageIcon(url.getFile()+"yellow_arrow_up.gif"));
    upperLevelFloorButton.setEnabled(false);
    upperLevelFloorButton.setToolTipText("Obere begehbare Zellen einblenden");
    upperLevelFloorButton.setActionCommand("show upper level floors");
    upperLevelFloorButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(upperLevelFloorButton, gbc);
    this.add(upperLevelFloorButton);

    upperLevelWallButton = new JButton(new ImageIcon(url.getFile()+"yellow_arrow_up.gif"));
    upperLevelWallButton.setEnabled(false);
    upperLevelWallButton.setToolTipText("Obere nicht begehbare Zellen einblenden");
    upperLevelWallButton.setActionCommand("show upper level walls");
    upperLevelWallButton.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(upperLevelWallButton, gbc);
    this.add(upperLevelWallButton);

    // Levelebene
    separator = new JToolBar.Separator();
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbl.setConstraints(separator, gbc);
    this.add(separator);

    JLabel levelFloorSelectionLabel = new JLabel("Levelebene: ");
    levelFloorSelectionLabel.setForeground(Color.black);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(levelFloorSelectionLabel, gbc);
    this.add(levelFloorSelectionLabel);

    buttonDecrease = new JButton(new ImageIcon(url.getFile()+"left.gif"));
    buttonDecrease.setEnabled(false);
    buttonDecrease.setToolTipText("Eine Levelebene abwrts");
    buttonDecrease.setActionCommand("-");
    buttonDecrease.addActionListener(this);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.EAST;
    gbl.setConstraints(buttonDecrease, gbc);
    this.add(buttonDecrease);

    textField = new JTextField("1", 5);
    textField.setEnabled(false);
    textField.setSize(new Dimension(textField.getSize().width/5, textField.getSize().height));
    textField.setHorizontalAlignment(JTextField.CENTER);
    textField.addActionListener(this);
    textField.addActionListener(leveleditor);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbl.setConstraints(textField, gbc);
    JLabel floorLabel = new JLabel("1");
    floorLabel.setBackground(Color.white);
    floorLabel.setForeground(Color.black);
    this.add(textField);

    buttonIncrease = new JButton(new ImageIcon(url.getFile()+"right.gif"));
    buttonIncrease.setEnabled(false);
    buttonIncrease.setToolTipText("Eine Levelebene aufwrts");
    buttonIncrease.setActionCommand("+");
    buttonIncrease.addActionListener(this);
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(buttonIncrease, gbc);
    this.add(buttonIncrease);

    separator = new JToolBar.Separator();
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbl.setConstraints(separator, gbc);
    this.add(separator);

    JPanel dummyPanel = new JPanel();
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;
    gbl.setConstraints(dummyPanel, gbc);
    this.add(dummyPanel);

    // Farbe
    JButton colorButton = new JButton(new ImageIcon(url.getFile()+"colors.gif"));
    colorButton.setActionCommand("properties");
    colorButton.addActionListener(leveleditor);
    colorButton.setToolTipText("Farbeinstellung");
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(colorButton, gbc);
    this.add(colorButton);

    // Help
    JButton helpButton = new JButton(new ImageIcon(url.getFile()+"help.gif"));
    helpButton.setActionCommand("help");
    helpButton.addActionListener(leveleditor);
    helpButton.setToolTipText("Hilfe");
    gbc         = makeGBC(xpos++, 0, 1, 1);
    gbc.fill    = GridBagConstraints.NONE;
    gbc.anchor  = GridBagConstraints.WEST;
    gbl.setConstraints(helpButton, gbc);
    this.add(helpButton);


    //
    //  Komponenten fr "Floors/Walls nach unten/oben schlieen/ffnen"
    //
    /*
    GridBagLayout gblTools = new GridBagLayout();
    toolsJPanel.setLayout(gblTools);

    JButton closeFloorsByLowerWallsButton   = new JButton("Gnge nach unten durch Wnde schlieen");
    closeFloorsByLowerWallsButton.setActionCommand("closeFloorsToLower");
    closeFloorsByLowerWallsButton.addActionListener(actionListener);
    gbc           = makeGBC(0, 0, 1, 1);
    gbc.anchor    = GridBagConstraints.CENTER;
    gbc.fill      = GridBagConstraints.HORIZONTAL;
    gblTools.setConstraints(closeFloorsByLowerWallsButton, gbc);
    toolsJPanel.add(closeFloorsByLowerWallsButton);

    JButton openWallsByLowerFloorsButton    = new JButton("Wnde nach unten durch Gnge ffnen");
    openWallsByLowerFloorsButton.setActionCommand("openWallsToLower");
    openWallsByLowerFloorsButton.addActionListener(actionListener);
    gbc           = makeGBC(0, 1, 1, 1);
    gbc.anchor    = GridBagConstraints.CENTER;
    gbc.fill      = GridBagConstraints.HORIZONTAL;
    gblTools.setConstraints(openWallsByLowerFloorsButton, gbc);
    toolsJPanel.add(openWallsByLowerFloorsButton);

    JButton closeFloorsByUpperWallsButton   = new JButton("Gnge nach oben durch Wnde schlieen");
    closeFloorsByUpperWallsButton.setActionCommand("closeFloorsToUpper");
    closeFloorsByUpperWallsButton.addActionListener(actionListener);
    gbc           = makeGBC(0, 2, 1, 1);
    gbc.anchor    = GridBagConstraints.CENTER;
    gbc.fill      = GridBagConstraints.HORIZONTAL;
    gblTools.setConstraints(closeFloorsByUpperWallsButton, gbc);
    toolsJPanel.add(closeFloorsByUpperWallsButton);

    JButton openWallsByUpperFloorsButton    = new JButton("Wnde nach oben durch Gnge ffnen");
    openWallsByUpperFloorsButton.setActionCommand("openWallsToUpper");
    openWallsByUpperFloorsButton.addActionListener(actionListener);
    gbc           = makeGBC(0, 3, 1, 1);
    gbc.anchor    = GridBagConstraints.CENTER;
    gbc.fill      = GridBagConstraints.HORIZONTAL;
    gblTools.setConstraints(openWallsByUpperFloorsButton, gbc);
    toolsJPanel.add(openWallsByUpperFloorsButton);
    */
  }

  /**
   * Die durch das von dieser Klasse implementierte Interface {@link java.awt.event.ActionListener}
   * geforderte Methode, um auf {@link java.awt.event.ActionEvent ActionEvents} reagieren
   * und somit diverse Interaktion mit dem Benutzer des Leveleditors realisieren
   * zu knnen.<br>
   * Innerhalb dieser Methode erfolgt nur die ActionEvent-Verarbeitung der
   * GUI-Komponenten zur Auswahl der zu editierenden Levelebene. Genauer gesagt
   * sort diese Methode hier dafr, da nur sinnvolle Eingaben vom Benutzer fr
   * die Auswahl einer Levelebene getroffen werden knnen.
   *
   * @param actionEvent {@link java.awt.event.ActionEvent}
   *
   * @see java.awt.event.ActionListener
   */
  public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
    // Nchst hhere Levelebene zur Editierung auswhlen:
    if (actionEvent.getActionCommand().equals("+") && level < maxLevel-1) {
      textField.setText((++level)+"");
      if (editingJPanel != null)
            this.editingJPanel.setLevelToEdit(level);
    }
    // Nchst niedrigere Levelebene zur Editierung auswhlen:
    else if (actionEvent.getActionCommand().equals("-") && level > 0) {
      textField.setText((--level)+"");
      if (editingJPanel != null)
            this.editingJPanel.setLevelToEdit(level);
    }
    // Levelebene auswhlen, welche im JTextfield dieser Komponenten eingeben
    // wurde.
    else if (actionEvent.getSource() instanceof JTextField) {
      try {
        int value = Integer.parseInt(textField.getText());
        if (0 <= value && value < maxLevel) {
          level = value;
          if (editingJPanel != null)
            this.editingJPanel.setLevelToEdit(level);
        }
        else
          textField.setText(level+"");
      }
      catch (Exception exception) {
        textField.setText(level+"");
      }
    }
  }


  /**
   * Hilfsmethode fr den GridBagLayout-Manager.
   *
   * @param x x-Koordinate der einzufgenden Komponente.
   * @param y y-Koordinate der einzufgenden Komponente.
   * @param width Horizontal Ausbreitung der einzufgenden Komponente.
   * @param height Vertikale Ausbreitung der einzufgenden Komponente.
   *
   * @return java.awt.GridBagConstraints Instanz.
   */
   private GridBagConstraints makeGBC(int x, int y, int width, int height) {
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.gridx = x;
    gbc.gridy = y;
    gbc.gridwidth = width;
    gbc.gridheight = height;
    gbc.insets = new Insets(1, 1, 1, 1);
    gbc.weightx = 0.0f;
    gbc.weighty = 0.0f;
    return gbc;
  }

  /**
   * Wird dieser Methode der Wert <b>true</b> bergeben, so werden alle Komponenten
   * der durch diese Klasse reprsentierten Toolbar aktiviert, andernfalls
   * deaktiviert.
   *
   * @param state <b>true</b> Toolbar aktivieren, andernfalls Toolbar deaktivieren.
   */
  public void setEnabled(boolean state) {
    if (state) {
      levelMetaInfoButton.setEnabled(true);
      zoomInButton.setEnabled(true);
      zoomOutButton.setEnabled(true);
      gridButton.setEnabled(true);
      itemsButton.setEnabled(true);
      monsterButton.setEnabled(true);
      pacmanStartpositionButton.setEnabled(true);
      lowerLevelFloorButton.setEnabled(true);
      lowerLevelWallButton.setEnabled(true);
      upperLevelFloorButton.setEnabled(true);
      upperLevelWallButton.setEnabled(true);
      buttonDecrease.setEnabled(true);
      buttonIncrease.setEnabled(true);
      textField.setEnabled(true);
      textField.setText("1");

      this.editingJPanel = leveleditor.levelEditingJPanel;
      this.maxLevel = leveleditor.lab.getConstraints().y;
      this.level = 1;
    }
    else {
      levelMetaInfoButton.setEnabled(false);
      zoomInButton.setEnabled(false);
      zoomOutButton.setEnabled(false);
      gridButton.setEnabled(false);
      itemsButton.setEnabled(false);
      monsterButton.setEnabled(false);
      pacmanStartpositionButton.setEnabled(false);
      lowerLevelFloorButton.setEnabled(false);
      lowerLevelWallButton.setEnabled(false);
      upperLevelFloorButton.setEnabled(false);
      upperLevelWallButton.setEnabled(false);
      buttonDecrease.setEnabled(false);
      buttonIncrease.setEnabled(false);
      textField.setEnabled(false);
      textField.setText("");
    }
  }
}