package pacman3d.labyrinth.leveleditor;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse ist eine Subklasse von {@link javax.swing.JInternalFrame
 * JInternalFrame} und kann als solche GUI-Komponente verwendet werden.<br>
 * Diese Subklasse ist erweitert um Funktionalitt, so da der Benutzer durch
 * sie diverse Farben des {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
 * 2D-Leveleditierungsbereich} einstellen kann, wie z.B. die Farben zur Darstellung
 * der dem Leveleditor zur Verfgung stehenden {@link pacman3d.labyrinth.cells.Cell
 * Zellentypen} und {@link pacman3d.labyrinth.items.Item Items}, als auch z.B.
 * die Farbe eines auf dem {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
 * 2D-Leveleditierungsbereich} einblendbaren Gitternetzes und weiteren Hilfselementen,
 * zur einfacheren Leveleditierung.<p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class ColorChooser2DComponents extends JInternalFrame implements ActionListener {
  /**
   * Referenz auf die {@link pacman3d.labyrinth.leveleditor.Leveleditor Hauptklasse
   * des Leveleditors}, welche diese Klasse instantiiert. Diese Referenz dient
   * dazu, um auf diverse andere Klassen innerhalb des Packages des Leveleditors
   * Zugriff zu haben.
   */
  protected Leveleditor leveleditor;

  protected JButton selectedButton = null;

  /**
   * Instanz der Klasse {@link java.awt.Color Color}, um bei Auswahl einer neuen
   * Farbe durch den Benutzer die alte Farbe in diesem Feld zwischenzuspeichern,
   * falls die alte Farbe wieder hergestellt werden soll.
   */
  protected Color tmp_color =  Color.lightGray;

  /**
   * Instanz der Klasse {@link javax.swing.JColorChooser JColorChooser},
   * welche zur Auswahl der gewnschten Farbe durch den Benutzer verwendet
   * wird.
   */
  protected JColorChooser colorChooser = new JColorChooser(Color.black);

  /**
   * Instanz der Klasse {@link javax.swing.JInternalFrame JInternalFrame}, in
   * welcher sich der {@link #colorChooser JColorChooser} zur Farbauswahl
   * befindet.
   */
  protected JInternalFrame internalFrame;

  /**
   * Array vom Typ {@link java.lang.String String}, in welchem sich alle
   * Bezeichner der auszuwhlenden Farben befinden.
   *
   * @see #buttons
   * @see #colors
   */
  protected String[] labels = { "Gitternetz",
                                "Untere begehbare Zellen",
                                "Untere nicht begehbare Zellen",
                                "Obere begehbare Zellen",
                                "Obere nicht begehbare Zellen",
                                "Monster",
                                "Monsterstartpositionen",
                                "Pacmanstartpositionen",
                                "Items",
                                "Leerer Gang",
                                "Wand",
                                "Leiter",
                                "Fenster",
                                "Glasswand",
                                "Sule",
                                "Kegel",
                                "Torbogen",
                                "Tr",
                                "1/4 hohe Wand"
                              };

  /**
   * Array vom Typ {@link javax.swing.JButton JButton}, welche mit den Farben
   * aus dem Array {@link #colors} und den Bezeichnern {@link #labels} auf dem
   * Bildschirm dargestellt werden, so da der Benutzer durch Klicken auf den
   * entsprechenden JButton die gewnschte Farbe ndern kann.
   *
   * @see #labels
   * @see #colors
   */
  protected JButton[] buttons = new JButton[labels.length];

  /**
   * Array vom Typ {@link java.awt.Color Color}, in welchem sich alle vom Benutzer
   * vernderbare Farben der Komponenten des {@link
   * pacman3d.labyrinth.leveleditor.Leveleditor 2D-Darstellungsbereiches} befinden.
   *
   * @see #labels
   * @see #buttons
   */
  protected Color[] colors = { LevelEditingJPanel.colorGrid,
                               LevelEditingJPanel.colorLowerFloors,
                               LevelEditingJPanel.colorLowerWalls,
                               LevelEditingJPanel.colorUpperFloors,
                               LevelEditingJPanel.colorUpperWalls,
                               LevelEditingJPanel.colorMonster,
                               LevelEditingJPanel.colorMonsterStartPosition,
                               LevelEditingJPanel.colorPacmanStartPosition,
                               LevelEditingJPanel.colorItem,
                               LevelEditingJPanel.colorFloor,
                               LevelEditingJPanel.colorWall,
                               LevelEditingJPanel.colorLadder,
                               LevelEditingJPanel.colorSimpleWindow,
                               LevelEditingJPanel.colorGlassWall,
                               LevelEditingJPanel.colorSimplePillar,
                               LevelEditingJPanel.colorCone,
                               LevelEditingJPanel.colorArchway,
                               LevelEditingJPanel.colorSimpleDoor,
                               LevelEditingJPanel.colorQuaterHighWall
                              };


  /**
   * Konstruktor:<p>
   *
   * Zur Initialisierung dieser Klasse ist dieser Konstruktor mit einer Referenz
   * der aufrufenden {@link pacman3d.labyrinth.leveleditor.Leveleditor Hauptklasse
   * <b>leveleditor</b>} aufzurufen. ber diese Referenz verschafft sich dann
   * die entsprechende Instanz dieser Klasse Zugriff auf die fr die 2D-Leveleditierung
   * verwendete Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.LevelEditingJPanel
   * LevelEditingJPanel}, um dort evtl. die neuen Farben einzustellen, die vom
   * Benutzer in dieser Komponente neu eingestellt wurden.
   *
   * @see pacman3d.labyrinth.leveleditor.Leveleditor
   */
  public ColorChooser2DComponents(Leveleditor leveleditor) {
    super("Farbeinstellungen", true, true, true, true);
    this.setDefaultCloseOperation(JInternalFrame.HIDE_ON_CLOSE);
    this.setFrameIcon(new ImageIcon(leveleditor.url.getFile()+"colors.gif"));

    this.leveleditor = leveleditor;

    guiInit();
  }

  /**
   * Initialisierung diverser GUI-Einstellungen dieser Komponente. Diese Methode
   * wird automatisch vom Konstruktor dieser Klasse aufgerufen und sollte somit nicht
   * von Interesse fr den Endanwender sein.
   *
   * @see #ColorChooser2DComponents
   */
  protected void guiInit() {
    colorChooser.setPreviewPanel(new JPanel());

    // ChangeListener am ColorChooser registrieren, so da die vom Benutzer
    // eingestellten Farben interaktiv auf den Farbauswahlbuttons und auf
    // dem 2D-Leveleditierungsbereich erscheinen.
    colorChooser.getSelectionModel().addChangeListener( new ChangeListener() {
      public void stateChanged(ChangeEvent e) {
        selectedButton.setForeground(colorChooser.getSelectionModel().getSelectedColor());
        selectedButton.setBackground(colorChooser.getSelectionModel().getSelectedColor());

        if (leveleditor.levelEditingJPanel != null) {
          int i = 0;
          LevelEditingJPanel.colorGrid = buttons[i++].getBackground();
          LevelEditingJPanel.colorLowerFloors = buttons[i++].getBackground();
          LevelEditingJPanel.colorLowerWalls = buttons[i++].getBackground();
          LevelEditingJPanel.colorUpperFloors = buttons[i++].getBackground();
          LevelEditingJPanel.colorUpperWalls = buttons[i++].getBackground();
          LevelEditingJPanel.colorMonster = buttons[i++].getBackground();
          LevelEditingJPanel.colorMonsterStartPosition = buttons[i++].getBackground();
          LevelEditingJPanel.colorPacmanStartPosition = buttons[i++].getBackground();
          LevelEditingJPanel.colorItem = buttons[i++].getBackground();
          LevelEditingJPanel.colorFloor = buttons[i++].getBackground();
          LevelEditingJPanel.colorWall = buttons[i++].getBackground();
          LevelEditingJPanel.colorLadder = buttons[i++].getBackground();
          LevelEditingJPanel.colorSimpleWindow = buttons[i++].getBackground();
          LevelEditingJPanel.colorGlassWall = buttons[i++].getBackground();
          LevelEditingJPanel.colorSimplePillar = buttons[i++].getBackground();
          LevelEditingJPanel.colorCone = buttons[i++].getBackground();
          LevelEditingJPanel.colorArchway = buttons[i++].getBackground();
          LevelEditingJPanel.colorSimpleDoor = buttons[i++].getBackground();
          LevelEditingJPanel.colorQuaterHighWall = buttons[i++].getBackground();

          leveleditor.levelEditingJPanel.repaint();
        }
      }
    });

    GridBagLayout      gbl = new GridBagLayout();
    GridBagConstraints gbc = null;
    this.getContentPane().setLayout(new BorderLayout());

    JPanel panelForColorSelection = new JPanel(gbl);
    JScrollPane scrollPane = new JScrollPane(panelForColorSelection);
    this.getContentPane().add(scrollPane, BorderLayout.CENTER);

    internalFrame = new JInternalFrame("Farbauswahl", true, false, true, false);
    internalFrame.setDefaultCloseOperation(JInternalFrame.HIDE_ON_CLOSE);
    if (leveleditor.imageIcon != null)
      internalFrame.setFrameIcon(leveleditor.imageIcon);

    internalFrame.getContentPane().setLayout(new BorderLayout());
    internalFrame.getContentPane().add(this.colorChooser, BorderLayout.CENTER);

    JPanel panelCloseButtonsCC = new JPanel(new FlowLayout());
    internalFrame.getContentPane().add(panelCloseButtonsCC, BorderLayout.SOUTH);

    JButton okButtonCC = new JButton("Ok");
    okButtonCC.setActionCommand("okcc");
    okButtonCC.addActionListener(this);
    panelCloseButtonsCC.add(okButtonCC);

    JButton cancelButtonCC = new JButton("Abbrechen");
    cancelButtonCC.setActionCommand("cancelcc");
    cancelButtonCC.addActionListener(this);
    panelCloseButtonsCC.add(cancelButtonCC);

    internalFrame.pack();
    leveleditor.jDesktopPane.add(internalFrame);

    JLabel colorLabel   = null;
    JButton colorButton = null;

    for (int i = 0; i < labels.length; i++) {
      colorLabel = new JLabel(labels[i]);
      colorLabel.setForeground(Color.black);

      gbc         = makeGBC(1, i, 1, 1);
      gbc.fill    = GridBagConstraints.BOTH;
      gbc.anchor  = GridBagConstraints.CENTER;

      gbl.addLayoutComponent(colorLabel, gbc);
      panelForColorSelection.add(colorLabel);

      buttons[i] = new JButton("      ");
      buttons[i].addActionListener(this);
      buttons[i].setFocusPainted(false);
      buttons[i].setBorderPainted(true);
      buttons[i].setRolloverEnabled(false);
      buttons[i].setForeground(colors[i]);
      buttons[i].setBackground(colors[i]);

      gbc         = makeGBC(0, i, 1, 1);
      gbc.fill    = GridBagConstraints.BOTH;
      gbc.anchor  = GridBagConstraints.CENTER;

      gbl.addLayoutComponent(buttons[i], gbc);
      panelForColorSelection.add(buttons[i]);
    }

    JPanel panelForCloseButtons = new JPanel(new FlowLayout());
    this.getContentPane().add(panelForCloseButtons, BorderLayout.SOUTH);

    JButton okButton = new JButton("Ok");
    okButton.setActionCommand("ok");
    okButton.addActionListener(this);
    panelForCloseButtons.add(okButton);

    JButton cancelButton = new JButton("Abbrechen");
    cancelButton.setActionCommand("cancel");
    cancelButton.addActionListener(this);
    panelForCloseButtons.add(cancelButton);
  }

  /**
   * Die durch das von dieser Klasse implementierte Interface {@link java.awt.event.ActionListener}
   * geforderte Methode, um auf {@link java.awt.event.ActionEvent ActionEvents} reagieren
   * und somit diverse Interaktion mit dem Benutzer realisieren zu knnen.<br>
   * Innerhalb dieser Methode erfolgt die Verarbeitung der {@link
   * java.awt.event.ActionEvent ActionEvents}, die durch die {@link #buttons JButtons}
   * dieser Komponente generiert werden, wie z.B. Aufruf des {@link #colorChooser
   * JColorChooser} zur Einstellung einer Farbe als auch das Schlieen dieser
   * Komponente.
   *
   * @param actionEvent {@link java.awt.event.ActionEvent}
   *
   * @see java.awt.event.ActionListener
   */
  public void actionPerformed(ActionEvent actionEvent) {
    if (actionEvent.getActionCommand().equals("ok")) {
      // Farben der 2D-Leveleditierungskomponente mitteilen
      if (leveleditor.levelEditingJPanel != null) {
        int i = 0;
        colors[i] = LevelEditingJPanel.colorGrid = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorLowerFloors = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorLowerWalls = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorUpperFloors = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorUpperWalls = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorMonster = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorMonsterStartPosition = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorPacmanStartPosition = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorItem = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorFloor = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorWall = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorLadder = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorSimpleWindow = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorGlassWall = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorSimplePillar = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorCone = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorArchway = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorSimpleDoor = buttons[i++].getBackground();
        colors[i] = LevelEditingJPanel.colorQuaterHighWall = buttons[i++].getBackground();

        leveleditor.levelEditingJPanel.repaint();
      }
      // andernfalls nur intern die genderten Farben ablegen.
      else {
        for (int i = 0; i < buttons.length; i++)
          colors[i] = buttons[i].getBackground();
      }
      this.internalFrame.setVisible(false);
      this.setVisible(false);
    }
    // Alle gemachten Einstellungen rckgngig machen
    else if (actionEvent.getActionCommand().equals("cancel")) {
      for (int i = 0; i < buttons.length; i++) {
        buttons[i].setForeground(colors[i]);
        buttons[i].setBackground(colors[i]);
      }
      int j = 0;
      LevelEditingJPanel.colorGrid = colors[j++];
      LevelEditingJPanel.colorLowerFloors = colors[j++];
      LevelEditingJPanel.colorLowerWalls = colors[j++];
      LevelEditingJPanel.colorUpperFloors = colors[j++];
      LevelEditingJPanel.colorUpperWalls = colors[j++];
      LevelEditingJPanel.colorMonster = colors[j++];
      LevelEditingJPanel.colorMonsterStartPosition = colors[j++];
      LevelEditingJPanel.colorPacmanStartPosition = colors[j++];
      LevelEditingJPanel.colorItem = colors[j++];
      LevelEditingJPanel.colorFloor = colors[j++];
      LevelEditingJPanel.colorWall = colors[j++];
      LevelEditingJPanel.colorLadder = colors[j++];
      LevelEditingJPanel.colorSimpleWindow = colors[j++];
      LevelEditingJPanel.colorGlassWall = colors[j++];
      LevelEditingJPanel.colorSimplePillar = colors[j++];
      LevelEditingJPanel.colorCone = colors[j++];
      LevelEditingJPanel.colorArchway = colors[j++];
      LevelEditingJPanel.colorSimpleDoor = colors[j++];
      LevelEditingJPanel.colorQuaterHighWall = colors[j++];

      this.internalFrame.setVisible(false);
      this.setVisible(false);
    }
    // InternalFrame samt ColorChooser schlieen und Farben persisten
    // merken
    else if (actionEvent.getActionCommand().equals("okcc")) {
      this.internalFrame.setVisible(false);
    }
    // InternalFrame samt ColorChooser schlieen und gemachten Farbeinstellungen
    // rckgngig machen.
    else if (actionEvent.getActionCommand().equals("cancelcc")) {
      this.internalFrame.setVisible(false);
      this.selectedButton.setForeground(tmp_color);
      this.selectedButton.setBackground(tmp_color);
    }
    // ColorChooser aufrufen
    else {
      this.selectedButton = (JButton)actionEvent.getSource();
      this.tmp_color = selectedButton.getForeground();
      internalFrame.setVisible(true);
    }
  }

  /**
   * Hilfsmethode fr den GridBagLayout-Manager.
   *
   * @param x x-Koordinate der einzufgenden Komponente.
   * @param y y-Koordinate der einzufgenden Komponente.
   * @param width Horizontal Ausbreitung der einzufgenden Komponente.
   * @param height Vertikale Ausbreitung der einzufgenden Komponente.
   *
   * @return java.awt.GridBagConstraints Instanz.
   */
  private GridBagConstraints makeGBC(int x, int y, int width, int height) {
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.gridx = x;
    gbc.gridy = y;
    gbc.gridwidth = width;
    gbc.gridheight = height;
    gbc.insets = new Insets(4, 4, 4, 4);
    return gbc;
  }
}